// this :
#include <G4Lab/PhysicalVolumeAccessor.h>

// Inventor :
#include <Inventor/nodes/SoSeparator.h>

#ifdef WIN32
#undef pascal // Clash between windef.h and Geant4/SystemOfUnits.hh
#endif

// Geant4 :
#include <G4VPhysicalVolume.hh>
#include <G4LogicalVolume.hh>
#include <G4PhysicalVolumeStore.hh>
#include <G4TransportationManager.hh>
#include <G4Navigator.hh>

// Lib :
#include <Slash/Core/ISession.h>
#include <Slash/Data/IIterator.h>
#include <Lib/Out.h>
#include <Lib/Value.h>
#include <Lib/smanip.h>

// G4Lab :
#include <G4Lab/GeometryVisitor.h>
#include <G4Lab/SoVisitedVolume.h>

#define UNLIMITED (-1)

//////////////////////////////////////////////////////////////////////////////
G4Lab::PhysicalVolumeAccessor::PhysicalVolumeAccessor(
 Slash::Core::ISession& aSession
)
:OnX::InventorAccessor(aSession)
,fType("PV")
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  //addProperty("id",Lib::Property::POINTER);
  addProperty("name",Lib::Property::STRING);
  addProperty("daughters",Lib::Property::INTEGER);
}
//////////////////////////////////////////////////////////////////////////////
G4Lab::PhysicalVolumeAccessor::~PhysicalVolumeAccessor(
) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
}
//////////////////////////////////////////////////////////////////////////////
std::string G4Lab::PhysicalVolumeAccessor::name(
) const
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  return fType;
}
namespace G4Lab {
  class PhysicalVolumeIterator : public virtual Slash::Data::IIterator {
  public: //Slash::Data::IIterator
    virtual Slash::Data::IAccessor::Data object() {
      if(fIterator==fVector.end()) return 0;
      return *fIterator;
    }
    virtual void next() { ++fIterator; }
    virtual void* tag() { return 0;}
  public:
    PhysicalVolumeIterator(G4PhysicalVolumeStore& aVector):fVector(aVector) {
      fIterator = fVector.begin();
    }
    virtual ~PhysicalVolumeIterator() {}
  private:
    G4PhysicalVolumeStore& fVector;
    G4PhysicalVolumeStore::iterator fIterator;
  };
}  
//////////////////////////////////////////////////////////////////////////////
Slash::Data::IIterator* G4Lab::PhysicalVolumeAccessor::iterator(
) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  G4PhysicalVolumeStore* pvStore = G4PhysicalVolumeStore::GetInstance();
  if(!pvStore) {
    Lib::Out out(fSession.printer());
    out << "No physical volume store." << Lib::endl;
    return 0;
  }

  return new PhysicalVolumeIterator(*pvStore);
}
//////////////////////////////////////////////////////////////////////////////
Slash::Core::IValue* G4Lab::PhysicalVolumeAccessor::findValue(
 Slash::Data::IAccessor::Data aData
,const std::string& aName
,void*
) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  G4VPhysicalVolume* obj = (G4VPhysicalVolume*)aData;
  //if(aName=="id") {
  //  return new Lib::Value((void*)obj);
  //} else 
  if(aName=="name") {
    return new Lib::Value(obj->GetName());
  } else if(aName=="daughters") {
    G4LogicalVolume* logicalVolume = obj->GetLogicalVolume();
    return new Lib::Value(logicalVolume->GetNoDaughters());
  } else {
    return new Lib::Value();
  }
}
//////////////////////////////////////////////////////////////////////////////
void G4Lab::PhysicalVolumeAccessor::visualize(
 Slash::Data::IAccessor::Data aData
,void*
) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  G4TransportationManager* tsp = 
    G4TransportationManager::GetTransportationManager();
  if(!tsp) return;
  G4Navigator* nav = tsp->GetNavigatorForTracking();
  if(!nav) return;
  G4VPhysicalVolume* top = nav->GetWorldVolume(); 
  if(!top) return; 

  G4VPhysicalVolume* obj = (G4VPhysicalVolume*)aData;

  //Get a style corresponding to PV type.
 {std::string s = obj->GetName();
  Lib::smanip::strip(s);
  std::string style = "PV("+s+")";
  if(!isStyle(style)) {
    style = "PV_"+s; //Backward compatibility.
    if(!isStyle(style)) {
      style = "PV"; //Default.
    }
  }
  fillSoGC(style);}

  SoSeparator* separator = new SoSeparator;

  SoVisitedVolume soVisitedVolume(fSoGC,*separator,*obj);

  // WARNING : it may produces more than one scene object.
  //  (Because the same PV may be found more than once in the
  //   Geant4 geometry tree).
  GeometryVisitor geometryVisitor;
  G4Transform3D identity; //WIN32.
  geometryVisitor.visit(top,UNLIMITED,identity,&soVisitedVolume);

  // Send scene graph to the viewing region :
  if(separator->getNumChildren()) {
    fSoRegion->doIt(SbAddNode(separator,"staticScene"));
  } else {
    separator->unref();
  }
}
