// this :
#include <G4Lab/Polyhedron.h>

// Lib :
#include <Lib/Debug.h>

#ifdef WIN32
#undef pascal // Clash between windef.h and Geant4/SystemOfnits.hh
#endif

// Geant4 :
#include <G4Polyhedron.hh>

namespace G4Lab {

// To have access to G4Polyhedron::pF :
class G4_Polyhedron : public G4Polyhedron {
public:
  G4_Polyhedron(const G4Polyhedron& aFrom):G4Polyhedron(aFrom){
    Lib::Debug::increment("G4_Polyhedron");
  }
  virtual ~G4_Polyhedron() {
    Lib::Debug::decrement("G4_Polyhedron");
  }
  G4Facet& getFacet(int aIndex) const {return pF[aIndex];}
  virtual G4_Polyhedron& operator=(const G4_Polyhedron& aFrom) {
    G4Polyhedron::operator=(aFrom);
    return *this;
  }
};

}

//////////////////////////////////////////////////////////////////////////////
G4Lab::Polyhedron::Polyhedron(
 const G4Polyhedron& aFrom
)
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  Lib::Debug::increment("G4Lab::Polyhedron");
  G4_Polyhedron g4Pol(aFrom);
  if (g4Pol.GetNoVertices() > 0 && g4Pol.GetNoFacets() > 0) {
    nvert = g4Pol.GetNoVertices();
    nface = g4Pol.GetNoFacets();
    pV = new HVPoint3D[nvert + 1];
    pF = new SbFacet[nface + 1];
    int i;
    for (i=1; i<=nvert; i++) {
      HepGeom::Point3D<double> p = g4Pol.GetVertex(i);
      pV[i].setValue((float)p.x(),(float)p.y(),(float)p.z());
    }
    for (i=1; i<=nface; i++) {
      // Below is dangerous.
      pF[i] = (SbFacet&)g4Pol.getFacet(i);
    }
  }else{
    nvert = 0; nface = 0; pV = 0; pF = 0;
  }
}
//////////////////////////////////////////////////////////////////////////////
G4Lab::Polyhedron::~Polyhedron(
) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  Lib::Debug::decrement("G4Lab::Polyhedron");
}
//////////////////////////////////////////////////////////////////////////////
G4Lab::Polyhedron& G4Lab::Polyhedron::operator=(
 const Polyhedron& aFrom
) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  SbPolyhedron::operator=(aFrom);
  return *this;
}
//////////////////////////////////////////////////////////////////////////////
SbPolyhedron & G4Lab::Polyhedron::operator=(
 const SbPolyhedron& aFrom
) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  return SbPolyhedron::operator=(aFrom);
}
