
// this :
#include <G4Lab/SoG4RunManager.h>

// Inventor :
#include <Inventor/errors/SoDebugError.h>
#include <Inventor/actions/SoGLRenderAction.h>
#include <Inventor/bundles/SoMaterialBundle.h>

// Geant4 :
#include <G4RunManager.hh>
#include <G4UserSteppingAction.hh>

// GLab :
#include <G4Lab/SteppingAction.h>

SO_NODE_SOURCE(SoG4RunManager)
//////////////////////////////////////////////////////////////////////////////
void SoG4RunManager::initClass(
)
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  SO_NODE_INIT_CLASS(SoG4RunManager,SoNode,"Node");
}
//////////////////////////////////////////////////////////////////////////////
SoG4RunManager::SoG4RunManager(
)
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  SO_NODE_CONSTRUCTOR(SoG4RunManager);
  SO_NODE_ADD_FIELD(numberOfEvents,(1));
}
//////////////////////////////////////////////////////////////////////////////
SoG4RunManager::~SoG4RunManager(
)
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
}
//////////////////////////////////////////////////////////////////////////////
void SoG4RunManager::GLRender (
 SoGLRenderAction* aAction
)
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  G4RunManager* runManager = G4RunManager::GetRunManager();
  if(!runManager) return;

  G4Lab::SteppingAction* g4LabSteppingAction = 0;

  G4UserSteppingAction* steppingAction = 
    (G4UserSteppingAction*)runManager->GetUserSteppingAction();
  if(steppingAction) {
    g4LabSteppingAction = dynamic_cast<G4Lab::SteppingAction*>(steppingAction);
  }

  if(g4LabSteppingAction) g4LabSteppingAction->enable();

  // The G4Lab::SteppingAction::UserSteppingAction, that draw directly
  // with OpenGL will be perform here.

  //SoDebugError::postInfo("SoG4RunManager::GLRender","beamOn.");

  SoMaterialBundle mb(aAction);
  mb.sendFirst();

  runManager->BeamOn(numberOfEvents.getValue());

  if(g4LabSteppingAction) g4LabSteppingAction->disable();

}
