// this :
#include <G4Lab/SoVisitedVolume.h>

// Inventor :
#include <Inventor/errors/SoDebugError.h>
#include <Inventor/SoPickedPoint.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoTransform.h>
#include <Inventor/nodes/SoLightModel.h>
#include <Inventor/nodes/SoDrawStyle.h>
#include <Inventor/nodes/SoEventCallback.h>
#include <Inventor/events/SoMouseButtonEvent.h>

// HEPVis :
#include <HEPVis/SbPolyhedron.h>
#include <HEPVis/nodes/SoPolyhedron.h>
#include <HEPVis/nodes/SoHighlightMaterial.h>
#include <HEPVis/misc/SoGC.h>
#include <HEPVis/misc/SoStyleCache.h>

#ifdef WIN32
#undef pascal // Clash between windef.h and Geant4/SystemOfnits.hh
#endif

// Geant4 :
#include <G4Polyhedra.hh>
#include <G4Polyhedron.hh>
#include <G4Polyline.hh>
#include <G4Transform3D.hh>
#include <G4VPhysicalVolume.hh>
#include <G4Normal3D.hh>
#include <G4LogicalVolume.hh>
#include <G4VisAttributes.hh>

#include <G4Lab/GeometryVisitor.h>
#include <G4Lab/Transform3D.h>
#include <G4Lab/Polyhedron.h>

// Lib :
#include <Lib/smanip.h>

#define NOT_FOUND (-1)

//////////////////////////////////////////////////////////////////////////////
G4Lab::SoVisitedVolume::SoVisitedVolume(
 SoGC& aGC
,SoGroup& aParent
,G4VPhysicalVolume& aPhysicalVolume
)
:fSoGC(aGC)
,fParent(aParent)
,fPhysicalVolume(aPhysicalVolume)
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
}
//////////////////////////////////////////////////////////////////////////////
G4Lab::SoVisitedVolume::~SoVisitedVolume(
)
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
}
//////////////////////////////////////////////////////////////////////////////
G4Lab::IVisitedVolume::Status G4Lab::SoVisitedVolume::beginVolume(
 G4VPhysicalVolume* aPV
,G4VSolid* aSolid
,G4Material*
,const G4Transform3D& aTransform
,int //aIndex
)
//////////////////////////////////////////////////////////////////////////////
// Return true -> do not process daughters.
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  if(aPV!=(&fPhysicalVolume)) return IVisitedVolume::DAUGHTERS;

  if(aSolid) {
    G4Polyhedron* g4Polyhedron = aSolid->CreatePolyhedron();
    // Have to convert to an SbPolyhedron :
    Polyhedron* polyhedron = new Polyhedron(*g4Polyhedron);
    delete g4Polyhedron;
    if(polyhedron) {

      if(aPV->GetLogicalVolume()) {
        const G4VisAttributes* visAtbs = 
          aPV->GetLogicalVolume()->GetVisAttributes();
        if(visAtbs && (fSoGC.getLocalSetup()==TRUE)) {
          const G4Color& color = visAtbs->GetColor();
          //visible = visAtbs->IsVisible();

          float r = (float)color.GetRed();
          float g = (float)color.GetGreen();
          float b = (float)color.GetBlue();
          float t = 1 - (float)color.GetAlpha();

          std::string s;
          Lib::smanip::printf(s,128,"color %g %g %g\ntransparency %g",r,g,b,t);
          fSoGC.setFromString(s.c_str());
        }
      }

      // Build name (for picking) :
      std::string s;
      Lib::smanip::printf(s,128,"PV/0x%lx",aPV);
      SbName name(s.c_str());
 
      //FIXME : can't cache due to the below setName for picking.
      //FIXME SoPolyhedron* soPolyhedron = fSoGC.getPolyhedron(*polyhedron);
      SoPolyhedron* soPolyhedron = new SoPolyhedron(*polyhedron);
      if(fSoGC.getModeling()==SbModeling_wire_frame) {
        soPolyhedron->solid.setValue(FALSE);
        //FIXME : handle reduceWireFrame.
        soPolyhedron->reducedWireFrame.setValue(TRUE);
      } else {
        soPolyhedron->solid.setValue(TRUE);
      }
      delete polyhedron;
      soPolyhedron->setName(name);
        
#ifdef DEBUG
      printf("debug : G4Lab::SoVisitedVolume::visit : %s %s mode %d\n",
             aPV->GetName().c_str(),name.getString(),fMode);
#endif
      SoSeparator* separator = new SoSeparator;
      separator->setName("sceneGraph");
      
      separator->addChild(fSoGC.getHighlightMaterial());
      separator->addChild(fSoGC.getDrawStyle());
      separator->addChild(fSoGC.getLightModel());

      //separator->addChild(fSoGC.getStyleCache()->getResetTransform());

      SoTransform* transform = new SoTransform;
      Transform3D* t = new Transform3D(aTransform);
      SbMatrix* matrix = t->getMatrix();
      transform->setMatrix(*matrix);
      delete matrix;
      delete t;
      separator->addChild(transform);
          
      separator->addChild(soPolyhedron);

      fParent.addChild(separator);
    }
  }
 
  // Continue to next sibling PV 
  // (because a PV cannot be a daughter of itself).  
  return IVisitedVolume::SIBLING;
}
//////////////////////////////////////////////////////////////////////////////
void G4Lab::SoVisitedVolume::endVolume(
 G4VPhysicalVolume*
)
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
}
//////////////////////////////////////////////////////////////////////////////
void G4Lab::SoVisitedVolume::beginDaughters(
 G4VPhysicalVolume*
,int
)
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
}
//////////////////////////////////////////////////////////////////////////////
void G4Lab::SoVisitedVolume::endDaughters(
 G4VPhysicalVolume*
,int
)
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
}
