
// this :
#include <G4Lab/State.h>

//Geant4 :
#include <G4StateManager.hh>

// Lib :
#include <Slash/Core/ISession.h>

// OnX :
#include <Slash/UI/IScriptManager.h>

//////////////////////////////////////////////////////////////////////////////
G4Lab::State::State(
 Slash::UI::IScriptManager* aScriptManager
)
:fScriptManager(aScriptManager)
,fIsRunning(false)
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  //G4UImanager::GetUIpointer()->SetSession(this);  //So that Pause works..
}
//////////////////////////////////////////////////////////////////////////////
G4Lab::State::~State(
)
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  //G4UImanager::GetUIpointer()->SetSession(0);
}
//////////////////////////////////////////////////////////////////////////////
bool G4Lab::State::isRunning(
) const
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  return fIsRunning;
}
//////////////////////////////////////////////////////////////////////////////
void G4Lab::State::setRunBeginScript(
 const std::string& aInterp
,const std::string& aScript
)
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  fRunBeginInterp = aInterp;
  fRunBeginScript = aScript;
}
//////////////////////////////////////////////////////////////////////////////
void G4Lab::State::setRunEndScript(
 const std::string& aInterp
,const std::string& aScript
)
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  fRunEndInterp = aInterp;
  fRunEndScript = aScript;
}
//////////////////////////////////////////////////////////////////////////////
void G4Lab::State::setEventBeginScript(
 const std::string& aInterp
,const std::string& aScript
)
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  fEventBeginInterp = aInterp;
  fEventBeginScript = aScript;
}
//////////////////////////////////////////////////////////////////////////////
void G4Lab::State::setEventEndScript(
 const std::string& aInterp
,const std::string& aScript
)
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  fEventEndInterp = aInterp;
  fEventEndScript = aScript;
}
//////////////////////////////////////////////////////////////////////////////
G4bool G4Lab::State::Notify(
 G4ApplicationState aRequestedState
)
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  G4StateManager* statM = G4StateManager::GetStateManager();
  G4ApplicationState previousState = statM->GetPreviousState();

  if(previousState==G4State_Idle && aRequestedState==G4State_GeomClosed) {             
    fIsRunning = true;
    if(fScriptManager)
      fScriptManager->executeScript(fRunBeginInterp,fRunBeginScript);

  } else if(previousState==G4State_GeomClosed && aRequestedState==G4State_Idle) {      

    fIsRunning = false;
    if(fScriptManager)
      fScriptManager->executeScript(fRunEndInterp,fRunEndScript);

  } else if(previousState==G4State_GeomClosed && aRequestedState==G4State_EventProc) { 

    if(fScriptManager)
      fScriptManager->executeScript(fEventBeginInterp,fEventBeginScript);

  } else if(previousState==G4State_EventProc && aRequestedState==G4State_GeomClosed) { 

    // End of event : 
    //fScriptManager.out().println("debug : exec \"%s\" \"%s\"",
    //   fEventEndInterp.c_str(),
    //   fEventEndScript.c_str());
    if(fScriptManager)
      fScriptManager->executeScript(fEventEndInterp,fEventEndScript);

  }

  return true;
}
//////////////////////////////////////////////////////////////////////////////
void G4Lab::State::PauseSessionStart(
 G4String
)
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  /*
  if(aMessage=="G4_pause> ") { 
    WoProcessEvents ();
  }
  */
}




