
// this :
#include <G4Lab/SteppingAction.h>

// Geant4 :
#include <G4Step.hh>
#include <G4ThreeVector.hh>

#ifdef WIN32
#include <windows.h>
#endif
#ifdef APPLE_GL //Beurk
#include <gl.h>
#else
#include <GL/gl.h>
#endif

//////////////////////////////////////////////////////////////////////////////
G4Lab::SteppingAction::SteppingAction(
)
:fEnabled(false)
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{ 
}
//////////////////////////////////////////////////////////////////////////////
G4Lab::SteppingAction::~SteppingAction(
)
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{ 
}
//////////////////////////////////////////////////////////////////////////////
void G4Lab::SteppingAction::enable(
)
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{ 
  fEnabled = true;
}
//////////////////////////////////////////////////////////////////////////////
void G4Lab::SteppingAction::disable(
)
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{ 
  fEnabled = false;
}
//////////////////////////////////////////////////////////////////////////////
void G4Lab::SteppingAction::UserSteppingAction(
 const G4Step* aStep
)
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{ 
  render(aStep);
}
//////////////////////////////////////////////////////////////////////////////
void G4Lab::SteppingAction::render(
 const G4Step* aStep
)
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{ 
  if(!aStep) return;
  if(!fEnabled) return;

  //G4double charge = step->GetTrack()->GetDefinition()->GetPDGCharge();

  const G4ThreeVector& begin = aStep->GetPreStepPoint()->GetPosition();
  const G4ThreeVector& end = aStep->GetPostStepPoint ()->GetPosition();

  glBegin(GL_LINES);
  glVertex3d(begin.x(),begin.y(),begin.z());
  glVertex3d(end.x(),end.y(),end.z());
  glEnd();

  //  Flush here if we want to have a chance to see
  // step by step drawing :
  glFlush();
  glFinish();
}



