
// this :
#include <G4Lab/Trajectory.h>

// Lib :
#include <Lib/Debug.h>

// Geant4 :
#include <G4Track.hh>

static G4Allocator<G4Lab::Trajectory> sTrajectoryAllocator; // Beurk.

namespace G4Lab {
class TrajectoryPoint {
public:
  TrajectoryPoint(G4TrajectoryPoint* aPoint,double aGlobalTime)
    :fPoint(aPoint),fGlobalTime(aGlobalTime){}
  virtual ~TrajectoryPoint() { delete fPoint;}
  G4TrajectoryPoint* point() const { return fPoint;}
  double globalTime() const { return fGlobalTime;}
private:
  G4TrajectoryPoint* fPoint;
  double fGlobalTime;
  Lib::Debug fDebug; // To check memory balance.
};
}

//////////////////////////////////////////////////////////////////////////////
G4Lab::Trajectory::Trajectory(
 const G4Track* aTrack
)
:G4Trajectory(aTrack) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  fKineticEnergy = aTrack->GetKineticEnergy();
  fTotalEnergy = aTrack->GetTotalEnergy();
  fGlobalTime = aTrack->GetGlobalTime();
  /*
  printf("debug : G4Lab::Trajectory : \"%s\", kineticEnergy : %g, totalEnergy : %g, globalTime : %g\n",
         GetParticleName().c_str(),
         fKineticEnergy,fTotalEnergy,fGlobalTime);
  */
  TrajectoryPoint* tp = 
    new TrajectoryPoint(
     new G4TrajectoryPoint(aTrack->GetPosition()),
     aTrack->GetGlobalTime());
  fPoints.push_back(tp);
}
//////////////////////////////////////////////////////////////////////////////
G4Lab::Trajectory::Trajectory(
 Trajectory& aRight
)
:G4Trajectory(aRight) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  fKineticEnergy = aRight.fKineticEnergy;
  fTotalEnergy = aRight.fTotalEnergy;
  fGlobalTime = aRight.fGlobalTime;

  size_t number = aRight.fPoints.size();
  for(size_t index=0;index<number;index++) {
    G4TrajectoryPoint* point = aRight.fPoints[index]->point();
    TrajectoryPoint* tp = 
      new TrajectoryPoint(new G4TrajectoryPoint(*point),aRight.fGlobalTime);
    fPoints.push_back(tp);
  }
  
}
//////////////////////////////////////////////////////////////////////////////
G4Lab::Trajectory::~Trajectory(
) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  size_t number = fPoints.size();
  for(size_t index=0;index<number;index++) {
    delete fPoints[index];
  }
  fPoints.clear();
}
//////////////////////////////////////////////////////////////////////////////
G4double G4Lab::Trajectory::GetKineticEnergy(
) const 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  return fKineticEnergy;
}
//////////////////////////////////////////////////////////////////////////////
G4double G4Lab::Trajectory::GetTotalEnergy(
) const 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  return fTotalEnergy;
}
//////////////////////////////////////////////////////////////////////////////
G4double G4Lab::Trajectory::GetGlobalTime(
) const 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  return fGlobalTime;
}
//////////////////////////////////////////////////////////////////////////////
/*inline*/ void* G4Lab::Trajectory::operator new(
 size_t
)  
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  return (void*)sTrajectoryAllocator.MallocSingle();
}
//////////////////////////////////////////////////////////////////////////////
/*inline*/ void G4Lab::Trajectory::operator delete(
 void* aTrajectory
) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  sTrajectoryAllocator.FreeSingle((G4Lab::Trajectory*)aTrajectory);
}
//////////////////////////////////////////////////////////////////////////////
/*inline*/ int G4Lab::Trajectory::operator == (
 const G4Lab::Trajectory& aRight
) const 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  return (this==&aRight);
} 
//////////////////////////////////////////////////////////////////////////////
void G4Lab::Trajectory::ShowTrajectory(
 std::ostream&
) const
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
}
//////////////////////////////////////////////////////////////////////////////
void G4Lab::Trajectory::DrawTrajectory(
 G4int
) const
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
}
//////////////////////////////////////////////////////////////////////////////
void G4Lab::Trajectory::AppendStep(
 const G4Step* aStep
)
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  TrajectoryPoint* tp = 
    new TrajectoryPoint(
      new G4TrajectoryPoint(aStep->GetPostStepPoint()->GetPosition()),
      aStep->GetPostStepPoint()->GetGlobalTime());
  fPoints.push_back(tp);
}
//////////////////////////////////////////////////////////////////////////////
int G4Lab::Trajectory::GetPointEntries(
) const
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  return fPoints.size();
}
//////////////////////////////////////////////////////////////////////////////
G4VTrajectoryPoint* G4Lab::Trajectory::GetPoint(
 G4int aIndex
) const
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  return fPoints[aIndex]->point();
}
//////////////////////////////////////////////////////////////////////////////
G4double G4Lab::Trajectory::GetPointGlobalTime(
 G4int aIndex
) const
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  return fPoints[aIndex]->globalTime();
}
//////////////////////////////////////////////////////////////////////////////
void G4Lab::Trajectory::MergeTrajectory(
 G4VTrajectory* aTrajectory
)
//////////////////////////////////////////////////////////////////////////////
// Transfer points from aTrajectory to this.
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  if(!aTrajectory) return;
  Trajectory* tj = (Trajectory*)aTrajectory;
  size_t number = tj->fPoints.size();
  // initial point of the second trajectory should not be merged
  for(size_t index=1;index<number;index++) { 
    fPoints.push_back(tj->fPoints[index]);
  }
  delete tj->fPoints[0];
  tj->fPoints.clear();
}
