// this :
#include <G4Lab/Transform3D.h>

// Lib :
#include <Lib/Debug.h>

// Inventor :
#include <Inventor/SbMatrix.h>

//////////////////////////////////////////////////////////////////////////////
G4Lab::Transform3D::Transform3D(
 const G4Transform3D& aT
)
:G4Transform3D(aT) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  Lib::Debug::increment("G4Lab::Transform3D");
}
//////////////////////////////////////////////////////////////////////////////
G4Lab::Transform3D::~Transform3D(
)
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  Lib::Debug::decrement("G4Lab::Transform3D");
}
//////////////////////////////////////////////////////////////////////////////
float G4Lab::Transform3D::elem(
 int i
,int j
) const 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{ 
  return (float)(*this)(i,j);
}
//////////////////////////////////////////////////////////////////////////////
SbMatrix* G4Lab::Transform3D::getMatrix(
) const 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  return new SbMatrix(elem(0,0),elem(1,0),elem(2,0),0,
                      elem(0,1),elem(1,1),elem(2,1),0,
                      elem(0,2),elem(1,2),elem(2,2),0,
                      elem(0,3),elem(1,3),elem(2,3),1);
}
