
// this :
#include <G4Lab/Tree.h>

// Geant4 :
#include <G4PhysicalVolumeStore.hh>
#include <G4VPhysicalVolume.hh>
#include <G4LogicalVolume.hh>

//////////////////////////////////////////////////////////////////////////////
G4Lab::XML_VisitedVolume::XML_VisitedVolume(
 std::string& aOut
) 
:fOut(aOut)
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
}
//////////////////////////////////////////////////////////////////////////////
G4Lab::XML_VisitedVolume::~XML_VisitedVolume(
) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
}
//////////////////////////////////////////////////////////////////////////////
G4Lab::IVisitedVolume::Status G4Lab::XML_VisitedVolume::beginVolume(
 G4VPhysicalVolume* aPV
,G4VSolid*
,G4Material*
,const G4Transform3D&
,int
)
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  if(aPV->IsReplicated()) {
    if(aPV->GetCopyNo()==0) { //Do only the first copy.
      fOut += "<treeItem><label>";
      fOut += aPV->GetName();
      fOut += "</label>";
      return IVisitedVolume::DAUGHTERS;
    } else {
      return IVisitedVolume::SIBLING;
    }
  } else {
    fOut += "<treeItem><label>";
    fOut += aPV->GetName();
    fOut += "</label>";
    return IVisitedVolume::DAUGHTERS;
  }
}
//////////////////////////////////////////////////////////////////////////////
void G4Lab::XML_VisitedVolume::endVolume(
 G4VPhysicalVolume* aPV
)
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  if(aPV->IsReplicated()) {
    if(aPV->GetCopyNo()==0) {
      fOut += "</treeItem>";
    } else {
    }
  } else {
    fOut += "</treeItem>";
  }
}
//////////////////////////////////////////////////////////////////////////////
void G4Lab::XML_VisitedVolume::beginDaughters(
 G4VPhysicalVolume*
,int
)
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
}
//////////////////////////////////////////////////////////////////////////////
void G4Lab::XML_VisitedVolume::endDaughters(
 G4VPhysicalVolume*
,int
)
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
}
