// this :
#include <G4Lab/UIOnX.h>

// Geant4 :
#include <G4UImanager.hh>

// Lib :
#include <Slash/Core/ISession.h>
#include <Lib/Out.h>

// OnX :
#include <Slash/UI/IUI.h>
#include <OnX/Core/Main.h>

// G4Lab :
#include <G4Lab/Manager.h>

//////////////////////////////////////////////////////////////////////////////
G4Lab::UIOnX::UIOnX(
 G4RunManager& aRunManager
,const std::string& aGUI
,int aArgc
,char** aArgv
)
:fOnX(0)
,fUI(0)
,fManager(0)
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  std::vector<std::string> args;
  for(int index=0;index<aArgc;index++) args.push_back(aArgv[index]);
  if(aGUI!="") args.push_back(aGUI); //Should be the last argument.
  fOnX = new OnX::Main(false,false,args);
  if(!fOnX->isValid()) {
    delete fOnX;
    fOnX = 0;
    return;
  }

  Slash::Core::ISession* session = fOnX->session();
  if(session) {
    // An IGeant4Manager to pass the G4RunManager to the scripting.
    fManager = new Manager(*session,"Geant4Manager",&aRunManager);
    // Declare our Manager to the OnX session.
    // It must be done prior the creation of the UI (in order that the 
    // initialize callbacks script execute properly).
    session->addManager(fManager);
  }

  G4UImanager* uiManager = G4UImanager::GetUIpointer();
  if(uiManager) {
    uiManager->SetSession(this);
    //uiManager->SetCoutDestination(this);
  }
}
//////////////////////////////////////////////////////////////////////////////
G4Lab::UIOnX::~UIOnX(
) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{ 
  G4UImanager* uiManager = G4UImanager::GetUIpointer();
  if(uiManager) {
    uiManager->SetSession(NULL);
    //uiManager->SetCoutDestination(NULL);
  }

  delete fOnX;
}
//////////////////////////////////////////////////////////////////////////////
bool G4Lab::UIOnX::isValid(
) const
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  if(!fOnX) return false;
  if(!fOnX->session()) return false;
  return true;
}
//////////////////////////////////////////////////////////////////////////////
bool G4Lab::UIOnX::createUI(
 const std::string& aDriver
,const std::string& aFile
,bool aShow
)
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  if(!fUI) {
    if(!fOnX) return false;
    fUI = fOnX->createUI(aDriver,aFile,aShow);
  }
  if(!fUI) return false;
  return true;
}
//////////////////////////////////////////////////////////////////////////////
G4UIsession* G4Lab::UIOnX::SessionStart(
)
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  if(!fUI) {
    if(!fOnX) return 0;
    fUI = fOnX->createUI("","",true);
  }
  if(!fUI) return 0;
  fUI->steer();
  return this;
}
//////////////////////////////////////////////////////////////////////////////
void G4Lab::UIOnX::PauseSessionStart(
 G4String aState
)
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  if(!fOnX) return;

  Lib::Out out(fOnX->session()->printer());
  out << "G4UIOnX::PauseSessionStart : debug : " << aState << Lib::endl;

  if(aState=="G4_pause> ") { 
    //SecondaryLoop("Pause, type continue to exit this state");
  }

  if(aState=="EndOfEvent") {
    // Picking with feed back in event data Done here !!!
    //SecondaryLoop("End of event, type continue to exit this state");
  }
}
//////////////////////////////////////////////////////////////////////////////
Slash::Core::ISession* G4Lab::UIOnX::session(
)
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  if(!fOnX) return 0;
  return fOnX->session();
}
//////////////////////////////////////////////////////////////////////////////
Slash::Core::IWriter* G4Lab::UIOnX::printer(
)
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  if(!fOnX) return 0;
  Slash::Core::ISession* session = fOnX->session();
  if(!session) return 0;
  return &(session->printer());
}
//////////////////////////////////////////////////////////////////////////////
void G4Lab::UIOnX::addManager(
 Slash::Core::IManager* aManager
)
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  if(!fOnX) return;
  Slash::Core::ISession* session = fOnX->session();
  if(!session) return;
  session->addManager(aManager);
}
//////////////////////////////////////////////////////////////////////////////
void G4Lab::UIOnX::addAccessor(
 Slash::Data::IAccessor* aAccessor
)
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  if(!fManager) return;
  fManager->addAccessor(aAccessor);
}
//////////////////////////////////////////////////////////////////////////////
AIDA::IAnalysisFactory* G4Lab::UIOnX::findAIDA(
)
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  if(!fManager) return 0;
  return fManager->findAIDA();
}
