@ECHO OFF
SETLOCAL

REM #
REM # File produced by the obuild tool version 1.0
REM # for the package bhep with version v1r4p2.
REM #

REM #////////////////////////////////////////////////
REM # Usage :
REM #   DOS> CD some_path\pack\version\obuild
REM #   DOS> DOS\build_bhep
REM #
REM #////////////////////////////////////////////////

REM #////////////////////////////////////////////////
REM #/// Get path of this file :
REM #////////////////////////////////////////////////
SET obuild_bhep_path=%~dp0
REM # Remove ending \obuild\DOS\
SET obuild_bhep_path=%obuild_bhep_path:~0,-12%

REM #////////////////////////////////////////////////
REM #/// Treat arguments :
REM #////////////////////////////////////////////////

SET obuild_verbose=no
SET obuild_debug=no
SET obuild_optimize=yes
SET obuild_set_x=no

:next_arg
IF "%1%" == "" GOTO end_args

IF NOT "%1%" == "-v" GOTO end_if_v
  SET obuild_verbose=yes
  SHIFT
  GOTO next_arg
:end_if_v

IF NOT "%1%" == "-g" GOTO end_if_g
  SET obuild_debug=yes
  SHIFT
  GOTO next_arg
:end_if_g

IF NOT "%1%" == "-x" GOTO end_if_x
  SET obuild_set_x=yes
  SHIFT
  GOTO next_arg
:end_if_x

:end_args

REM #////////////////////////////////////////////////
REM #/// End arguments.
REM #////////////////////////////////////////////////

IF %obuild_set_x% == yes ECHO ON

IF %obuild_debug% == yes SET obuild_optimize=no

IF "%OBUILD_PLATFORM%" == "" (
  IF "%OS%" == "" ECHO Environment variable OS not found. & GOTO obuild_return
  SET obuild_platform=%OS%
) ELSE (
  SET obuild_platform=%OBUILD_PLATFORM%
)

IF "%obuild_platform%" == "" (
  ECHO obuild_platform variable not defined.
  GOTO obuild_return
)

IF "%OBUILD_DIR_BIN%" == "" (
  SET obuild_dir_bin=%obuild_platform%_obuild
) ELSE (
  SET obuild_dir_bin=%OBUILD_DIR_BIN%
)

IF "%obuild_dir_bin%" == "" (
  ECHO obuild_dir_bin variable not defined.
  GOTO obuild_return
)

IF NOT EXIST "%obuild_bhep_path%\%obuild_dir_bin%" MKDIR "%obuild_bhep_path%\%obuild_dir_bin%"

IF NOT EXIST "%obuild_bhep_path%\%obuild_dir_bin%" MKDIR "%obuild_bhep_path%\%obuild_dir_bin%"
IF NOT EXIST "%obuild_bhep_path%\%obuild_dir_bin%\obuild_platform.exe" (
  cl.exe /nologo /DWIN32 /MD /O2 /W3  /GX /GR /Fe"%obuild_bhep_path%\%obuild_dir_bin%\obuild_platform.exe" "%obuild_bhep_path%\obuild\cpp\obuild_platform.cpp" 1> NUL
  IF EXIST obuild_platform.obj DEL obuild_platform.obj
)

FOR /F "usebackq delims=;" %%d IN (`cd`) DO SET obuild_pwd_bhep_0=%%d
cd "%obuild_bhep_path%\%obuild_dir_bin%"
IF NOT EXIST .\obuild_platform.exe  ECHO Program obuild_platform.exe not found.  && GOTO obuild_return
FOR /F "usebackq" %%j IN (`.\obuild_platform.exe  %obuild_platform% UNIX`) DO SET obuild_platform_result=%%j
cd "%obuild_pwd_bhep_0%"
SET obuild_pwd_bhep_0=
IF NOT %obuild_platform_result% == yes GOTO end_if_platform_1
SET CLHEP_home=/usr/local/CLHEP/2.0.3.1
:end_if_platform_1
SET obuild_platform_result=
FOR /F "usebackq delims=;" %%d IN (`cd`) DO SET obuild_pwd_bhep_0=%%d
cd "%obuild_bhep_path%\%obuild_dir_bin%"
IF NOT EXIST .\obuild_platform.exe  ECHO Program obuild_platform.exe not found.  && GOTO obuild_return
FOR /F "usebackq" %%j IN (`.\obuild_platform.exe  %obuild_platform% UNIX`) DO SET obuild_platform_result=%%j
cd "%obuild_pwd_bhep_0%"
SET obuild_pwd_bhep_0=
IF NOT %obuild_platform_result% == yes GOTO end_if_platform_3
SET HDF5_home=/usr/local/HDF5/1.6.5
:end_if_platform_3
SET obuild_platform_result=
FOR /F "usebackq delims=;" %%d IN (`cd`) DO SET obuild_pwd_bhep_0=%%d
cd "%obuild_bhep_path%\%obuild_dir_bin%"
IF NOT EXIST .\obuild_platform.exe  ECHO Program obuild_platform.exe not found.  && GOTO obuild_return
FOR /F "usebackq" %%j IN (`.\obuild_platform.exe  %obuild_platform% UNIX`) DO SET obuild_platform_result=%%j
cd "%obuild_pwd_bhep_0%"
SET obuild_pwd_bhep_0=
IF NOT %obuild_platform_result% == yes GOTO end_if_platform_5
SET zlib_home=/usr
:end_if_platform_5
SET obuild_platform_result=
FOR /F "usebackq delims=;" %%d IN (`cd`) DO SET obuild_pwd_bhep_0=%%d
cd "%obuild_bhep_path%\%obuild_dir_bin%"
IF NOT EXIST .\obuild_platform.exe  ECHO Program obuild_platform.exe not found.  && GOTO obuild_return
FOR /F "usebackq" %%j IN (`.\obuild_platform.exe  %obuild_platform% Darwin`) DO SET obuild_platform_result=%%j
cd "%obuild_pwd_bhep_0%"
SET obuild_pwd_bhep_0=
IF NOT %obuild_platform_result% == yes GOTO end_if_platform_6
SET obuild_cxx_command=c++
:end_if_platform_6
SET obuild_platform_result=
FOR /F "usebackq delims=;" %%d IN (`cd`) DO SET obuild_pwd_bhep_0=%%d
cd "%obuild_bhep_path%\%obuild_dir_bin%"
IF NOT EXIST .\obuild_platform.exe  ECHO Program obuild_platform.exe not found.  && GOTO obuild_return
FOR /F "usebackq" %%j IN (`.\obuild_platform.exe  %obuild_platform% Linux`) DO SET obuild_platform_result=%%j
cd "%obuild_pwd_bhep_0%"
SET obuild_pwd_bhep_0=
IF NOT %obuild_platform_result% == yes GOTO end_if_platform_7
SET obuild_cxx_command=c++
:end_if_platform_7
SET obuild_platform_result=
FOR /F "usebackq delims=;" %%d IN (`cd`) DO SET obuild_pwd_bhep_0=%%d
cd "%obuild_bhep_path%\%obuild_dir_bin%"
IF NOT EXIST .\obuild_platform.exe  ECHO Program obuild_platform.exe not found.  && GOTO obuild_return
FOR /F "usebackq" %%j IN (`.\obuild_platform.exe  %obuild_platform% OSF1`) DO SET obuild_platform_result=%%j
cd "%obuild_pwd_bhep_0%"
SET obuild_pwd_bhep_0=
IF NOT %obuild_platform_result% == yes GOTO end_if_platform_8
SET obuild_cxx_command=cxx
:end_if_platform_8
SET obuild_platform_result=
FOR /F "usebackq delims=;" %%d IN (`cd`) DO SET obuild_pwd_bhep_0=%%d
cd "%obuild_bhep_path%\%obuild_dir_bin%"
IF NOT EXIST .\obuild_platform.exe  ECHO Program obuild_platform.exe not found.  && GOTO obuild_return
FOR /F "usebackq" %%j IN (`.\obuild_platform.exe  %obuild_platform% Windows_NT`) DO SET obuild_platform_result=%%j
cd "%obuild_pwd_bhep_0%"
SET obuild_pwd_bhep_0=
IF NOT %obuild_platform_result% == yes GOTO end_if_platform_9
SET obuild_cxx_command=cl.exe
:end_if_platform_9
SET obuild_platform_result=
IF "%obuild_cxx_command%" == ""  ECHO Variable obuild_cxx_command not defined.  && GOTO obuild_return

FOR /F "usebackq delims=;" %%d IN (`cd`) DO SET obuild_pwd_bhep_0=%%d
cd "%obuild_bhep_path%\%obuild_dir_bin%"
IF NOT EXIST .\obuild_platform.exe  ECHO Program obuild_platform.exe not found.  && GOTO obuild_return
FOR /F "usebackq" %%j IN (`.\obuild_platform.exe  %obuild_platform% Darwin`) DO SET obuild_platform_result=%%j
cd "%obuild_pwd_bhep_0%"
SET obuild_pwd_bhep_0=
IF NOT %obuild_platform_result% == yes GOTO end_if_platform_10
SET obuild_cxx_optimize=-O
:end_if_platform_10
SET obuild_platform_result=
FOR /F "usebackq delims=;" %%d IN (`cd`) DO SET obuild_pwd_bhep_0=%%d
cd "%obuild_bhep_path%\%obuild_dir_bin%"
IF NOT EXIST .\obuild_platform.exe  ECHO Program obuild_platform.exe not found.  && GOTO obuild_return
FOR /F "usebackq" %%j IN (`.\obuild_platform.exe  %obuild_platform% Linux`) DO SET obuild_platform_result=%%j
cd "%obuild_pwd_bhep_0%"
SET obuild_pwd_bhep_0=
IF NOT %obuild_platform_result% == yes GOTO end_if_platform_11
SET obuild_cxx_optimize=-O
:end_if_platform_11
SET obuild_platform_result=
FOR /F "usebackq delims=;" %%d IN (`cd`) DO SET obuild_pwd_bhep_0=%%d
cd "%obuild_bhep_path%\%obuild_dir_bin%"
IF NOT EXIST .\obuild_platform.exe  ECHO Program obuild_platform.exe not found.  && GOTO obuild_return
FOR /F "usebackq" %%j IN (`.\obuild_platform.exe  %obuild_platform% OSF1`) DO SET obuild_platform_result=%%j
cd "%obuild_pwd_bhep_0%"
SET obuild_pwd_bhep_0=
IF NOT %obuild_platform_result% == yes GOTO end_if_platform_12
SET obuild_cxx_optimize=-O
:end_if_platform_12
SET obuild_platform_result=
FOR /F "usebackq delims=;" %%d IN (`cd`) DO SET obuild_pwd_bhep_0=%%d
cd "%obuild_bhep_path%\%obuild_dir_bin%"
IF NOT EXIST .\obuild_platform.exe  ECHO Program obuild_platform.exe not found.  && GOTO obuild_return
FOR /F "usebackq" %%j IN (`.\obuild_platform.exe  %obuild_platform% Windows_NT`) DO SET obuild_platform_result=%%j
cd "%obuild_pwd_bhep_0%"
SET obuild_pwd_bhep_0=
IF NOT %obuild_platform_result% == yes GOTO end_if_platform_13
SET obuild_cxx_optimize=/O2
:end_if_platform_13
SET obuild_platform_result=

FOR /F "usebackq delims=;" %%d IN (`cd`) DO SET obuild_pwd_bhep_0=%%d
cd "%obuild_bhep_path%\%obuild_dir_bin%"
IF NOT EXIST .\obuild_platform.exe  ECHO Program obuild_platform.exe not found.  && GOTO obuild_return
FOR /F "usebackq" %%j IN (`.\obuild_platform.exe  %obuild_platform% Darwin`) DO SET obuild_platform_result=%%j
cd "%obuild_pwd_bhep_0%"
SET obuild_pwd_bhep_0=
IF NOT %obuild_platform_result% == yes GOTO end_if_platform_14
SET obuild_cxx_debug=-g
:end_if_platform_14
SET obuild_platform_result=
FOR /F "usebackq delims=;" %%d IN (`cd`) DO SET obuild_pwd_bhep_0=%%d
cd "%obuild_bhep_path%\%obuild_dir_bin%"
IF NOT EXIST .\obuild_platform.exe  ECHO Program obuild_platform.exe not found.  && GOTO obuild_return
FOR /F "usebackq" %%j IN (`.\obuild_platform.exe  %obuild_platform% Linux`) DO SET obuild_platform_result=%%j
cd "%obuild_pwd_bhep_0%"
SET obuild_pwd_bhep_0=
IF NOT %obuild_platform_result% == yes GOTO end_if_platform_15
SET obuild_cxx_debug=-g
:end_if_platform_15
SET obuild_platform_result=
FOR /F "usebackq delims=;" %%d IN (`cd`) DO SET obuild_pwd_bhep_0=%%d
cd "%obuild_bhep_path%\%obuild_dir_bin%"
IF NOT EXIST .\obuild_platform.exe  ECHO Program obuild_platform.exe not found.  && GOTO obuild_return
FOR /F "usebackq" %%j IN (`.\obuild_platform.exe  %obuild_platform% OSF1`) DO SET obuild_platform_result=%%j
cd "%obuild_pwd_bhep_0%"
SET obuild_pwd_bhep_0=
IF NOT %obuild_platform_result% == yes GOTO end_if_platform_16
SET obuild_cxx_debug=-g
:end_if_platform_16
SET obuild_platform_result=
FOR /F "usebackq delims=;" %%d IN (`cd`) DO SET obuild_pwd_bhep_0=%%d
cd "%obuild_bhep_path%\%obuild_dir_bin%"
IF NOT EXIST .\obuild_platform.exe  ECHO Program obuild_platform.exe not found.  && GOTO obuild_return
FOR /F "usebackq" %%j IN (`.\obuild_platform.exe  %obuild_platform% Windows_NT`) DO SET obuild_platform_result=%%j
cd "%obuild_pwd_bhep_0%"
SET obuild_pwd_bhep_0=
IF NOT %obuild_platform_result% == yes GOTO end_if_platform_17
SET obuild_cxx_debug=/ZI /Od
:end_if_platform_17
SET obuild_platform_result=

FOR /F "usebackq delims=;" %%d IN (`cd`) DO SET obuild_pwd_bhep_0=%%d
cd "%obuild_bhep_path%\%obuild_dir_bin%"
IF NOT EXIST .\obuild_platform.exe  ECHO Program obuild_platform.exe not found.  && GOTO obuild_return
FOR /F "usebackq" %%j IN (`.\obuild_platform.exe  %obuild_platform% Linux`) DO SET obuild_platform_result=%%j
cd "%obuild_pwd_bhep_0%"
SET obuild_pwd_bhep_0=
IF NOT %obuild_platform_result% == yes GOTO end_if_platform_18
SET obuild_cxx_options=-fPIC
:end_if_platform_18
SET obuild_platform_result=
FOR /F "usebackq delims=;" %%d IN (`cd`) DO SET obuild_pwd_bhep_0=%%d
cd "%obuild_bhep_path%\%obuild_dir_bin%"
IF NOT EXIST .\obuild_platform.exe  ECHO Program obuild_platform.exe not found.  && GOTO obuild_return
FOR /F "usebackq" %%j IN (`.\obuild_platform.exe  %obuild_platform% Windows_NT`) DO SET obuild_platform_result=%%j
cd "%obuild_pwd_bhep_0%"
SET obuild_pwd_bhep_0=
IF NOT %obuild_platform_result% == yes GOTO end_if_platform_19
SET obuild_cxx_options=/nologo /DWIN32 /MD /GX /GR /W3
:end_if_platform_19
SET obuild_platform_result=

IF NOT %obuild_debug% == yes GOTO else_if_db_build_lib_bhep_sh_20
  SET obuild_cxx_debug_local=%obuild_cxx_debug%
  GOTO end_if_db_build_lib_bhep_sh_20
:else_if_db_build_lib_bhep_sh_20
  SET obuild_cxx_debug_local=
:end_if_db_build_lib_bhep_sh_20

IF NOT %obuild_optimize% == yes GOTO else_if_opt_build_lib_bhep_sh_21
  SET obuild_cxx_optimize_local=%obuild_cxx_optimize%
  GOTO end_if_opt_build_lib_bhep_sh_21
:else_if_opt_build_lib_bhep_sh_21
  SET obuild_cxx_optimize_local=
:end_if_opt_build_lib_bhep_sh_21



SET obuild_cxx_includes=/I"%obuild_bhep_path%"
SET obuild_cxx_includes=%obuild_cxx_includes% /I"%obuild_bhep_path%\bhep"
FOR /F "usebackq delims=;" %%d IN (`cd`) DO SET obuild_pwd_bhep_0=%%d
cd "%obuild_bhep_path%\%obuild_dir_bin%"
IF NOT EXIST .\obuild_platform.exe  ECHO Program obuild_platform.exe not found.  && GOTO obuild_return
FOR /F "usebackq" %%j IN (`.\obuild_platform.exe  %obuild_platform% UNIX`) DO SET obuild_platform_result=%%j
cd "%obuild_pwd_bhep_0%"
SET obuild_pwd_bhep_0=
IF NOT %obuild_platform_result% == yes GOTO end_if_platform_24
SET obuild_cxx_includes=%obuild_cxx_includes% -I${CLHEP_home}/include
:end_if_platform_24
SET obuild_platform_result=
FOR /F "usebackq delims=;" %%d IN (`cd`) DO SET obuild_pwd_bhep_0=%%d
cd "%obuild_bhep_path%\%obuild_dir_bin%"
IF NOT EXIST .\obuild_platform.exe  ECHO Program obuild_platform.exe not found.  && GOTO obuild_return
FOR /F "usebackq" %%j IN (`.\obuild_platform.exe  %obuild_platform% UNIX`) DO SET obuild_platform_result=%%j
cd "%obuild_pwd_bhep_0%"
SET obuild_pwd_bhep_0=
IF NOT %obuild_platform_result% == yes GOTO end_if_platform_25
SET obuild_cxx_includes=%obuild_cxx_includes% -I${HDF5_home}/include
:end_if_platform_25
SET obuild_platform_result=

IF EXIST "%obuild_bhep_path%\%obuild_dir_bin%\lib_bhep" RMDIR /S /Q "%obuild_bhep_path%\%obuild_dir_bin%\lib_bhep"
IF NOT EXIST "%obuild_bhep_path%\%obuild_dir_bin%\lib_bhep" MKDIR "%obuild_bhep_path%\%obuild_dir_bin%\lib_bhep"

REM # pre_build scripts :
FOR /F "usebackq delims=;" %%d IN (`cd`) DO SET obuild_pwd_bhep_0=%%d
cd "%obuild_bhep_path%\%obuild_dir_bin%"
IF NOT EXIST .\obuild_platform.exe  ECHO Program obuild_platform.exe not found.  && GOTO obuild_return
FOR /F "usebackq" %%j IN (`.\obuild_platform.exe  %obuild_platform% UNIX`) DO SET obuild_platform_result=%%j
cd "%obuild_pwd_bhep_0%"
SET obuild_pwd_bhep_0=
IF NOT %obuild_platform_result% == yes GOTO end_if_platform_26
./pre_build
:end_if_platform_26
SET obuild_platform_result=

@IF %obuild_verbose% == yes @ECHO ON 
cd "%obuild_bhep_path%\%obuild_dir_bin%"
%obuild_cxx_command% /c %obuild_cxx_debug_local% %obuild_cxx_optimize_local% %obuild_cxx_options% %obuild_cxx_macros% %obuild_cxx_includes% /Fo.\lib_bhep\version.obj  /Tp"..\source\version.cpp" 1> cl_exe_error
@IF ERRORLEVEL 1 @TYPE cl_exe_error && @GOTO obuild_return
@IF NOT ERRORLEVEL 1 @DEL cl_exe_error
cd "%obuild_bhep_path%\obuild"

cd "%obuild_bhep_path%\%obuild_dir_bin%"
%obuild_cxx_command% /c %obuild_cxx_debug_local% %obuild_cxx_optimize_local% %obuild_cxx_options% %obuild_cxx_macros% %obuild_cxx_includes% /Fo.\lib_bhep\event.obj  /Tp"..\source\base\event.cpp" 1> cl_exe_error
@IF ERRORLEVEL 1 @TYPE cl_exe_error && @GOTO obuild_return
@IF NOT ERRORLEVEL 1 @DEL cl_exe_error
cd "%obuild_bhep_path%\obuild"

cd "%obuild_bhep_path%\%obuild_dir_bin%"
%obuild_cxx_command% /c %obuild_cxx_debug_local% %obuild_cxx_optimize_local% %obuild_cxx_options% %obuild_cxx_macros% %obuild_cxx_includes% /Fo.\lib_bhep\hit.obj  /Tp"..\source\base\hit.cpp" 1> cl_exe_error
@IF ERRORLEVEL 1 @TYPE cl_exe_error && @GOTO obuild_return
@IF NOT ERRORLEVEL 1 @DEL cl_exe_error
cd "%obuild_bhep_path%\obuild"

cd "%obuild_bhep_path%\%obuild_dir_bin%"
%obuild_cxx_command% /c %obuild_cxx_debug_local% %obuild_cxx_optimize_local% %obuild_cxx_options% %obuild_cxx_macros% %obuild_cxx_includes% /Fo.\lib_bhep\mparticle.obj  /Tp"..\source\base\mparticle.cpp" 1> cl_exe_error
@IF ERRORLEVEL 1 @TYPE cl_exe_error && @GOTO obuild_return
@IF NOT ERRORLEVEL 1 @DEL cl_exe_error
cd "%obuild_bhep_path%\obuild"

cd "%obuild_bhep_path%\%obuild_dir_bin%"
%obuild_cxx_command% /c %obuild_cxx_debug_local% %obuild_cxx_optimize_local% %obuild_cxx_options% %obuild_cxx_macros% %obuild_cxx_includes% /Fo.\lib_bhep\particle.obj  /Tp"..\source\base\particle.cpp" 1> cl_exe_error
@IF ERRORLEVEL 1 @TYPE cl_exe_error && @GOTO obuild_return
@IF NOT ERRORLEVEL 1 @DEL cl_exe_error
cd "%obuild_bhep_path%\obuild"

cd "%obuild_bhep_path%\%obuild_dir_bin%"
%obuild_cxx_command% /c %obuild_cxx_debug_local% %obuild_cxx_optimize_local% %obuild_cxx_options% %obuild_cxx_macros% %obuild_cxx_includes% /Fo.\lib_bhep\sparticle.obj  /Tp"..\source\base\sparticle.cpp" 1> cl_exe_error
@IF ERRORLEVEL 1 @TYPE cl_exe_error && @GOTO obuild_return
@IF NOT ERRORLEVEL 1 @DEL cl_exe_error
cd "%obuild_bhep_path%\obuild"

cd "%obuild_bhep_path%\%obuild_dir_bin%"
%obuild_cxx_command% /c %obuild_cxx_debug_local% %obuild_cxx_optimize_local% %obuild_cxx_options% %obuild_cxx_macros% %obuild_cxx_includes% /Fo.\lib_bhep\track.obj  /Tp"..\source\base\track.cpp" 1> cl_exe_error
@IF ERRORLEVEL 1 @TYPE cl_exe_error && @GOTO obuild_return
@IF NOT ERRORLEVEL 1 @DEL cl_exe_error
cd "%obuild_bhep_path%\obuild"

cd "%obuild_bhep_path%\%obuild_dir_bin%"
%obuild_cxx_command% /c %obuild_cxx_debug_local% %obuild_cxx_optimize_local% %obuild_cxx_options% %obuild_cxx_macros% %obuild_cxx_includes% /Fo.\lib_bhep\material.obj  /Tp"..\source\util\material.cpp" 1> cl_exe_error
@IF ERRORLEVEL 1 @TYPE cl_exe_error && @GOTO obuild_return
@IF NOT ERRORLEVEL 1 @DEL cl_exe_error
cd "%obuild_bhep_path%\obuild"

cd "%obuild_bhep_path%\%obuild_dir_bin%"
%obuild_cxx_command% /c %obuild_cxx_debug_local% %obuild_cxx_optimize_local% %obuild_cxx_options% %obuild_cxx_macros% %obuild_cxx_includes% /Fo.\lib_bhep\particle_definition.obj  /Tp"..\source\util\particle_definition.cpp" 1> cl_exe_error
@IF ERRORLEVEL 1 @TYPE cl_exe_error && @GOTO obuild_return
@IF NOT ERRORLEVEL 1 @DEL cl_exe_error
cd "%obuild_bhep_path%\obuild"

cd "%obuild_bhep_path%\%obuild_dir_bin%"
%obuild_cxx_command% /c %obuild_cxx_debug_local% %obuild_cxx_optimize_local% %obuild_cxx_options% %obuild_cxx_macros% %obuild_cxx_includes% /Fo.\lib_bhep\ray.obj  /Tp"..\source\util\ray.cpp" 1> cl_exe_error
@IF ERRORLEVEL 1 @TYPE cl_exe_error && @GOTO obuild_return
@IF NOT ERRORLEVEL 1 @DEL cl_exe_error
cd "%obuild_bhep_path%\obuild"

cd "%obuild_bhep_path%\%obuild_dir_bin%"
%obuild_cxx_command% /c %obuild_cxx_debug_local% %obuild_cxx_optimize_local% %obuild_cxx_options% %obuild_cxx_macros% %obuild_cxx_includes% /Fo.\lib_bhep\event_cvt.obj  /Tp"..\source\converters\event_cvt.cpp" 1> cl_exe_error
@IF ERRORLEVEL 1 @TYPE cl_exe_error && @GOTO obuild_return
@IF NOT ERRORLEVEL 1 @DEL cl_exe_error
cd "%obuild_bhep_path%\obuild"

cd "%obuild_bhep_path%\%obuild_dir_bin%"
%obuild_cxx_command% /c %obuild_cxx_debug_local% %obuild_cxx_optimize_local% %obuild_cxx_options% %obuild_cxx_macros% %obuild_cxx_includes% /Fo.\lib_bhep\hit_cvt.obj  /Tp"..\source\converters\hit_cvt.cpp" 1> cl_exe_error
@IF ERRORLEVEL 1 @TYPE cl_exe_error && @GOTO obuild_return
@IF NOT ERRORLEVEL 1 @DEL cl_exe_error
cd "%obuild_bhep_path%\obuild"

cd "%obuild_bhep_path%\%obuild_dir_bin%"
%obuild_cxx_command% /c %obuild_cxx_debug_local% %obuild_cxx_optimize_local% %obuild_cxx_options% %obuild_cxx_macros% %obuild_cxx_includes% /Fo.\lib_bhep\mparticle_cvt.obj  /Tp"..\source\converters\mparticle_cvt.cpp" 1> cl_exe_error
@IF ERRORLEVEL 1 @TYPE cl_exe_error && @GOTO obuild_return
@IF NOT ERRORLEVEL 1 @DEL cl_exe_error
cd "%obuild_bhep_path%\obuild"

cd "%obuild_bhep_path%\%obuild_dir_bin%"
%obuild_cxx_command% /c %obuild_cxx_debug_local% %obuild_cxx_optimize_local% %obuild_cxx_options% %obuild_cxx_macros% %obuild_cxx_includes% /Fo.\lib_bhep\particle_cvt.obj  /Tp"..\source\converters\particle_cvt.cpp" 1> cl_exe_error
@IF ERRORLEVEL 1 @TYPE cl_exe_error && @GOTO obuild_return
@IF NOT ERRORLEVEL 1 @DEL cl_exe_error
cd "%obuild_bhep_path%\obuild"

cd "%obuild_bhep_path%\%obuild_dir_bin%"
%obuild_cxx_command% /c %obuild_cxx_debug_local% %obuild_cxx_optimize_local% %obuild_cxx_options% %obuild_cxx_macros% %obuild_cxx_includes% /Fo.\lib_bhep\sparticle_cvt.obj  /Tp"..\source\converters\sparticle_cvt.cpp" 1> cl_exe_error
@IF ERRORLEVEL 1 @TYPE cl_exe_error && @GOTO obuild_return
@IF NOT ERRORLEVEL 1 @DEL cl_exe_error
cd "%obuild_bhep_path%\obuild"

cd "%obuild_bhep_path%\%obuild_dir_bin%"
%obuild_cxx_command% /c %obuild_cxx_debug_local% %obuild_cxx_optimize_local% %obuild_cxx_options% %obuild_cxx_macros% %obuild_cxx_includes% /Fo.\lib_bhep\track_cvt.obj  /Tp"..\source\converters\track_cvt.cpp" 1> cl_exe_error
@IF ERRORLEVEL 1 @TYPE cl_exe_error && @GOTO obuild_return
@IF NOT ERRORLEVEL 1 @DEL cl_exe_error
cd "%obuild_bhep_path%\obuild"

cd "%obuild_bhep_path%\%obuild_dir_bin%"
%obuild_cxx_command% /c %obuild_cxx_debug_local% %obuild_cxx_optimize_local% %obuild_cxx_options% %obuild_cxx_macros% %obuild_cxx_includes% /Fo.\lib_bhep\base_reader.obj  /Tp"..\source\manager\base_reader.cpp" 1> cl_exe_error
@IF ERRORLEVEL 1 @TYPE cl_exe_error && @GOTO obuild_return
@IF NOT ERRORLEVEL 1 @DEL cl_exe_error
cd "%obuild_bhep_path%\obuild"

cd "%obuild_bhep_path%\%obuild_dir_bin%"
%obuild_cxx_command% /c %obuild_cxx_debug_local% %obuild_cxx_optimize_local% %obuild_cxx_options% %obuild_cxx_macros% %obuild_cxx_includes% /Fo.\lib_bhep\bhep_svc.obj  /Tp"..\source\manager\bhep_svc.cpp" 1> cl_exe_error
@IF ERRORLEVEL 1 @TYPE cl_exe_error && @GOTO obuild_return
@IF NOT ERRORLEVEL 1 @DEL cl_exe_error
cd "%obuild_bhep_path%\obuild"

cd "%obuild_bhep_path%\%obuild_dir_bin%"
%obuild_cxx_command% /c %obuild_cxx_debug_local% %obuild_cxx_optimize_local% %obuild_cxx_options% %obuild_cxx_macros% %obuild_cxx_includes% /Fo.\lib_bhep\brw.obj  /Tp"..\source\manager\brw.cpp" 1> cl_exe_error
@IF ERRORLEVEL 1 @TYPE cl_exe_error && @GOTO obuild_return
@IF NOT ERRORLEVEL 1 @DEL cl_exe_error
cd "%obuild_bhep_path%\obuild"

cd "%obuild_bhep_path%\%obuild_dir_bin%"
%obuild_cxx_command% /c %obuild_cxx_debug_local% %obuild_cxx_optimize_local% %obuild_cxx_options% %obuild_cxx_macros% %obuild_cxx_includes% /Fo.\lib_bhep\converter_svc.obj  /Tp"..\source\manager\converter_svc.cpp" 1> cl_exe_error
@IF ERRORLEVEL 1 @TYPE cl_exe_error && @GOTO obuild_return
@IF NOT ERRORLEVEL 1 @DEL cl_exe_error
cd "%obuild_bhep_path%\obuild"

cd "%obuild_bhep_path%\%obuild_dir_bin%"
%obuild_cxx_command% /c %obuild_cxx_debug_local% %obuild_cxx_optimize_local% %obuild_cxx_options% %obuild_cxx_macros% %obuild_cxx_includes% /Fo.\lib_bhep\random_reader.obj  /Tp"..\source\manager\random_reader.cpp" 1> cl_exe_error
@IF ERRORLEVEL 1 @TYPE cl_exe_error && @GOTO obuild_return
@IF NOT ERRORLEVEL 1 @DEL cl_exe_error
cd "%obuild_bhep_path%\obuild"

cd "%obuild_bhep_path%\%obuild_dir_bin%"
%obuild_cxx_command% /c %obuild_cxx_debug_local% %obuild_cxx_optimize_local% %obuild_cxx_options% %obuild_cxx_macros% %obuild_cxx_includes% /Fo.\lib_bhep\random_writer.obj  /Tp"..\source\manager\random_writer.cpp" 1> cl_exe_error
@IF ERRORLEVEL 1 @TYPE cl_exe_error && @GOTO obuild_return
@IF NOT ERRORLEVEL 1 @DEL cl_exe_error
cd "%obuild_bhep_path%\obuild"

cd "%obuild_bhep_path%\%obuild_dir_bin%"
%obuild_cxx_command% /c %obuild_cxx_debug_local% %obuild_cxx_optimize_local% %obuild_cxx_options% %obuild_cxx_macros% %obuild_cxx_includes% /Fo.\lib_bhep\reader_gz.obj  /Tp"..\source\manager\reader_gz.cpp" 1> cl_exe_error
@IF ERRORLEVEL 1 @TYPE cl_exe_error && @GOTO obuild_return
@IF NOT ERRORLEVEL 1 @DEL cl_exe_error
cd "%obuild_bhep_path%\obuild"

cd "%obuild_bhep_path%\%obuild_dir_bin%"
%obuild_cxx_command% /c %obuild_cxx_debug_local% %obuild_cxx_optimize_local% %obuild_cxx_options% %obuild_cxx_macros% %obuild_cxx_includes% /Fo.\lib_bhep\reader_hdf5.obj  /Tp"..\source\manager\reader_hdf5.cpp" 1> cl_exe_error
@IF ERRORLEVEL 1 @TYPE cl_exe_error && @GOTO obuild_return
@IF NOT ERRORLEVEL 1 @DEL cl_exe_error
cd "%obuild_bhep_path%\obuild"

cd "%obuild_bhep_path%\%obuild_dir_bin%"
%obuild_cxx_command% /c %obuild_cxx_debug_local% %obuild_cxx_optimize_local% %obuild_cxx_options% %obuild_cxx_macros% %obuild_cxx_includes% /Fo.\lib_bhep\reader_txt.obj  /Tp"..\source\manager\reader_txt.cpp" 1> cl_exe_error
@IF ERRORLEVEL 1 @TYPE cl_exe_error && @GOTO obuild_return
@IF NOT ERRORLEVEL 1 @DEL cl_exe_error
cd "%obuild_bhep_path%\obuild"

cd "%obuild_bhep_path%\%obuild_dir_bin%"
%obuild_cxx_command% /c %obuild_cxx_debug_local% %obuild_cxx_optimize_local% %obuild_cxx_options% %obuild_cxx_macros% %obuild_cxx_includes% /Fo.\lib_bhep\sequential_reader.obj  /Tp"..\source\manager\sequential_reader.cpp" 1> cl_exe_error
@IF ERRORLEVEL 1 @TYPE cl_exe_error && @GOTO obuild_return
@IF NOT ERRORLEVEL 1 @DEL cl_exe_error
cd "%obuild_bhep_path%\obuild"

cd "%obuild_bhep_path%\%obuild_dir_bin%"
%obuild_cxx_command% /c %obuild_cxx_debug_local% %obuild_cxx_optimize_local% %obuild_cxx_options% %obuild_cxx_macros% %obuild_cxx_includes% /Fo.\lib_bhep\sequential_writer.obj  /Tp"..\source\manager\sequential_writer.cpp" 1> cl_exe_error
@IF ERRORLEVEL 1 @TYPE cl_exe_error && @GOTO obuild_return
@IF NOT ERRORLEVEL 1 @DEL cl_exe_error
cd "%obuild_bhep_path%\obuild"

cd "%obuild_bhep_path%\%obuild_dir_bin%"
%obuild_cxx_command% /c %obuild_cxx_debug_local% %obuild_cxx_optimize_local% %obuild_cxx_options% %obuild_cxx_macros% %obuild_cxx_includes% /Fo.\lib_bhep\writer_gz.obj  /Tp"..\source\manager\writer_gz.cpp" 1> cl_exe_error
@IF ERRORLEVEL 1 @TYPE cl_exe_error && @GOTO obuild_return
@IF NOT ERRORLEVEL 1 @DEL cl_exe_error
cd "%obuild_bhep_path%\obuild"

cd "%obuild_bhep_path%\%obuild_dir_bin%"
%obuild_cxx_command% /c %obuild_cxx_debug_local% %obuild_cxx_optimize_local% %obuild_cxx_options% %obuild_cxx_macros% %obuild_cxx_includes% /Fo.\lib_bhep\writer_hdf5.obj  /Tp"..\source\manager\writer_hdf5.cpp" 1> cl_exe_error
@IF ERRORLEVEL 1 @TYPE cl_exe_error && @GOTO obuild_return
@IF NOT ERRORLEVEL 1 @DEL cl_exe_error
cd "%obuild_bhep_path%\obuild"

cd "%obuild_bhep_path%\%obuild_dir_bin%"
%obuild_cxx_command% /c %obuild_cxx_debug_local% %obuild_cxx_optimize_local% %obuild_cxx_options% %obuild_cxx_macros% %obuild_cxx_includes% /Fo.\lib_bhep\writer_txt.obj  /Tp"..\source\manager\writer_txt.cpp" 1> cl_exe_error
@IF ERRORLEVEL 1 @TYPE cl_exe_error && @GOTO obuild_return
@IF NOT ERRORLEVEL 1 @DEL cl_exe_error
cd "%obuild_bhep_path%\obuild"

cd "%obuild_bhep_path%\%obuild_dir_bin%"
%obuild_cxx_command% /c %obuild_cxx_debug_local% %obuild_cxx_optimize_local% %obuild_cxx_options% %obuild_cxx_macros% %obuild_cxx_includes% /Fo.\lib_bhep\generate_event.obj  /Tp"..\source\examples\generate_event.cpp" 1> cl_exe_error
@IF ERRORLEVEL 1 @TYPE cl_exe_error && @GOTO obuild_return
@IF NOT ERRORLEVEL 1 @DEL cl_exe_error
cd "%obuild_bhep_path%\obuild"

cd "%obuild_bhep_path%\%obuild_dir_bin%"
%obuild_cxx_command% /c %obuild_cxx_debug_local% %obuild_cxx_optimize_local% %obuild_cxx_options% %obuild_cxx_macros% %obuild_cxx_includes% /Fo.\lib_bhep\gevent.obj  /Tp"..\source\tutorials\gevent.cpp" 1> cl_exe_error
@IF ERRORLEVEL 1 @TYPE cl_exe_error && @GOTO obuild_return
@IF NOT ERRORLEVEL 1 @DEL cl_exe_error
cd "%obuild_bhep_path%\obuild"

cd "%obuild_bhep_path%\%obuild_dir_bin%"
%obuild_cxx_command% /c %obuild_cxx_debug_local% %obuild_cxx_optimize_local% %obuild_cxx_options% %obuild_cxx_macros% %obuild_cxx_includes% /Fo.\lib_bhep\axis.obj  /Tp"..\source\histos\axis.cpp" 1> cl_exe_error
@IF ERRORLEVEL 1 @TYPE cl_exe_error && @GOTO obuild_return
@IF NOT ERRORLEVEL 1 @DEL cl_exe_error
cd "%obuild_bhep_path%\obuild"

cd "%obuild_bhep_path%\%obuild_dir_bin%"
%obuild_cxx_command% /c %obuild_cxx_debug_local% %obuild_cxx_optimize_local% %obuild_cxx_options% %obuild_cxx_macros% %obuild_cxx_includes% /Fo.\lib_bhep\histogram.obj  /Tp"..\source\histos\histogram.cpp" 1> cl_exe_error
@IF ERRORLEVEL 1 @TYPE cl_exe_error && @GOTO obuild_return
@IF NOT ERRORLEVEL 1 @DEL cl_exe_error
cd "%obuild_bhep_path%\obuild"

cd "%obuild_bhep_path%\%obuild_dir_bin%"
%obuild_cxx_command% /c %obuild_cxx_debug_local% %obuild_cxx_optimize_local% %obuild_cxx_options% %obuild_cxx_macros% %obuild_cxx_includes% /Fo.\lib_bhep\EventManager.obj  /Tp"..\source\tools\EventManager.cpp" 1> cl_exe_error
@IF ERRORLEVEL 1 @TYPE cl_exe_error && @GOTO obuild_return
@IF NOT ERRORLEVEL 1 @DEL cl_exe_error
cd "%obuild_bhep_path%\obuild"

@IF %obuild_verbose% == yes @ECHO OFF 

FOR /F "usebackq delims=;" %%d IN (`cd`) DO SET obuild_pwd_bhep_0=%%d
cd "%obuild_bhep_path%\%obuild_dir_bin%"
IF NOT EXIST .\obuild_platform.exe  ECHO Program obuild_platform.exe not found.  && GOTO obuild_return
FOR /F "usebackq" %%j IN (`.\obuild_platform.exe  %obuild_platform% Darwin`) DO SET obuild_platform_result=%%j
cd "%obuild_pwd_bhep_0%"
SET obuild_pwd_bhep_0=
IF NOT %obuild_platform_result% == yes GOTO end_if_platform_62
SET obuild_cxx_linker_command=c++
:end_if_platform_62
SET obuild_platform_result=
FOR /F "usebackq delims=;" %%d IN (`cd`) DO SET obuild_pwd_bhep_0=%%d
cd "%obuild_bhep_path%\%obuild_dir_bin%"
IF NOT EXIST .\obuild_platform.exe  ECHO Program obuild_platform.exe not found.  && GOTO obuild_return
FOR /F "usebackq" %%j IN (`.\obuild_platform.exe  %obuild_platform% Linux`) DO SET obuild_platform_result=%%j
cd "%obuild_pwd_bhep_0%"
SET obuild_pwd_bhep_0=
IF NOT %obuild_platform_result% == yes GOTO end_if_platform_63
SET obuild_cxx_linker_command=c++
:end_if_platform_63
SET obuild_platform_result=
FOR /F "usebackq delims=;" %%d IN (`cd`) DO SET obuild_pwd_bhep_0=%%d
cd "%obuild_bhep_path%\%obuild_dir_bin%"
IF NOT EXIST .\obuild_platform.exe  ECHO Program obuild_platform.exe not found.  && GOTO obuild_return
FOR /F "usebackq" %%j IN (`.\obuild_platform.exe  %obuild_platform% OSF1`) DO SET obuild_platform_result=%%j
cd "%obuild_pwd_bhep_0%"
SET obuild_pwd_bhep_0=
IF NOT %obuild_platform_result% == yes GOTO end_if_platform_64
SET obuild_cxx_linker_command=cxx
:end_if_platform_64
SET obuild_platform_result=
FOR /F "usebackq delims=;" %%d IN (`cd`) DO SET obuild_pwd_bhep_0=%%d
cd "%obuild_bhep_path%\%obuild_dir_bin%"
IF NOT EXIST .\obuild_platform.exe  ECHO Program obuild_platform.exe not found.  && GOTO obuild_return
FOR /F "usebackq" %%j IN (`.\obuild_platform.exe  %obuild_platform% Windows_NT`) DO SET obuild_platform_result=%%j
cd "%obuild_pwd_bhep_0%"
SET obuild_pwd_bhep_0=
IF NOT %obuild_platform_result% == yes GOTO end_if_platform_65
SET obuild_cxx_linker_command=link.exe
:end_if_platform_65
SET obuild_platform_result=
IF "%obuild_cxx_linker_command%" == ""  ECHO Variable obuild_cxx_linker_command not defined.  && GOTO obuild_return

FOR /F "usebackq delims=;" %%d IN (`cd`) DO SET obuild_pwd_bhep_0=%%d
cd "%obuild_bhep_path%\%obuild_dir_bin%"
IF NOT EXIST .\obuild_platform.exe  ECHO Program obuild_platform.exe not found.  && GOTO obuild_return
FOR /F "usebackq" %%j IN (`.\obuild_platform.exe  %obuild_platform% Darwin`) DO SET obuild_platform_result=%%j
cd "%obuild_pwd_bhep_0%"
SET obuild_pwd_bhep_0=
IF NOT %obuild_platform_result% == yes GOTO end_if_platform_66
SET obuild_cxx_linker_debug=-g
:end_if_platform_66
SET obuild_platform_result=
FOR /F "usebackq delims=;" %%d IN (`cd`) DO SET obuild_pwd_bhep_0=%%d
cd "%obuild_bhep_path%\%obuild_dir_bin%"
IF NOT EXIST .\obuild_platform.exe  ECHO Program obuild_platform.exe not found.  && GOTO obuild_return
FOR /F "usebackq" %%j IN (`.\obuild_platform.exe  %obuild_platform% Linux`) DO SET obuild_platform_result=%%j
cd "%obuild_pwd_bhep_0%"
SET obuild_pwd_bhep_0=
IF NOT %obuild_platform_result% == yes GOTO end_if_platform_67
SET obuild_cxx_linker_debug=-g
:end_if_platform_67
SET obuild_platform_result=
FOR /F "usebackq delims=;" %%d IN (`cd`) DO SET obuild_pwd_bhep_0=%%d
cd "%obuild_bhep_path%\%obuild_dir_bin%"
IF NOT EXIST .\obuild_platform.exe  ECHO Program obuild_platform.exe not found.  && GOTO obuild_return
FOR /F "usebackq" %%j IN (`.\obuild_platform.exe  %obuild_platform% OSF1`) DO SET obuild_platform_result=%%j
cd "%obuild_pwd_bhep_0%"
SET obuild_pwd_bhep_0=
IF NOT %obuild_platform_result% == yes GOTO end_if_platform_68
SET obuild_cxx_linker_debug=-g
:end_if_platform_68
SET obuild_platform_result=
FOR /F "usebackq delims=;" %%d IN (`cd`) DO SET obuild_pwd_bhep_0=%%d
cd "%obuild_bhep_path%\%obuild_dir_bin%"
IF NOT EXIST .\obuild_platform.exe  ECHO Program obuild_platform.exe not found.  && GOTO obuild_return
FOR /F "usebackq" %%j IN (`.\obuild_platform.exe  %obuild_platform% Windows_NT`) DO SET obuild_platform_result=%%j
cd "%obuild_pwd_bhep_0%"
SET obuild_pwd_bhep_0=
IF NOT %obuild_platform_result% == yes GOTO end_if_platform_69
SET obuild_cxx_linker_debug=/DEBUG
:end_if_platform_69
SET obuild_platform_result=

FOR /F "usebackq delims=;" %%d IN (`cd`) DO SET obuild_pwd_bhep_0=%%d
cd "%obuild_bhep_path%\%obuild_dir_bin%"
IF NOT EXIST .\obuild_platform.exe  ECHO Program obuild_platform.exe not found.  && GOTO obuild_return
FOR /F "usebackq" %%j IN (`.\obuild_platform.exe  %obuild_platform% Windows_NT`) DO SET obuild_platform_result=%%j
cd "%obuild_pwd_bhep_0%"
SET obuild_pwd_bhep_0=
IF NOT %obuild_platform_result% == yes GOTO end_if_platform_70
SET obuild_cxx_linker_options=/nologo
:end_if_platform_70
SET obuild_platform_result=

IF NOT %obuild_debug% == yes GOTO else_if_db_build_lib_bhep_sh_71
  SET obuild_cxx_linker_debug_local=%obuild_cxx_linker_debug%
  GOTO end_if_db_build_lib_bhep_sh_71
:else_if_db_build_lib_bhep_sh_71
  SET obuild_cxx_linker_debug_local=
:end_if_db_build_lib_bhep_sh_71

IF NOT %obuild_optimize% == yes GOTO else_if_opt_build_lib_bhep_sh_72
  SET obuild_cxx_linker_optimize_local=%obuild_cxx_linker_optimize%
  GOTO end_if_opt_build_lib_bhep_sh_72
:else_if_opt_build_lib_bhep_sh_72
  SET obuild_cxx_linker_optimize_local=
:end_if_opt_build_lib_bhep_sh_72

FOR /F "usebackq delims=;" %%d IN (`cd`) DO SET obuild_pwd_bhep_0=%%d
cd "%obuild_bhep_path%\%obuild_dir_bin%"
IF EXIST .\lib_bhep\tmp_objs DEL .\lib_bhep\tmp_objs
FOR %%f IN (.\lib_bhep\*.obj) DO ECHO %%f >> .\lib_bhep\tmp_objs

REM # Create the archive library bhep :
@IF %obuild_verbose% == yes @ECHO ON 
lib.exe /nologo /machine:ix86 /out:.\lib_bhep\bhep.arc @.\lib_bhep\tmp_objs
@IF ERRORLEVEL 1 @GOTO obuild_return
@IF %obuild_verbose% == yes @ECHO OFF 

REM # Build the obuild_windef.exe utility program :
cl.exe /nologo /DWIN32 /MD /O2 /W3 /Feobuild_windef.exe "%obuild_bhep_path%\obuild\cpp\obuild_windef.c" 1> NUL
IF EXIST obuild_windef.obj DEL obuild_windef.obj

REM # Building the .def file :
@IF %obuild_verbose% == yes @ECHO ON 
dumpbin.exe /symbols /out:.\lib_bhep\tmp .\lib_bhep\bhep.arc 1> dumpbin_exe_error .\lib_bhep\bhep.arc
@IF ERRORLEVEL 1 @TYPE dumpbin_exe_error && @GOTO obuild_return
@IF NOT ERRORLEVEL 1 @DEL dumpbin_exe_error
@IF %obuild_verbose% == yes @ECHO OFF 
.\obuild_windef.exe bhep < .\lib_bhep\tmp > .\lib_bhep\bhep.def
REM # Building the linking library :
REM # It produces a .exp file.
@IF %obuild_verbose% == yes @ECHO ON 
lib.exe /nologo /machine:ix86 /out:.\bhep.lib /def:.\lib_bhep\bhep.def 1> lib_exe_error
@IF ERRORLEVEL 1 @TYPE lib_exe_error && @GOTO obuild_return
@IF NOT ERRORLEVEL 1 @DEL lib_exe_error
@IF %obuild_verbose% == yes @ECHO OFF 

REM # Building the DLL :
IF EXIST .\bhep.dll DEL .\bhep.dll
@IF %obuild_verbose% == yes @ECHO ON 
link.exe /nologo /dll /out:.\bhep.dll .\bhep.exp .\lib_bhep\bhep.arc %obuild_linked_libraries%
@IF %obuild_verbose% == yes @ECHO OFF 

cd "%obuild_pwd_bhep_0%"
SET obuild_pwd_bhep_0=
REM # Some cleanup :
IF EXIST "%obuild_bhep_path%\%obuild_dir_bin%\lib_bhep\tmp_objs" DEL "%obuild_bhep_path%\%obuild_dir_bin%\lib_bhep\tmp_objs"
IF EXIST "%obuild_bhep_path%\%obuild_dir_bin%\bhep.exp" DEL "%obuild_bhep_path%\%obuild_dir_bin%\bhep.exp"

:obuild_return
ENDLOCAL
@ECHO ON
