
#
#  Usage :
#    sh> . setup.sh
#

#set -x

OSC_home="@@absolute_dir@@"

if [ "${OSC_home}" = '@@absolute_dir@@' ] ; then
  echo '  The OpenScientist setup scripts had not been installed.'
  echo ''
  echo ' In the file :'
  echo '    OpenScientist/<vers>/setup.sh'
  echo ' someone has to replace '
  echo '    @@absolute_dir@@'
  echo ' by the absolute path of the package.'
  echo ''
  echo '  If having the write access, this replacement can be done'
  echo ' on the setup scripts by using the install script :'
  echo '    cd <install_path>/OpenScientist/<vers>'
  echo '    ./install'
  echo ''
  return
fi

# The "." is for the OpenPAW on-the-fly compilation and loading.
if [ `uname` = "Linux" ]; then
  lib_path="${OSC_home}/lib:."
  if [ -z "${LD_LIBRARY_PATH}" ] ; then
    LD_LIBRARY_PATH="${lib_path}"
    export LD_LIBRARY_PATH
  else
    status=1;(echo $LD_LIBRARY_PATH | grep "${lib_path}" >& /dev/null  ) && status=0
    if [ $status != 0 ] ; then
      LD_LIBRARY_PATH="${LD_LIBRARY_PATH}:${lib_path}"
      export LD_LIBRARY_PATH
   fi
  fi
  unset lib_path
fi

if [ `uname` = "Darwin" ]; then
  lib_path="${OSC_home}/lib:${OSC_home}/bin:."
  if [ -z "${DYLD_LIBRARY_PATH}" ] ; then
    DYLD_LIBRARY_PATH="${lib_path}"
    export DYLD_LIBRARY_PATH
  else
    status=1;(echo $DYLD_LIBRARY_PATH | grep "${lib_path}" >& /dev/null  ) && status=0
    if [ $status != 0 ] ; then
      DYLD_LIBRARY_PATH="${DYLD_LIBRARY_PATH}:${lib_path}"
      export DYLD_LIBRARY_PATH
    fi
  fi
  unset lib_path
fi

bin_path="${OSC_home}/bin"
if [ -z "${PATH}" ] ; then
  PATH="${bin_path}"
  export PATH
else
  status=1;(echo $PATH | grep "${bin_path}" >& /dev/null  ) && status=0
  if [ $status != 0 ] ; then
    PATH="${PATH}:${bin_path}"
    export PATH
  fi
fi
unset bin_path

# AIDA :
AIDA_HOME_DIR="${OSC_home}";export AIDA_HOME_DIR

# else :
COIN_DONT_INFORM_INDIRECT_RENDERING="1"
export COIN_DONT_INFORM_INDIRECT_RENDERING

unset OSC_home
