@ECHO OFF
SETLOCAL

REM #
REM # File produced by the obuild tool version 1.0
REM # for the package bhep with version v1r4p2.
REM #

REM #////////////////////////////////////////////////
REM # Usage :
REM #   DOS> CD some_path\pack\version\obuild
REM #   DOS> DOS\build
REM # or :
REM #   DOS> call DOS\build.bat
REM #
REM #////////////////////////////////////////////////

REM #////////////////////////////////////////////////
REM #/// Get path of this file :
REM #////////////////////////////////////////////////
SET obuild_bhep_path=%~dp0
REM # Remove ending \obuild\DOS\
SET obuild_bhep_path=%obuild_bhep_path:~0,-12%

REM #////////////////////////////////////////////////
REM #/// Treat arguments :
REM #////////////////////////////////////////////////

SET obuild_verbose=no
SET obuild_debug=no
SET obuild_do_mains=yes
SET obuild_group=main

SET obuild_args=

:next_arg
IF "%1%" == "" GOTO end_args

IF NOT "%1%" == "-h" GOTO end_if_h
  ECHO Usage :
  ECHO   build [Options] [Target]
  ECHO Options :
  ECHO   -v : verbose.
  ECHO   -g : build in debug mode.
  ECHO   -e : erase binary directory.
  ECHO   -x : execute with ECHO ON"
  ECHO   -nm : build the not-main components.
  ECHO   -group group : build the given group of components.
  ECHO Target :
  ECHO   If no option is specify and a ending
  ECHO  string is given ; this string is given
  ECHO  to a find command of the form :
  ECHO     find ./sh -name "*target*" -exec {} \;
  ECHO  in order to execute selected scripts under
  ECHO  the sh directory.
  ECHO Examples :
  ECHO   build app
  ECHO   build -v _lib
  ECHO   build -v -g dll_
  GOTO obuild_return
:end_if_h

IF NOT "%1%" == "-v" GOTO end_if_v
  SET obuild_verbose=yes
  SET obuild_args=%obuild_args% -v
  SHIFT
  GOTO next_arg
:end_if_v

IF NOT "%1%" == "-g" GOTO end_if_g
  SET obuild_debug=yes
  SET obuild_args=%obuild_args% -g
  SHIFT
  GOTO next_arg
:end_if_g

IF NOT "%1%" == "-e" GOTO end_if_e

  IF "%OBUILD_PLATFORM%" == "" (
    IF "%OS%" == "" ECHO Environment variable OS not found. & GOTO obuild_return
    SET obuild_platform=%OS%
  ) ELSE (
    SET obuild_platform=%OBUILD_PLATFORM%
  )

  IF "%obuild_platform%" == "" (
    ECHO obuild_platform variable not defined.
    GOTO obuild_return
  )

  IF "%OBUILD_DIR_BIN%" == "" (
    SET obuild_dir_bin=bin_obuild
  ) ELSE (
    SET obuild_dir_bin=%OBUILD_DIR_BIN%
  )

  IF "%obuild_dir_bin%" == "" (
    ECHO obuild_dir_bin variable not defined.
    GOTO obuild_return
  )

  IF EXIST "%obuild_bhep_path%\%obuild_dir_bin%" RMDIR /S /Q "%obuild_bhep_path%\%obuild_dir_bin%"

  GOTO obuild_return

:end_if_e

IF NOT "%1%" == "-x" GOTO end_if_x
  SET obuild_args=%obuild_args% -x
  SHIFT
  GOTO next_arg
:end_if_x

IF NOT "%1%" == "-nm" GOTO end_if_nm
  SET obuild_do_mains=no
  SHIFT
  GOTO next_arg
:end_if_nm

IF NOT "%1%" == "-group" GOTO end_if_group
  SHIFT
  SET obuild_group=%1%
  SHIFT
  GOTO next_arg
:end_if_group

REM # Argument without a leading "-" is assumed to 
REM # be the last one and then to be a pattern 
REM # to find and execute command files under 
REM # the DOS directory.
SET obuild_arg=%1%
SET obuild_arg1=%1:~0,1%
IF "%obuild_arg1%" == "-" GOTO obuild_return

  FOR %%f IN (DOS\*%obuild_arg%*) DO %%f %obuild_args%

  GOTO obuild_return

:end_args

REM #////////////////////////////////////////////////
REM #/// End arguments.
REM #////////////////////////////////////////////////


IF NOT %obuild_group% == main GOTO end_if_group_0
IF NOT %obuild_do_mains% == yes GOTO end_if_main_0
  IF NOT EXIST .\DOS\build_lib_bhep.bat  GOTO end_if_build_0
    CALL .\DOS\build_lib_bhep.bat %obuild_args%
    @IF ERRORLEVEL 1 @GOTO obuild_return
    @ECHO OFF
:end_if_build_0
:end_if_main_0
:end_if_group_0

:obuild_return
ENDLOCAL
@ECHO ON
