// this :
#include <G4Lab/TrajectoryContainerAccessor.h>

// Inventor :
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoLightModel.h>
#include <Inventor/nodes/SoDrawStyle.h>

// HEPVis :
#include <HEPVis/nodes/SoHighlightMaterial.h>

#ifdef WIN32
#undef pascal // Clash between windef.h and Geant4/SystemOfUnits.hh
#endif

// Lib :
#include <Slash/Core/ISession.h>
#include <Slash/Data/IIterator.h>
#include <Lib/Out.h>
#include <Lib/Variable.h>
#include <Lib/smanip.h>

// G4Lab :
#include <G4Lab/SoG4RunManager.h>

//////////////////////////////////////////////////////////////////////////////
G4Lab::TrajectoryContainerAccessor::TrajectoryContainerAccessor(
 Slash::Core::ISession& aSession
,G4RunManager* aRunManager
)
:OnX::InventorAccessor(aSession)
,fType("TrajectoryContainer")
,fRunManager(aRunManager)
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
}
//////////////////////////////////////////////////////////////////////////////
G4Lab::TrajectoryContainerAccessor::~TrajectoryContainerAccessor(
) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
}
//////////////////////////////////////////////////////////////////////////////
std::string G4Lab::TrajectoryContainerAccessor::name(
) const
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  return fType;
}
namespace G4Lab {
  class TrajectoryContainerIterator : public virtual Slash::Data::IIterator {
  public: //Slash::Data::IIterator
    virtual Slash::Data::IAccessor::Data object() { return fValue; }
    virtual void next() { fValue = 0; }
    virtual void* tag() { return 0;}
  public:
    TrajectoryContainerIterator(void* aValue):fValue(aValue) {}
    virtual ~TrajectoryContainerIterator(){}
  private:
    void* fValue;
  };
}
//////////////////////////////////////////////////////////////////////////////
Slash::Data::IIterator* G4Lab::TrajectoryContainerAccessor::iterator(
) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  return new TrajectoryContainerIterator(this);
}
//////////////////////////////////////////////////////////////////////////////
Slash::Core::IValue* G4Lab::TrajectoryContainerAccessor::findValue(
 Slash::Data::IAccessor::Data aData
,const std::string& aName
,void* aTag
) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  return 0;
}
//////////////////////////////////////////////////////////////////////////////
void G4Lab::TrajectoryContainerAccessor::beginVisualize(
) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  OnX::InventorAccessor::beginVisualize();
  std::string value;
  int number = 1;
  if(fSession.parameterValue("modeling.events",value)) {
    if(!Lib::smanip::toint(value,number)) number = 1;
  }

  // Search if an SoG4RunManager had been introduced already :
  SoG4RunManager* node = 
    (SoG4RunManager*)fSoRegion->findNode("type","SoG4RunManager");
  if(node) {
    //debug fSession.out().println("debug : find soG4RunManager.");
    node->numberOfEvents.setValue(number);
    node->touch();

  } else {
  
    //debug fSession.out().println("debug : create soG4RunManager.");
  
    SoSeparator* separator = new SoSeparator;
    separator->setName("sceneGraph");
    
    separator->addChild(fSoGC.getHighlightMaterial());
    separator->addChild(fSoGC.getDrawStyle());
    separator->addChild(fSoGC.getLightModel());

    SoG4RunManager* soG4RunManager = new SoG4RunManager(fRunManager);
    soG4RunManager->numberOfEvents.setValue(number);
    separator->addChild(soG4RunManager);
  
    fSoRegion->doIt(SbAddNode(separator,"dynamicScene"));
  }
}
//////////////////////////////////////////////////////////////////////////////
void G4Lab::TrajectoryContainerAccessor::visualize(
 Slash::Data::IAccessor::Data,void*
) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
}
//////////////////////////////////////////////////////////////////////////////
void G4Lab::TrajectoryContainerAccessor::endVisualize(
) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
}
