#ifndef IGeant4Trajectory_h
#define IGeant4Trajectory_h

#include <string>
#include <vector> //Avoid include G4ThreeVector.hh

class G4VPhysicalVolume;

class IGeant4Trajectory {
public:
  virtual ~IGeant4Trajectory() {}
public:
  virtual double kineticEnergy() const = 0;
  virtual double totalEnergy() const = 0;
  virtual double globalTime() const = 0;
  virtual unsigned int pointEntries() const = 0;
  virtual double pointGlobalTime(unsigned int) const = 0;
  virtual std::string creatorProcessName() const = 0;
  virtual std::string creatorProcessType() const = 0;
  virtual void setSave(bool) = 0;
  virtual bool save() const = 0;

  // The below returned std::vector is assumed to contained three numbers.
  virtual std::vector<double> stoppingPoint() const = 0;

  virtual G4VPhysicalVolume* stoppingPhysicalVolume() const = 0;
};

#endif
