// this :
#include <G4Lab/BestUnit.h>

// Geant4 :
#include <G4UnitsTable.hh>

// Lib :
#include <Lib/Debug.h>
#include <Lib/Out.h>
#include <Lib/smanip.h>
#include <Lib/sout.h>

//////////////////////////////////////////////////////////////////////////////
bool G4Lab::BestUnit::toDoubles(
 Slash::Core::IWriter& aPrinter
,const std::string& aString
,std::vector<double>& aVec
) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  std::vector<std::string> words = Lib::smanip::words(aString," ");
  unsigned int wordn = words.size();
  if(!wordn) {
    aVec.clear();
    return false;
  }
  G4double unit = G4UnitDefinition::GetValueOf(words[wordn-1]);
  if(unit==0.) {
    aVec.clear();
    return false;
  }
  aVec.resize(wordn-1);
  for(unsigned int index=0;index<(wordn-1);index++) {
    double v = 0;
    if(!Lib::smanip::todouble(words[index],v)) {
      Lib::Out out(aPrinter);
      out << "G4Lab::BestUnit::toDoubles :" 
          << " " << Lib::sout(words[index]) << " not a double." 
          << Lib::endl;
      aVec.clear();
      return false;
    }
    aVec[index] = v * unit;
  }
  return true;
}
