//
//  This program is and should be standalone so that :
//     UNIX> c++ obuild_platform.cxx 
//      DOS> cl.exe obuild_platform.cxx 
// builds at first shoot.
//

#include <string>
#include <vector>
#include <stdlib.h>
#include <stdio.h>

// From Lib :
static std::vector<std::string> Lib_smanip_words(const std::string&,
                                                 const std::string&,
                                                 bool = false);

//////////////////////////////////////////////////////////////////////////////
static bool isKnownKeyword(
 const std::string& aString
)
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  if(aString=="Windows_NT") {
    return true;
  } else if(aString=="Linux") {
    return true;
  } else if(aString=="Darwin") {
    return true;
  } else if(aString=="SunOS") {
    return true;
  } else if(aString=="OSF1") {
    return true;
  } else if(aString=="UNIX") {
    return true;
  } else {
    return false;
  }
}
//////////////////////////////////////////////////////////////////////////////
static bool isUNIX(
 const std::string& aString
,bool& aResult
)
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  if(!isKnownKeyword(aString)) {
    aResult = false;
    return false;
  }
  if(aString=="Windows_NT") {
    aResult = false;
  } else {
    aResult = true;
  }
  return true;
}
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
int main(
 int aArgc
,char** aArgv
) 
//////////////////////////////////////////////////////////////////////////////
// aArgs[0] : program name.
// aArgs[1] : we expect the result of `uname`.
// aArgs[2] : an expression to compare with.
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  std::vector<std::string> args;
 {for(int index=0;index<aArgc;index++) args.push_back(aArgv[index]);}
  
  if(args.size()!=3) {
    fprintf(stderr,"obuild_platform : two arguments expected.\n");
    printf("no\n");
    return EXIT_FAILURE;
  }

  std::string uname = args[1];
  if(!isKnownKeyword(uname)) {
    fprintf(stderr,"obuild_platform : unknwon keyword \"%s\".\n",
            uname.c_str());
    printf("no\n");
    return EXIT_FAILURE;
  }

  std::string expression = args[2];

  std::vector<std::string> words = Lib_smanip_words(expression," ");

  unsigned int wordn = words.size();
  if(wordn==1) {

    const std::string& keyword = words[0];

    if(keyword=="UNIX") {

      bool is_unix;
      if(!isUNIX(uname,is_unix)) {
      } else {
        if(is_unix) {
          printf("yes\n");
          return EXIT_SUCCESS;
        } else {
          printf("no\n");
          return EXIT_SUCCESS;
        }
      }

    } else if(keyword==uname) {

      printf("yes\n");
      return EXIT_SUCCESS;

    } else if(isKnownKeyword(keyword)) {

      printf("no\n");
      return EXIT_SUCCESS;

    }

  } else if(wordn==2) {

    if(words[0]=="not") {

      const std::string& keyword = words[1];

      if(keyword=="UNIX") {

        bool is_unix;
        if(!isUNIX(uname,is_unix)) {
        } else {
          if(is_unix) {
            printf("no\n");
            return EXIT_SUCCESS;
          } else {
            printf("yes\n");
            return EXIT_SUCCESS;
          }
        }

      } else if(keyword==uname) {

        printf("no\n");
        return EXIT_SUCCESS;

      } else if(isKnownKeyword(keyword)) {

        printf("yes\n");
        return EXIT_SUCCESS;

      }

    }

  }

  fprintf(stderr,"obuild_platform : expression \"%s\" not yet supported.\n",
          expression.c_str());
  printf("no\n");
  return EXIT_FAILURE;
}

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
std::vector<std::string> Lib_smanip_words(
 const std::string& aString
,const std::string& aLimiter 
,bool aTakeEmpty // false
)
//////////////////////////////////////////////////////////////////////////////
//  If aLimiter is for exa "|" and for "xxx||xxx" :
//  - aTakeEmpty false : {"xxx","xxx"} will be created (and NOT {"xxx","","xxx"}).
//  - aTakeEmpty true : {"xxx","","xxx"} will be created.
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  std::vector<std::string> words;
  if(aString=="") return words;
  std::string::size_type lim = (aTakeEmpty?0:1);
  if(aLimiter=="") {
    words.push_back(aString);
  } else {
    std::string::size_type l = aString.length();
    std::string::size_type llimiter = aLimiter.length();
    std::string::size_type pos = 0;
    while(1) {
      std::string::size_type index = aString.find(aLimiter,pos);
      if(index==std::string::npos){ // Last word.
        if((l-pos)>=lim) words.push_back(aString.substr(pos,l-pos));
        break;
      } else {
        //     abcxxxef
        //     0  3  67
        if((index-pos)>=lim) words.push_back(aString.substr(pos,index-pos));
        pos = index + llimiter;
      }
    }
  }
  return words;
}
