//
//  All functions here should be OnX callbacks, that is to say
// functions with signature :
//   extern "C" {
//     void callback_without_arguments(IUI&);
//     void callback_with_arguments(IUI&,const std::vector<std::string>&);
//   }
//

#include <OnX/Helpers/OnX.h>
#include <OnX/Helpers/Inventor.h>

// Slash :
#include <Slash/Core/ISession.h>
#include <Slash/UI/IUI.h>
#include <Slash/UI/ISoViewer.h>

// Lib :
#include <Lib/System.h>
#include <Lib/Manager.h>
#include <Lib/Printer.h>
#include <Lib/Out.h>

// G4Lab :
#include <G4Lab/Interfaces/IGeant4Manager.h>

extern "C" {

//////////////////////////////////////////////////////////////////////////////
/// snovis/scripts/OnX/snovis.onx //////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
void snovis_Initialize(
 Slash::UI::IUI& aUI
) 
//////////////////////////////////////////////////////////////////////////////
// Should be executed (in a widget create callback) 
// when the GUI is constructed 
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  Slash::UI::ISoViewer* soViewer = ui_SoViewer(aUI);
  if(soViewer) {
    soViewer->setDecoration(true);
    soViewer->setViewing(true);
  }

  aUI.setCallback("OnX_File_exit","activate","DLD","G4Lab G4Lab_exit");

  Slash::Core::ISession& session = aUI.session();

  session.setParameter("modeling.highlightColor","white");
  session.setParameter("modeling.trajectories","pickable");
  session.setParameter("event.scan","yes");
    
  IGeant4Manager* g4Manager = 
    Lib_findManager(session,"Geant4Manager",IGeant4Manager);
  if(!g4Manager) {
    aUI.echo("snovis_Initialize : Geant4Manager not found.");
  } else {
    // Declare a callback executed at each end of event :
    g4Manager->setEventEndScript("DLD","snovis snovis_eventEnd");
    //Declare G4Lab types (PV, Trajectory, HitsCollections, etc...).
    g4Manager->initialize(); 
  }
}
//////////////////////////////////////////////////////////////////////////////
void snovis_Finalize(
 Slash::UI::IUI&
) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
}
//////////////////////////////////////////////////////////////////////////////
void snovis_execute_eventEnd(
 Slash::UI::IUI& aUI
) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  Slash::Core::ISession& session = aUI.session();

  std::string value;
  if(!session.parameterValue("event.scan",value)) return;
  // To avoid falling in the ui.steer();
  session.setParameter("event.scan","no");

  aUI.executeScript("DLD","snovis snovis_eventEnd");

  // Restore previous event.scan :
  session.setParameter("event.scan",value);
}

} // extern "C"
