// -*- mode: c++; -*- 
// prog_snova2.cxx

#include <cstdlib>
#include <iostream>
#include <string>
#include <exception>

#include <snova/snova_mgr.hh>

#include <SNvertex/base_VG_factory.h>
#include <SNvertex/CALO_basic_VG.h>
#include <SNvertex/source_simple_VG.h>

int main( int argc_ , char ** argv_ )
{
  int error_code=EXIT_SUCCESS;
  try {

    std::cout << "Hello, this is a sample program for class 'snova_mgr'!" << std::endl; 
  
    bool        debug           = false;
    std::string params_filename = snova::constants::DEF_PARAMS_FILENAME;
    std::string G4_macro        = "";
    bool        visual_mode     = false;

    int iarg=1;
    while ( iarg<argc_ ) {
    
      std::string arg=argv_[iarg];
      
      if ( arg[0] == '-' ) {
	
	if ( arg == "-d" || arg == "--debug" ) debug=true;
	
	if ( arg == "-p" || arg == "--params" ) {
	  iarg++;
	  if (iarg==argc_) {
	    throw std::runtime_error("Missing simulation parameters file!");
	  }
	  params_filename=argv_[iarg];
	}
	
      }
      else {
	G4cerr << "arg=" << arg << G4endl;
	
	if ( arg == "vis" || arg == "visual" ) {
	  visual_mode = true;
	}
	else {
	  G4_macro=arg;
	}
	
      }
   
      iarg++;
    }
    
    // A snova manager:
    snova::snova_mgr my_snova_mgr;

    // Configure some properties of the snova manager:
    my_snova_mgr.set_debug(debug);                     // debug verbosity
    my_snova_mgr.set_params_filename(params_filename); // the main simulation configuration file
    my_snova_mgr.set_visual_mode(visual_mode);         // use X11 display
    my_snova_mgr.set_G4_macro(G4_macro);               // run G4 macro

    // Use a dedicated vertex generator factory:
    snemo::base_VG_factory my_VG_factory;
    my_VG_factory.add("CALO_basic",    snemo::CALO_basic_VG::new_CALO_basic_VG );
    my_VG_factory.add("source_simple", snemo::source_simple_VG::new_source_simple_VG );
    // <here you may add more functors in the factory internal map... >
    //my_VG_factory.add("TC_nblocks", snemo::TC_nblocks_VG::new_TC_nblocks_VG ); // NOT AVAILABLE YET!

    my_VG_factory.init();
    if( debug ) my_VG_factory.dump(std::cerr);
    my_snova_mgr.set_VG_factory(my_VG_factory);

    // Use a dedicated event generator factory:
    /* 2007-01-31, FM: snova V2 beta release
     *
     * In a near future (SNevgen package?) I hope we will be able to plug here 
     * any (E)vent (G)enerator factory; such code could look like:
     *
     *  snemo::base_EG_factory my_EG_factory;
     *  my_EG_factory.add("single_particle", snemo::single_particle_EG::new_single_particle_VG );
     *  my_EG_factory.add("from_genbb_file", snemo::from_genbb_file_EG::new_from_genbb_file_VG );
     *  my_EG_factory.add("cosmics", snemo::cosmics_EG::cosmics_VG );
     *  my_EG_factory.init();
     *  my_snova_mgr.set_EG_factory(my_EG_factory);
     *
     * Now only support for a GENBB file reader is available,
     * and hardcoded in the generator class...
     * 
     */

    // Build the guts of the simulation process within the snova manager:
    std::cerr << "prog_snova2: debug: " 
	      << "Build the guts" << std::endl; 
    my_snova_mgr.init(); // from this point 'set_XXXX' methods failed (manager is locked!)

    // Run the simulation:
    std::cerr << "prog_snova2: debug: " 
	      << "Run the simulation" << std::endl; 
    my_snova_mgr.run_sim();

    // Clean the snova manager
    std::cerr << "prog_snova2: debug: " 
	      << "Clean the snova manager" << std::endl; 
    my_snova_mgr.reset(); // not mandatory for we do it in the d-tor.

    std::cerr << "prog_snova2: debug: " 
	      << "Done" << std::endl; 
  }
  catch(std::exception & x){
    std::cerr << "prog_snova2: error: " << x.what() << std::endl; 
    error_code=EXIT_FAILURE;
  }
  catch(...){
    std::cerr << "prog_snova2: error: " << "unexpected error!" << std::endl; 
    error_code=EXIT_FAILURE;
  }
  return error_code;
}

// end of prog_snova2.cxx
