#///////////////////////////////////////////////////////////////////////
#/////  File containing SuperNemo geometry implementation options  /////
#///////////////////////////////////////////////////////////////////////



#////////////////////////   SOURCE FOIL   /////////////////////////////

# SOURCE layout (Options: simple)
GEOMETRY SOURCE_layout S simple

# SOURCE thickness (mm)
GEOMETRY SOURCE_thick D 0.060

# SOURCE height (cm)
GEOMETRY SOURCE_height D 350.

# SOURCE width (cm)
GEOMETRY SOURCE_width D 450.

# SOURCE materials (Options: Molibdenium, Selenium, Neodymium, ...)
GEOMETRY SOURCE_mat S Molibdenium


#//////////////////////   TRACKING CHAMBER   //////////////////////////

# Tracking Chamber total length (cm)
GEOMETRY TC_length D 120.

# Tracking Chamber height (cm)
GEOMETRY TC_height D 400.

# Tracking Chamber width (cm)
GEOMETRY TC_width D 500.

# Tracking gas materials (Options: Helium, Tracking_gas, ...)
GEOMETRY TC_mat S Tracking_gas

# Tracking Chamber gas pressure (atm)
GEOMETRY TC_pressure D 0.89

# Tracking Chamber gas temperature (kelvin)
GEOMETRY TC_temperature D 300.


#/////////////////   TRACKING PLANES DISTRIBUTION   ////////////////////

# Measurement planes distribution (Options: nblocks)
GEOMETRY TC_planes_dist S nblocks

# /// In the case of "nblocks" planes distribution:

# Number of planes GG blocks
GEOMETRY TC_num_blocks I 3

# Number of planes in every GG block
GEOMETRY TC_planes_per_block V 3
4
2
3

# Gap size (cm) for every GG block
GEOMETRY TC_gaps_Z V 3
5.0
15.0
15.0


#//////////////////////   DRIFT CELLS   ////////////////////////

# Drift cell geometry (Options: gwires_8)
GEOMETRY DCELL_layout S gwires_8

# Drift cell diametry (mm)
GEOMETRY DCELL_diam D 30.

# Drift cell anode wires diametry (um)
GEOMETRY DCELL_AWIRE_diam D 50.

# Drift cell anode wires material
GEOMETRY DCELL_AWIRE_mat S Inox

# Drift cell ground wires diametry (um)
GEOMETRY DCELL_GWIRE_diam D 50.

# Drift cell ground wires material
GEOMETRY DCELL_GWIRE_mat S Inox

# Drift cell cathode ring outer diameter (mm)
GEOMETRY DCELL_CRING_outer_diam D 23.

# Drift cell cathode ring inner diameter (mm)
GEOMETRY DCELL_CRING_inner_diam D 22.5

# Drift cell cathode ring height (mm)
GEOMETRY DCELL_CRING_height D 35.

# Drift cell ground wires material
GEOMETRY DCELL_CRING_mat S Copper

# Place extra ground wire between adjacent cells of same plane
GEOMETRY DCELL_GWIRE_extra_cell I 1

# Place extra ground wire between adjacent cells of adjacent planes
GEOMETRY DCELL_GWIRE_extra_plane I 1


#///////////////////   CALORIMETER BLOCKS   /////////////////////

# Calorimeter layout
GEOMETRY CALO_layout S basic

# Calorimeter blocks total thickness (wrapper included) (cm)
GEOMETRY CALO_BLOCK_thick D 10.

# Calorimeter blocks total height (wrapper included) (cm)
GEOMETRY CALO_BLOCK_height D 25.

# Calorimeter blocks total width (wrapper included) (cm)
GEOMETRY CALO_BLOCK_width D 25.

# Calorimeter blocks wrapper thickness (mm)
GEOMETRY CALO_WRAP_thick D 0.05

# Calorimeter blocks wrapper material (Mylar, ...)
GEOMETRY CALO_WRAP_mat S Mylar


#//////////////////////   MAGNETIC FIELD   ////////////////////////

# Magnetic field (B) intensity (in Gauss) (10 KGauss = 1 Tesla)
GEOMETRY B_int D 25.0

# Magnetic field (B) direction (Options: Y, Z)
GEOMETRY B_dir S Y

# end of SuperNEMO module geometry file
