//
//  All functions here should be OnX callbacks, that is to say
// functions with signature :
//   extern "C" {
//     void callback_without_arguments(IUI&);
//     void callback_with_arguments(IUI&,const std::vector<std::string>&);
//   }
//

//
// HEPVis and Inventor related callbacks.
//

#include <OnX/Helpers/OnX.h>
#include <OnX/Helpers/Inventor.h>

#include <Lib/mmanip.h>

#include <Inventor/nodes/SoOrthographicCamera.h>

// HEPVis :
#include <HEPVis/nodekits/SoPage.h>
#include <HEPVis/nodekits/SoDisplayRegion.h>

extern "C" {

//////////////////////////////////////////////////////////////////////////////
void snovis_eventEnd(
 Slash::UI::IUI& aUI
) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  Slash::Core::ISession& session = aUI.session();

  SoPage* soPage = ui_SoPage(aUI);
  if(!soPage) return;

  SoRegion* soRegion = soPage->currentRegion();
  if(!soRegion) return;

  soRegion->clear("dynamicScene");

  //data_collect(session,"Trajectory","particle==\"gamma\"");
  //data_collect(session,"Trajectory","particle==\"e-\"");
  //data_collect(session,"Trajectory","particle==\"e+\"");

  data_collect(session,"Trajectory");
  data_visualize(session);

  std::string svalue;
  if(!session.parameterValue("modeling.trajectories",svalue)) return;

  if( (svalue=="immediate_all") || 
      (svalue=="immediate_time") ||
      (svalue=="pickable") ) {
    std::string event_scan;
    session.parameterValue("event.scan",event_scan);
    if(event_scan=="yes") {
      //Enter secondary interactive loop to
      // play with the event :
      aUI.echo("Play with the event...");
      aUI.steer();
    } else {
      aUI.synchronize();
    }
  }
}
//////////////////////////////////////////////////////////////////////////////
void snovis_Page_create(
 Slash::UI::IUI& aUI
) 
//////////////////////////////////////////////////////////////////////////////
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!//
{
  SoPage* soPage = ui_SoPage(aUI);
  if(!soPage) return;

  soPage->deleteRegions();
  soPage->titleVisible.setValue(FALSE);
  soPage->title.setValue("snovis");
  soPage->createRegions("SoDisplayRegion",1,1,0);

  SoRegion* soRegion = soPage->currentRegion();
  if(!soRegion) return;

  soRegion->color.setValue(SbColor(0,0,0));
}


} // extern "C"
