// ModbucfgView.h : interface of the CModbucfgView class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_MODBUCFGVIEW_H__A3BAD4B5_F5AE_11D1_8FE9_6CD504C1BC01__INCLUDED_)
#define AFX_MODBUCFGVIEW_H__A3BAD4B5_F5AE_11D1_8FE9_6CD504C1BC01__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000


#include "Globals.h"
#include "ThinThread.h"
#include "afxwin.h"

class CModbucfgView : public CFormView,public CThinThread
{
protected: // create from serialization only
	CModbucfgView();
	DECLARE_DYNCREATE(CModbucfgView)

public:
	//{{AFX_DATA(CModbucfgView)
	enum { IDD = IDD_MODBUCFG_FORM };
	CComboBox	m_cboDataType;
	CEdit	m_edtInterval;
	CButton	m_butPollEnable;
	CStatic	m_statStatus;
	CStatic	m_staError;
	CListBox	m_lstValues;
	CComboBox	m_cboWriteFunctions;
	CComboBox	m_cboReadFunctions;
	CComboBox	m_cboConnections;
	CEdit	m_edtValue;
	CEdit	m_edtQuant;
	CEdit	m_edtDevice;
	CEdit	m_edtWriteAddr;
	CEdit	m_edtReadAddr;
	CButton	m_cmdWrite;
	//}}AFX_DATA

// Attributes
public:
	CModbucfgDoc* GetDocument();

	enum _Modbus_Functions_ {
	 LOOP_BACK_TEST=0,
	 READ_OUTPUT_REGISTERS=1,
	 READ_INPUT_REGISTERS=2,
	 READ_OUTPUT_STATUS=3,
	 READ_INPUT_STATUS=4,
	 PRESET_SINGLE_REGISTER=0,
	 FORCE_SINGLE_COIL=1,
	 WRITE_MULTIPLE_REGISTERS=2,
	 WRITE_MULTIPLE_COILS=3
	};

	enum _Data_Types_ {
		DATA_CHAR =0 , 
        DATA_SIGNED_16=1,
		DATA_UNSIGNED_16=2,
		DATA_FLOAT=3,
		DATA_FLOAT_REVERSE=4,
		DATA_DOUBLE=5,
		DATA_DOUBLE_REVERSE=6,
	};

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CModbucfgView)
	public:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual void OnInitialUpdate();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
public:
	void EndWork();
	virtual ~CModbucfgView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	CModbus* GetConnection();
	WORD ExecuteReadFunction(int iFunction,DWORD& dwTime , CString& rErrorMessage);
	WORD ExecuteCmdReadFunction(int iFunction,DWORD& dwTime , CString& rErrorMessage);
	void DoWork();
	void StartWork();
	void LoadControls();
	//{{AFX_MSG(CModbucfgView)
	afx_msg void OnchkEnablePoll();
	afx_msg void OnChangeEditInterval();
	afx_msg void OnCmdWrite();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

private:
	DWORD m_dwSum; //thread vars 
    DWORD m_dwCount; 
	DWORD m_dwErrors;

public:
	afx_msg void OnCbnSelchangeCboReadFunction();
	afx_msg void OnCbnSelchangeCboWriteFunction();

	afx_msg void OnAppMemMap();
	afx_msg void OnEnChangeEditQuant();
	afx_msg void OnEnChangeEditAddr();
	afx_msg void OnEnChangeEditQuant2();
	CEdit m_edtQuant2;
	afx_msg void OnLbnSelchangeList5();
	afx_msg void OnLbnSelchangeLstValues();
//	CListBox m_list5Values;
	afx_msg void OnEnChangeEditAddrWri();
	afx_msg void OnEnChangeEditValue();
	CEdit m_edtIndex;
	int m_spinIndex;
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);

	//tableaux pour les write multiple
	CByteArray m_bValueMultiple;
	CShortArray m_sValueMultiple;
	CWordArray m_wValueMultiple;
	CFloatArray m_fValueMultiple;
	CDblArray m_dValueMultiple;
	CEdit m_readEil;
	CEdit m_readSVd;
	CEdit m_readSVfin;
	CEdit m_readSV1;
	CEdit m_readSV2;
	CEdit m_readdtp;
	CEdit m_readdt;
	CEdit m_readdP;
	CEdit m_readdPsecu;
	afx_msg void OnEnChangeEdit10();
	CEdit m_readSVil;
	CEdit m_readSleil;
	CEdit m_readSTc;
	CEdit m_readNbal_max;
	CEdit m_readFr;
	CEdit m_readN_cur;
	CButton m_cmdRead;
	afx_msg void OnCmdRead();
	CEdit m_readNil;
	CEdit m_readNil_stat;
	CEdit m_readP_last;
	CEdit m_readN_last;
	CEdit m_readdPil;
	CEdit m_readV_cur;
	CEdit m_readPic;
	CEdit m_readTimer;
	CEdit m_readNbal;
	CEdit m_readP_cde;
	CEdit m_readPp;
	CEdit m_readStat_C_1;
	CEdit m_readStat_C_2;
	CEdit m_readStat_C_3;
	CEdit m_readStat_C_4;
	CEdit m_readStat_C_5;
	CEdit m_readStat_C_6;
	CEdit m_readStat_C_7;
	CEdit m_readStat_C_8;
	CEdit m_readNum_C1a;
	CEdit m_readNum_C1b;
	CEdit m_readNum_C2a;
	CEdit m_readNum_C2b;
	CEdit m_readNum_C3a;
	CEdit m_readNum_C3b;
	CEdit m_readNum_C4a;
	CEdit m_readNum_C4b;
	CEdit m_readN_Seqcond;
	CEdit m_readMAP;
	CEdit m_readTemp_cond_1;
	CEdit m_readTemp_cond_2;
	CEdit m_readTemp_cond_3;
	CEdit m_readTemp_cond_4;
	CEdit m_readTemp_cond_5;
	CEdit m_readTemp_cond_6;
	CEdit m_readTemp_cond_7;
	CEdit m_readTemp_cond_8;

	CListCtrl* m_readVacuum;
	CListCtrl* m_readCondParam;
	afx_msg void OnEnChangeEdit16();
	CEdit m_readStat_C_9;
	CEdit m_readStat_C_10;
	CEdit m_readStat_C_11;
	CEdit m_readStat_C_12;
	CEdit m_readTemp_cond_9;
	CEdit m_readTemp_cond_10;
	CEdit m_readTemp_cond_11;
	CEdit m_readTemp_cond_12;
	afx_msg void OnBnClickedButton1();
	afx_msg void OnBnClickedButton2();
	afx_msg void OnCmdStart();
	afx_msg void OnCmdStop();
	afx_msg void OnCmdPause();
	CButton m_cmdStart;
	CButton m_cmdStop;
	CButton m_cmdPause;
	CEdit m_readMode;
	CEdit m_readDateD;
	CEdit m_readHeureD;
	afx_msg void OnButtonReprise();
	CButton m_cmdReprise;
	afx_msg void OnEnChangeEdit14();
};

#ifndef _DEBUG  // debug version in ModbucfgView.cpp
inline CModbucfgDoc* CModbucfgView::GetDocument()
   { return (CModbucfgDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_MODBUCFGVIEW_H__A3BAD4B5_F5AE_11D1_8FE9_6CD504C1BC01__INCLUDED_)
