#include "cxfel.h"


#include "heure.h"

#using <mscorlib.dll>
#using <System.dll>
#using <System.Windows.Forms.dll>
#using <System.Drawing.dll>//pour les controles bouton

using namespace System;
using namespace System::ComponentModel;//contient des classes pour les composants et les contrles
using namespace System::Windows::Forms;//contient des classes ddies  la gnration des formulaires
using namespace System::Drawing;//contient les classes Point et Size du bouton

using namespace System::IO;//contient les classes pour les I/O

using namespace System::Threading;

//using MySql.Data;
//using MySql::Data::MySqlClient;
#using <System.Data.dll>
#using <MySql.Data.dll>
using namespace System::Data;
using namespace MySql::Data::MySqlClient;

#undef MessageBox

modbus_t *ctx;//modbus


public __gc class ThreadReadModbus 
{
public:
	// The ThreadProc method is called when the thread starts.
    static void ThreadProc()
	{
		uint8_t tab_rp_bits[MODBUS_SIZE_READ_COILS];
		Console::WriteLine(S"ThreadProc: read coils...");
		int rc = modbus_read_bits(ctx, MODBUS_BASEADR_COILS, MODBUS_SIZE_READ_COILS, tab_rp_bits);////JCM : adresse coils=MODBUS_BASEADR_COILS
		if (rc != MODBUS_SIZE_READ_COILS)
			Console::WriteLine(S"ThreadProc: read coils failed...");
		Thread::Sleep(500);

		uint16_t tab_rp_registers_low[MODBUS_SIZE_READ_HOLDINGS_LOW];
		Console::WriteLine(S"ThreadProc: read holdings...");
		rc = modbus_read_registers(ctx, MODBUS_BASEADR_LOW_HOLDINGS,//JCM : adresse holding=MODBUS_BASEADR_LOW_HOLDINGS
			MODBUS_SIZE_READ_HOLDINGS_LOW, tab_rp_registers_low);
		if (rc != MODBUS_SIZE_READ_HOLDINGS_LOW)
			Console::WriteLine(S"ThreadProc: read holdings failed...");
		Thread::Sleep(500);
 
		uint16_t wordPermuted[2];
		float real = modbus_get_float(tab_rp_registers_low+6);//dP : float32 Normal
		*(wordPermuted+0)= tab_rp_registers_low[6+1];//dP : float32 Reverse
		*(wordPermuted+1)= tab_rp_registers_low[6+0];//dP : float32 Reverse
		float realReversed = modbus_get_float(wordPermuted+0);//dP : float32 Reverse

		Console::WriteLine(S"ThreadProc: read float...");
//		if (real != UT_REAL)
//			Console::WriteLine(S"ThreadProc: read float failed...");
		printf("real(2006d) = normal=%f reverse=%f\n", 
			real,
			//word2float[0]+(word2float[1]<<16)
			//tab_rp_registers_low[6]+(tab_rp_registers_low[7]<<16));
			realReversed);
		Thread::Sleep(500);

		uint16_t tab_rp_registers_high[MODBUS_SIZE_READ_HOLDINGS_HIGH];
		Console::WriteLine(S"ThreadProc: read holdings...");
		rc = modbus_read_registers(ctx, MODBUS_BASEADR_HIGH_HOLDINGS,
			MODBUS_SIZE_READ_HOLDINGS_HIGH, tab_rp_registers_high);
		if (rc != MODBUS_SIZE_READ_HOLDINGS_HIGH)
			Console::WriteLine(S"ThreadProc: read holdings failed...");
		Thread::Sleep(500);

		real = modbus_get_float(tab_rp_registers_high+36);//Pi_max
		Console::WriteLine(S"ThreadProc: read float...");
//		if (real != UT_REAL)
//			Console::WriteLine(S"ThreadProc: read float failed...");
		printf("real(2118d) = %f\n", real);
		Thread::Sleep(500);
 	}
};


CGroupBox::CGroupBox(String* gname, int posX, int posY)
{
	name=gname;
	nbInstance++;

	// Creation
	gbox = new GroupBox();
	gbox->Text = name;
	gbox->Size = System::Drawing::Size(200, 200);//taille du groupbox en pixels
	gbox->Location = Point(posX,posY);

	// Num_P label tt seul
	Label* labNumP= new Label();
//	labNumP->Location = Point(posX+10,posY+5);
	labNumP->Location = Point(70,35);
	labNumP->Size = System::Drawing::Size(50,16);
	labNumP->Text = "Num_P";//zone de texte initialise 
	labNumP->Font = new System::Drawing::Font(S"Arial", 9, FontStyle::Bold);;
	labNumP->TextAlign = ContentAlignment::MiddleRight;
	valNumP= new TextBox();
	valNumP->Location = Point(70,55);
	valNumP->Size = System::Drawing::Size(60, 40);
	valNumP->Text = "xx";//zone de texte initialise vide
	valNumP->Font = new System::Drawing::Font(S"Arial", 9, FontStyle::Bold);
	valNumP->ForeColor = Color::Brown;
	gbox->Controls->Add(labNumP);
	gbox->Controls->Add(valNumP);
	// Num_C1 label tt seul
	Label* labNumC1= new Label();
//	labNumC1->Location = Point(posX+5, posY+20);
	labNumC1->Location = Point(20, 90);
	labNumC1->Size = System::Drawing::Size(50,16);
	labNumC1->Text = "1";//zone de texte initialise 
	labNumC1->Font = new System::Drawing::Font(S"Arial", 9, FontStyle::Bold);;
	labNumC1->TextAlign = ContentAlignment::MiddleRight;
	valNumC1= new TextBox();
	valNumC1->Location = Point(30,110);
	valNumC1->Size = System::Drawing::Size(60, 40);
	valNumC1->Text = "xx";//zone de texte initialise vide
	valNumC1->Font = new System::Drawing::Font(S"Arial", 9, FontStyle::Bold);;
	valNumC1->ForeColor = Color::Brown;
	gbox->Controls->Add(labNumC1);
	gbox->Controls->Add(valNumC1);
	// Num_C2 label tt seul
	Label* labNumC2= new Label();
//	labNumC2->Location = Point(posX+60, posY+20);
	labNumC2->Location = Point(85, 90);
	labNumC2->Size = System::Drawing::Size(50,16);
	labNumC2->Text = "2";//zone de texte initialise 
	labNumC2->Font = new System::Drawing::Font(S"Arial", 9, FontStyle::Bold);;
	labNumC2->TextAlign = ContentAlignment::MiddleRight;
	valNumC2= new TextBox();
	valNumC2->Location = Point(105,110);
	valNumC2->Size = System::Drawing::Size(60, 40);
	valNumC2->Text = "xx";//zone de texte initialise vide
	valNumC2->Font = new System::Drawing::Font(S"Arial", 9, FontStyle::Bold);;
	valNumC2->ForeColor = Color::Brown;
	gbox->Controls->Add(labNumC2);
	gbox->Controls->Add(valNumC2);
	//bouton Appliquer
	appliquerBtn = new Button();
	appliquerBtn->Location = Point(65, 170);
	appliquerBtn->Name = "Bouton Appliquer";
	appliquerBtn->Text = "Appliquer";
	appliquerBtn->Click += new EventHandler(this, &CGroupBox::AppliquerBtn_Clicked);
	gbox->Controls->Add(appliquerBtn);

/*
	String* str;
	str=String::Concat(labNumC1->Text);
	Console::WriteLine(str);	
	str=String::Concat(labNumC2->Text);
	Console::WriteLine(str);	
*/
	//..............
	//..............

}

Label* CGroupBox::GetLabelNumP()
{
	return labNumP;
}

Label* CGroupBox::GetLabelNumC1()
{
	return labNumC1;
}

Label* CGroupBox::GetLabelNumC2()
{
	return labNumC2;
}

GroupBox* CGroupBox::GetGroupBox()
{
	return gbox;
}

void CGroupBox::SetValNumP(String* value)
{
	valNumP->Text=value;
}

void CGroupBox::SetValNumC1(String* value)
{
	valNumC1->Text=value;
}

void CGroupBox::SetValNumC2(String* value)
{
	valNumC2->Text=value;
}

String* CGroupBox::GetValNumP() 
{ 
	return valNumP->Text; 
}

String* CGroupBox::GetValNumC1() 
{ 
	return valNumC1->Text; 
}

String* CGroupBox::GetValNumC2() 
{ 
	return valNumC2->Text; 
}

void CGroupBox::AppliquerBtn_Clicked(Object* pSender, EventArgs* pArgs)//gestionnaire d'evenements associs au bouton Appliquer
    {
		String* str;
		//lecture fichier pour comparaison avec saisie
		try
			{
//				FileStream* fs = new FileStream("..\\test1_4xsuc.txt",FileMode::Open);
				FileStream* fs = new FileStream("..\\couplers.txt",FileMode::Open);
				StreamReader* sr = new StreamReader(fs);
				int count=0;

			if(!String::Compare(name,"a"))
			{
				Console::WriteLine(S"appliquer a");
				for (;;)
				{
					String* line = sr->ReadLine();
//					if (count==0)
					if (count==1)//commentaire en 1ere ligne du fichier gnr par xfile
						if(String::Compare(line,valNumP->Text))
						{
							MessageBox::Show(S"a: NumP n'existe pas !!");
							sr->Close();
							break;
						}
//					if (count==1)
					if (count==2)//commentaire en 1ere ligne du fichier gnr par xfile
						if(String::Compare(line,valNumC1->Text))
						{
							MessageBox::Show(S"a: NumC1 n'existe pas !!");
							sr->Close();
							break;
						}
//					if (count==2)
					if (count==3)//commentaire en 1ere ligne du fichier gnr par xfile
						if(String::Compare(line,valNumC2->Text))
						{
							MessageBox::Show(S"a: NumC2 n'existe pas !!");
							sr->Close();
							break;
						}
					count++;
					if (line==0)//fin du fichier
					{
						sr->Close();
						uint16_t tab_rp_registers[2];
						int rc;
						int size;
						Console::WriteLine(S"CGroupBox::::AppliquerBtn_Clicked : write NumP NumC1 et NumC2...");
						size=1;
						tab_rp_registers[0] = Convert::ToInt16(valNumP->Text);
						rc=modbus_write_registers(ctx, 2070,size, tab_rp_registers);//NumP
						if (rc != size)
							Console::WriteLine(S"CGroupBox::::AppliquerBtn_Clicked : write holding failed...");		
	//					Console::WriteLine(S"CGroupBox::::AppliquerBtn_Clicked : write holding...");
						size=2;
						tab_rp_registers[0] = Convert::ToInt16(valNumC1->Text);
						tab_rp_registers[1] = Convert::ToInt16(valNumC2->Text);
						rc=modbus_write_registers(ctx, 2050,size, tab_rp_registers);//NumC1 et NumC2
						if (rc != size)
							Console::WriteLine(S"CGroupBox::::AppliquerBtn_Clicked : write holding failed...");		
						break;
					}
				}
			}
			if(!String::Compare(name,"b"))
			{
				Console::WriteLine(S"appliquer b");	
				for (;;)
				{
					String* line = sr->ReadLine();
//					if (count==3)
					if (count==4)//commentaire en 1ere ligne du fichier gnr par xfile
						if(String::Compare(line,valNumP->Text))
						{
							MessageBox::Show(S"b: NumP n'existe pas !!");
							sr->Close();
							break;
						}
//					if (count==4)
					if (count==5)//commentaire en 1ere ligne du fichier gnr par xfile
						if(String::Compare(line,valNumC1->Text))
						{
							MessageBox::Show(S"b: NumC1 n'existe pas !!");
							sr->Close();
							break;
						}
//					if (count==5)
					if (count==6)//commentaire en 1ere ligne du fichier gnr par xfile
						if(String::Compare(line,valNumC2->Text))
						{
							MessageBox::Show(S"b: NumC2 n'existe pas !!");
							sr->Close();
							break;
						}
					count++;
					if (line==0)//fin du fichier
					{
						sr->Close();
						uint16_t tab_rp_registers[2];
						int rc;
						int size;
						Console::WriteLine(S"CGroupBox::::AppliquerBtn_Clicked : write NumP NumC1 et NumC2...");
						size=1;
						tab_rp_registers[0] = Convert::ToInt16(valNumP->Text);
						rc=modbus_write_registers(ctx, 2071,size, tab_rp_registers);//NumP
						if (rc != size)
							Console::WriteLine(S"CGroupBox::::AppliquerBtn_Clicked : write holding failed...");		
	//					Console::WriteLine(S"CGroupBox::::AppliquerBtn_Clicked : write holding...");
						size=2;
						tab_rp_registers[0] = Convert::ToInt16(valNumC1->Text);
						tab_rp_registers[1] = Convert::ToInt16(valNumC2->Text);
						rc=modbus_write_registers(ctx, 2052,size, tab_rp_registers);//NumC1 et NumC2
						if (rc != size)
							Console::WriteLine(S"CGroupBox::::AppliquerBtn_Clicked : write holding failed...");		
						break;
					}
				}
			}
			if(!String::Compare(name,"c"))
			{
				Console::WriteLine(S"appliquer c");	
				for (;;)
				{
					String* line = sr->ReadLine();
//					if (count==6)
					if (count==7)//commentaire en 1ere ligne du fichier gnr par xfile
						if(String::Compare(line,valNumP->Text))
						{
							MessageBox::Show(S"c: NumP n'existe pas !!");
							sr->Close();
							break;
						}
//					if (count==7)
					if (count==8)//commentaire en 1ere ligne du fichier gnr par xfile
						if(String::Compare(line,valNumC1->Text))
						{
							MessageBox::Show(S"c: NumC1 n'existe pas !!");
							sr->Close();
							break;
						}
//					if (count==8)
					if (count==9)//commentaire en 1ere ligne du fichier gnr par xfile
						if(String::Compare(line,valNumC2->Text))
						{
							MessageBox::Show(S"c: NumC2 n'existe pas !!");
							sr->Close();
							break;
						}
					count++;
					if (line==0)//fin du fichier
					{
						sr->Close();
						uint16_t tab_rp_registers[2];
						int rc;
						int size;
						Console::WriteLine(S"CGroupBox::::AppliquerBtn_Clicked : write NumP NumC1 et NumC2...");
						size=1;
						tab_rp_registers[0] = Convert::ToInt16(valNumP->Text);
						rc=modbus_write_registers(ctx, 2072,size, tab_rp_registers);//NumP
						if (rc != size)
							Console::WriteLine(S"CGroupBox::::AppliquerBtn_Clicked : write holding failed...");		
	//					Console::WriteLine(S"CGroupBox::::AppliquerBtn_Clicked : write holding...");
						size=2;
						tab_rp_registers[0] = Convert::ToInt16(valNumC1->Text);
						tab_rp_registers[1] = Convert::ToInt16(valNumC2->Text);
						rc=modbus_write_registers(ctx, 2054,size, tab_rp_registers);//NumC1 et NumC2
						if (rc != size)
							Console::WriteLine(S"CGroupBox::::AppliquerBtn_Clicked : write holding failed...");		
						break;
					}
				}
			}
			if(!String::Compare(name,"d"))
			{
				Console::WriteLine(S"appliquer d");	
				for (;;)
				{
					String* line = sr->ReadLine();
//					if (count==9)
					if (count==10)//commentaire en 1ere ligne du fichier gnr par xfile
						if(String::Compare(line,valNumP->Text))
						{
							MessageBox::Show(S"d: NumP n'existe pas !!");
							sr->Close();
							break;
						}
//					if (count==10)
					if (count==11)//commentaire en 1ere ligne du fichier gnr par xfile
						if(String::Compare(line,valNumC1->Text))
						{
							MessageBox::Show(S"d: NumC1 n'existe pas !!");
							sr->Close();
							break;
						}
//					if (count==11)
					if (count==12)//commentaire en 1ere ligne du fichier gnr par xfile
						if(String::Compare(line,valNumC2->Text))
						{
							MessageBox::Show(S"d: NumC2 n'existe pas !!");
							sr->Close();
							break;
						}
					count++;
					if (line==0)//fin du fichier
					{
						sr->Close();
						uint16_t tab_rp_registers[2];
						int rc;
						int size;
						Console::WriteLine(S"CGroupBox::::AppliquerBtn_Clicked : write NumP NumC1 et NumC2...");
						size=1;
						tab_rp_registers[0] = Convert::ToInt16(valNumP->Text);
						rc=modbus_write_registers(ctx, 2073,size, tab_rp_registers);//NumP
						if (rc != size)
							Console::WriteLine(S"CGroupBox::::AppliquerBtn_Clicked : write holding failed...");		
	//					Console::WriteLine(S"CGroupBox::::AppliquerBtn_Clicked : write holding...");
						size=2;
						tab_rp_registers[0] = Convert::ToInt16(valNumC1->Text);
						tab_rp_registers[1] = Convert::ToInt16(valNumC2->Text);
						rc=modbus_write_registers(ctx, 2056,size, tab_rp_registers);//NumC1 et NumC2
						if (rc != size)
							Console::WriteLine(S"CGroupBox::::AppliquerBtn_Clicked : write holding failed...");		
						break;
					}
				}
			}
		}
		catch (System::Exception* pe)
			{
				Console::WriteLine(pe->ToString());
			}
		int count=0;

  }

CDialogConfig::CDialogConfig()
    {
        // dfinit les paramtres du formulaire
        Text = S"XSUC - ecriture serveur";
        FormBorderStyle = FormBorderStyle::Fixed3D;//impossible de modifier la taille
        Size = System::Drawing::Size(1000,800);

        // Creation de controle
        sortirBtn = new Button();
        
        // bouton OK
        sortirBtn->Location = Point(900, 700);
        sortirBtn->Name = "Bouton Sortir";
        sortirBtn->Text = "sortir";
        sortirBtn->DialogResult = DialogResult::OK;

        // Ajoute les controles dans le formaulaire
        Controls->Add(sortirBtn);

		pal = new ArrayList();
		int j=20;//depart affichage
		for (indexGroupBox=0;indexGroupBox<NB_BANCS;indexGroupBox++)//creation des controles dans le formulaire
		{
			pal->Add(new CGroupBox(gname[indexGroupBox],j,90));
			j+=250;
			CGroupBox* gboxPtr = (CGroupBox *) pal->get_Item(indexGroupBox);
			Controls->Add(gboxPtr->GetGroupBox());
			String* str;
			str=String::Concat(gboxPtr->GetGroupBox()->Text);
			Console::WriteLine(str);	
/*			str=String::Concat(gboxPtr->GetLabelNumP()->Text);
			Console::WriteLine(str);	
			str=String::Concat(gboxPtr->GetLabelNumC1()->Text);
			Console::WriteLine(str);	
*/		}

		//configure les 2 proprits : AcceptButton contient la rf du bouton par dfaut du formulaire..
		//..on peut cliquer sur le bouton OK ou bien sur la touche Entre du clavier..
		//..referme aussi la boite car DialogResult renvoie OK
        AcceptButton = sortirBtn;

		//Tp_max
		labTp_max = new Label();
		valTp_max = new TextBox();
		labN_cur = new Label();
		valN_cur = new ComboBox();
		btnAppliquer = new Button();
		labTp_max->Location = Point(200,600);
		labTp_max->Size = System::Drawing::Size(86,16);
		labTp_max->Text = "Tp_max(min):";
		labTp_max->TextAlign = ContentAlignment::MiddleRight;
		labTp_max->Font = new System::Drawing::Font(S"Arial", 9, FontStyle::Bold);;
		Controls->Add(labTp_max);
		valTp_max->Location = Point(290,600);
		valTp_max->Size = System::Drawing::Size(50,20);
		valTp_max->Text = "";
		valTp_max->Font = new System::Drawing::Font(S"Arial", 9, FontStyle::Bold);;
		valTp_max->ForeColor = Color::Blue;
		Controls->Add(valTp_max);
		labN_cur->Location = Point(200,625);
		labN_cur->Size = System::Drawing::Size(80,16);
		labN_cur->Text = "N_cur:";
		labN_cur->TextAlign = ContentAlignment::MiddleRight;
		labN_cur->Font = new System::Drawing::Font(S"Arial", 9, FontStyle::Bold);;
		Controls->Add(labN_cur);
		valN_cur->DropDownWidth=121;
		valN_cur->Location = Point(290,625);
		valN_cur->Size = System::Drawing::Size(50,121);
		valN_cur->Items->Add(S"1");
		valN_cur->Items->Add(S"2");
		valN_cur->Items->Add(S"3");
		valN_cur->Items->Add(S"4");
		valN_cur->Items->Add(S"5");
		valN_cur->Items->Add(S"6");
		valN_cur->Items->Add(S"7");
		valN_cur->Font = new System::Drawing::Font(S"Arial", 9, FontStyle::Bold);;
		valN_cur->ForeColor = Color::Blue;
        valN_cur->SelectedIndex = 0;//affiche la 1ere chaine par defaut
		Controls->Add(valN_cur);
		btnAppliquer = new Button();
		btnAppliquer->Location = Point(350, 600);
		btnAppliquer->Name = "Bouton Appliquer";
		btnAppliquer->Text = "Appliquer";
		btnAppliquer->Click += new EventHandler(this, &CDialogConfig::BtnAppliquer_Clicked);
		Controls->Add(btnAppliquer);

       // Creation du GroupBox
        gboxAuto = new GroupBox();
        gboxAuto->Text = S"saisie auto";
 		gboxAuto->Size = System::Drawing::Size(200, 200);//taille du groupbox en pixels
        gboxAuto->Location = Point(600, 400);
        // Creation des boutons radio.
        rbAutoBdd = new RadioButton();
        rbAutoBdd->Text = S"Base de donnes";
		rbAutoBdd->Size = System::Drawing::Size(80,50);
		rbAutoBdd->Font = new System::Drawing::Font(S"Arial", 9, FontStyle::Bold);;
        rbAutoBdd->Location = Point(10,35);
		rbAutoBdd->Checked = true;//c'est la valeur par defaut
        rbAutoFichier = new RadioButton();
        rbAutoFichier->Text = S"Fichier";
		rbAutoFichier->Size = System::Drawing::Size(80,50);
 		rbAutoFichier->Font = new System::Drawing::Font(S"Arial", 9, FontStyle::Bold);;
        rbAutoFichier->Location = Point(10,75);
		// creation du bouton Appliquer
		BtnAppliquerAuto = new Button();
		BtnAppliquerAuto->Location = Point(60, 140);
		BtnAppliquerAuto->Name = "Bouton Appliquer";
		BtnAppliquerAuto->Text = "Appliquer";
		// ajout des controles dans le groupe 
        gboxAuto->Controls->Add(rbAutoBdd);
        gboxAuto->Controls->Add(rbAutoFichier);
        gboxAuto->Controls->Add(BtnAppliquerAuto);
        // ajout du groupe dans le formulaire.
        Controls->Add(gboxAuto);
        // associe le gestionnaire au groupe d'options
        rbAutoBdd->Click += new EventHandler(this, &CDialogConfig::Radio_Clicked);
        rbAutoFichier->Click += new EventHandler(this, &CDialogConfig::Radio_Clicked);
		BtnAppliquerAuto->Click += new EventHandler(this, &CDialogConfig::BtnAppliquerAuto_Clicked);

		//N_cur
		labN_cur4Reprise = new Label();
		valN_cur4Reprise = new TextBox();
		labN_cur4Reprise->Location = Point(200,500);
		labN_cur4Reprise->Size = System::Drawing::Size(86,16);
		labN_cur4Reprise->Text = "N_cur:";
		labN_cur4Reprise->TextAlign = ContentAlignment::MiddleRight;
		labN_cur4Reprise->Font = new System::Drawing::Font(S"Arial", 9, FontStyle::Bold);;
		Controls->Add(labN_cur4Reprise);
		valN_cur4Reprise->Location = Point(290,500);
		valN_cur4Reprise->Size = System::Drawing::Size(50,20);
		valN_cur4Reprise->Text = "";
		valN_cur4Reprise->Font = new System::Drawing::Font(S"Arial", 9, FontStyle::Bold);;
		valN_cur4Reprise->ForeColor = Color::Blue;
		Controls->Add(valN_cur4Reprise);
		btnN_curAppliquer = new Button();
		btnN_curAppliquer->Location = Point(350, 500);
		btnN_curAppliquer->Name = "Bouton Appliquer";
		btnN_curAppliquer->Text = "Appliquer";
		btnN_curAppliquer->Click += new EventHandler(this, &CDialogConfig::btnN_curAppliquer_Clicked);
		Controls->Add(btnN_curAppliquer);

		//gestionnnaire associ au bouton OK
		sortirBtn->Click += new EventHandler(this, &CDialogConfig::SortirBtn_Clicked);
	}

CDialogConfig::CDialogConfig(uint16_t *tab_rp_registers_low,uint16_t *tab_rp_registers_high)
    {
        // dfinit les paramtres du formulaire
        Text = S"XSUC - ecriture serveur";
        FormBorderStyle = FormBorderStyle::Fixed3D;//impossible de modifier la taille
        Size = System::Drawing::Size(1000,800);

        // Creation de controle
        sortirBtn = new Button();
        
        // bouton OK
        sortirBtn->Location = Point(900, 700);
        sortirBtn->Name = "Bouton Sortir";
        sortirBtn->Text = "sortir";
        sortirBtn->DialogResult = DialogResult::OK;

        // Ajoute les controles dans le formaulaire
        Controls->Add(sortirBtn);

		pal = new ArrayList();
		int j=20;//depart affichage
		for (indexGroupBox=0;indexGroupBox<NB_BANCS;indexGroupBox++)//creation des controles dans le formulaire
		{
			pal->Add(new CGroupBox(gname[indexGroupBox],j,90));
			j+=250;
			CGroupBox* gboxPtr = (CGroupBox *) pal->get_Item(indexGroupBox);
			Controls->Add(gboxPtr->GetGroupBox());
			String* str;
			str=String::Concat(gboxPtr->GetGroupBox()->Text);
			Console::WriteLine(str);	
/*			str=String::Concat(gboxPtr->GetLabelNumP()->Text);
			Console::WriteLine(str);	
			str=String::Concat(gboxPtr->GetLabelNumC1()->Text);
			Console::WriteLine(str);	
*/		}

		//configure les 2 proprits : AcceptButton contient la rf du bouton par dfaut du formulaire..
		//..on peut cliquer sur le bouton OK ou bien sur la touche Entre du clavier..
		//..referme aussi la boite car DialogResult renvoie OK
        AcceptButton = sortirBtn;

		//gestionnnaire associ au bouton OK
		sortirBtn->Click += new EventHandler(this, &CDialogConfig::SortirBtn_Clicked);
	}

void CDialogConfig::SortirBtn_Clicked(Object* pSender,EventArgs* pArgs)//gestionnaire d'evenement de la boite dialogue
	{
		//fermer le formulaire lorsqu'on clique sur le bouton
		Close();
	}

void CDialogConfig::BtnAppliquer_Clicked(Object* pSender, EventArgs* pArgs)//gestionnaire d'evenement associ  la liste deroulante
    {
		int nCur=0;

//		String* ps = String::Concat(S"index is ",__box(valN_cur->SelectedIndex)->ToString());
//		MessageBox::Show(ps,S"index");
        String* ps = __box(valN_cur->SelectedIndex)->ToString();
		if(String::Compare(ps,"0")==0)
			nCur=1;
		if(String::Compare(ps,"1")==0)
			nCur=2;
		if(String::Compare(ps,"2")==0)
			nCur=3;
		if(String::Compare(ps,"3")==0)
			nCur=4;
		if(String::Compare(ps,"4")==0)
			nCur=5;
		if(String::Compare(ps,"5")==0)
			nCur=6;
		if(String::Compare(ps,"6")==0)
			nCur=7;
		if (getTp_max()!=NULL)//case non vide uniquement
		{
			int result = Convert::ToInt16(getTp_max());
			if ((result<60)||(result>840))//compris entre 1 heure et 14 heures
			{
//				MessageBox::Show(S"1 heure <= Tp_max <= 14 heures");
				MessageBox::Show(S"60 minutes <= Tp_max <= 840 minutes");
				return;
			}
			Console::WriteLine(S"ecriture Tp_max");
			uint16_t tab_rp_registers[1];
			int rc;
			int size;
			Console::WriteLine(S"CDialogConfig::BtnAppliquer_Clicked : write Tp_max...");
			size=1;
			tab_rp_registers[0] = result;
			rc=modbus_write_registers(ctx, 2106+(nCur-1),size, tab_rp_registers);//Tp_max
			if (rc != size)
				Console::WriteLine(S"CDialogConfig::BtnAppliquer_Clicked : write Tp_max failed...");
		}
    }

void CDialogConfig::btnN_curAppliquer_Clicked(Object* pSender, EventArgs* pArgs)//gestionnaire d'evenement associ  la liste deroulante
    {
		int nCur;

		if (getN_cur()!=NULL)//case non vide uniquement
		{
			int result = Convert::ToInt16(getN_cur());
			if ((result<0)||(result>8))//compris entre 1 et 8
			{
				MessageBox::Show(S"0 <= N_cur <= 8");
				return;
			}
			Console::WriteLine(S"ecriture N_cur");
			uint16_t tab_rp_registers[1];
			int rc;
			int size;
			Console::WriteLine(S"CDialogConfig::BtnAppliquer_Clicked : write N_cur...");
			size=1;
			tab_rp_registers[0] = result;
			rc=modbus_write_registers(ctx, 2027, size, tab_rp_registers);//N_cur
			if (rc != size)
				Console::WriteLine(S"CDialogConfig::BtnAppliquer_Clicked : write N_cur failed...");
		}
    }

String* CDialogConfig::getTp_max() 
{ 
	return valTp_max->Text; 
}

String* CDialogConfig::getN_cur() 
{ 
	return valN_cur4Reprise->Text; 
}

void CDialogConfig::BtnAppliquerAuto_Clicked(Object* pSender,EventArgs* pArgs)//gestionnaire d'evenement de la boite dialogue
	{

		/*\*/
//....
//....lire la bd OU le fichier selon le rb
//....msgbox en cas d'erreur
//....afficher ds les zones saisies
//....ecrire sur le modbus ts les perametres


		if (lectBddFic==true)//lecture bdd selectionne
		{
/*
structure table stand_with_couplers dans la base de donnes :
+----------------+--------------------------------------+------+-----+---------+-------+
| Field          | Type                                 | Null | Key | Default | Extra |
+----------------+--------------------------------------+------+-----+---------+-------+
| idStand        | char(1)                              | NO   |     |         |       | 
| idPair         | char(11)                             | YES  |     | NULL    |       | 
| idCoupler1     | char(13)                             | NO   |     |         |       | 
| idCoupler2     | char(13)                             | NO   |     |         |       | 
| idConditioning | int(11)                              | YES  |     | NULL    |       | 
| status         | enum('to-dryheat','to-conditioning') | YES  |     | NULL    |       | 
+----------------+--------------------------------------+------+-----+---------+-------+
*/
//		Console::WriteLine(S"CDialogConfig::BtnAppliquerAuto_Clicked : connexion bdd...");

			//lecture fichier qui contient le host et la base
			String* sHost;
			String* sName;
			try
				{
					FileStream* fs = new FileStream("..\\condb.txt",FileMode::Open);
					StreamReader* sr = new StreamReader(fs);
					int count=0;
					for (;;)
					{
						String* line = sr->ReadLine();
						//commentaire sur les 3res lignes du fichier
						if (count==3)
							sHost=line;
						if (count==4)
							sName=line;
						count++;
						if (line==0)//fin du fichier
						{
							sr->Close();
							String* stra[] = {S"Host=",sHost,S" Name=",sName};
							String* str=String::Concat(stra);
							Console::WriteLine(str);
							break;
						}
					}
				}
			catch (System::Exception* pe)
				{
					Console::WriteLine(pe->ToString());
				}

//			String* connStr = "server=lalsrv1.lal.in2p3.fr;User Id=xfel;Database=xfel_tst;port=3306;Password=pwd4xfel;";
			String* str[] = {S"server=",sHost,S";User Id=xfel;Database=",sName,S";port=3306;Password=pwd4xfel;"};
			String* connStr=String::Concat(str);
			MySqlConnection* conn = new MySqlConnection(connStr);
			try 
			{
				conn->Open();
			}
			catch (System::Exception* pe) 
			{
				MessageBox::Show(pe->ToString());
//			Console::WriteLine(pe->ToString());
			}

//		String* sql = "select idstand,idpair, idcoupler1,idcoupler2 from stand_with_couplers where status='to-conditioning'";
			String* sql = "select idstand,idpair, idcoupler1,idcoupler2,status from stand_with_couplers where status='to-conditioning' order by idStand";
			MySqlCommand* cmd = new MySqlCommand(sql, conn);

			MySqlDataReader* myReader;
			myReader = cmd->ExecuteReader();
			try
			{
				uint16_t tabNumP[4]={0,0,0,0};
				uint16_t tabNumC1C2[8]={0,0,0,0,0,0,0,0};
				int rc;
				int size;

				while(myReader->Read())
				{ 
					String* str;
					if(!String::Compare(myReader->GetString(0),"a"))//banc a
					{
						Console::WriteLine(myReader->GetString(1));
						CGroupBox* gboxPtr = (CGroupBox*)pal->get_Item(0);
						str = (myReader->GetString(1))->Remove(0,8);
						gboxPtr->SetValNumP(str);
						tabNumP[0] = Convert::ToInt16(str);
						str = (myReader->GetString(2))->Remove(0,8);
						gboxPtr->SetValNumC1(str);
						tabNumC1C2[0] = Convert::ToInt16(str);
						str = (myReader->GetString(3))->Remove(0,8);
						gboxPtr->SetValNumC2(str);
						tabNumC1C2[1] = Convert::ToInt16(str);
					}
					if(!String::Compare(myReader->GetString(0),"b"))//banc b
					{
						Console::WriteLine(myReader->GetString(1));
						CGroupBox* gboxPtr = (CGroupBox*)pal->get_Item(1);
						str = (myReader->GetString(1))->Remove(0,8);
						gboxPtr->SetValNumP(str);
						tabNumP[1] = Convert::ToInt16(str);
						str = (myReader->GetString(2))->Remove(0,8);
						gboxPtr->SetValNumC1(str);
						tabNumC1C2[2] = Convert::ToInt16(str);
						str = (myReader->GetString(3))->Remove(0,8);
						gboxPtr->SetValNumC2(str);
						tabNumC1C2[3] = Convert::ToInt16(str);
					}
					if(!String::Compare(myReader->GetString(0),"c"))//banc c
					{
						Console::WriteLine(myReader->GetString(1));
						CGroupBox* gboxPtr = (CGroupBox*)pal->get_Item(2);
						str = (myReader->GetString(1))->Remove(0,8);
						gboxPtr->SetValNumP(str);
						tabNumP[2] = Convert::ToInt16(str);
						str = (myReader->GetString(2))->Remove(0,8);
						gboxPtr->SetValNumC1(str);
						tabNumC1C2[4] = Convert::ToInt16(str);
						str = (myReader->GetString(3))->Remove(0,8);
						gboxPtr->SetValNumC2(str);
						tabNumC1C2[5] = Convert::ToInt16(str);
					}
					if(!String::Compare(myReader->GetString(0),"d"))//banc d
					{
						Console::WriteLine(myReader->GetString(1));
						CGroupBox* gboxPtr = (CGroupBox*)pal->get_Item(3);
						str = (myReader->GetString(1))->Remove(0,8);
						gboxPtr->SetValNumP(str);
						tabNumP[3] = Convert::ToInt16(str);
						str = (myReader->GetString(2))->Remove(0,8);
						gboxPtr->SetValNumC1(str);
						tabNumC1C2[6] = Convert::ToInt16(str);
						str = (myReader->GetString(3))->Remove(0,8);
						gboxPtr->SetValNumC2(str);
						tabNumC1C2[7] = Convert::ToInt16(str);
					}
				}//while
				//fin du fichier : on ecrit sur le modbus
				Console::WriteLine(S"CGroupBox::::AppliquerBtn_Clicked : write NumP NumC1 et NumC2...");
				size=4;
				rc=modbus_write_registers(ctx, 2070,size, tabNumP);//NumP
				if (rc != size)
					Console::WriteLine(S"CGroupBox::::AppliquerBtn_Clicked : write holding failed...");		
				size=8;
				rc=modbus_write_registers(ctx, 2050,size, tabNumC1C2);//NumC1 et NumC2
				if (rc != size)
					Console::WriteLine(S"CGroupBox::::AppliquerBtn_Clicked : write holding failed...");		
			}
			catch (System::Exception* pe)
			{
				Console::WriteLine(pe->ToString());
			}
			myReader->Close();
			conn->Close();
		}//fin lectBddFic true
		else//lecture fichier selectionne
		{
/*
format fichier couplers.txt (13 lignes) :
#id conditionnement
NumP banc a
NumC1 banc a
NumC2 banc a
NumP banc b
NumC1 banc b
NumC2 banc b
NumP banc c
NumC1 banc c
NumC2 banc c
NumP banc d
NumC1 banc d
NumC2 banc d
*/
			String* str;
			try
			{
				FileStream* fs = new FileStream("..\\couplers.txt",FileMode::Open);
				StreamReader* sr = new StreamReader(fs);
				int count=0;
				uint16_t tabNumP[4]={0,0,0,0};
				uint16_t tabNumC1C2[8]={0,0,0,0,0,0,0,0};
				int rc;
				int size;

				for (;;)
				{
					String* line = sr->ReadLine();
					CGroupBox* gboxPtr;
					if (count)
					{
						switch (count)
						{
							case 1 : case 2 : case 3 :
								{//banc a
									Console::WriteLine(line);
									CGroupBox* gboxPtr = (CGroupBox*)pal->get_Item(0);
									if (count == 1)
									{
										gboxPtr->SetValNumP(line);
										tabNumP[0] = Convert::ToInt16(line);
									}
									if (count == 2)
									{
										gboxPtr->SetValNumC1(line);
										tabNumC1C2[0] = Convert::ToInt16(line);
									}
									if (count == 3)
									{
										gboxPtr->SetValNumC2(line);
										tabNumC1C2[1] = Convert::ToInt16(line);
									}
								}
								break;
							case 4 : case 5 : case 6 :
								{//banc b
									Console::WriteLine(line);
									CGroupBox* gboxPtr = (CGroupBox*)pal->get_Item(1);
									if (count == 4)
									{
										gboxPtr->SetValNumP(line);
										tabNumP[1] = Convert::ToInt16(line);
									}
									if (count == 5)
									{
										gboxPtr->SetValNumC1(line);
										tabNumC1C2[2] = Convert::ToInt16(line);
									}
									if (count == 6)
									{
										gboxPtr->SetValNumC2(line);
										tabNumC1C2[3] = Convert::ToInt16(line);
									}
								}
								break;
							case 7 : case 8 : case 9 :
								{//banc c
									Console::WriteLine(line);
									gboxPtr = (CGroupBox*)pal->get_Item(2);
									if (count == 7)
									{
										gboxPtr->SetValNumP(line);
										tabNumP[2] = Convert::ToInt16(line);
									}
									if (count == 8)
									{
										gboxPtr->SetValNumC1(line);
										tabNumC1C2[4] = Convert::ToInt16(line);
									}
									if (count == 9)
									{
										gboxPtr->SetValNumC2(line);
										tabNumC1C2[5] = Convert::ToInt16(line);
									}
								}
								break;
							case 10 : case 11 : case 12 :
								{//banc d
									Console::WriteLine(line);
									CGroupBox* gboxPtr = (CGroupBox*)pal->get_Item(3);
									if (count == 10)
									{
										gboxPtr->SetValNumP(line);
										tabNumP[3] = Convert::ToInt16(line);
									}
									if (count == 11)
									{
										gboxPtr->SetValNumC1(line);
										tabNumC1C2[6] = Convert::ToInt16(line);
									}
									if (count == 12)
									{
										gboxPtr->SetValNumC2(line);
										tabNumC1C2[7] = Convert::ToInt16(line);
									}
								}
								break;
						}
					}
					count++;
					if (line==0)//fin du fichier : on ecrit sur le modbus
					{
						sr->Close();
						Console::WriteLine(S"CGroupBox::::AppliquerBtn_Clicked : write NumP NumC1 et NumC2...");
						size=4;
						rc=modbus_write_registers(ctx, 2070,size, tabNumP);//NumP
						if (rc != size)
							Console::WriteLine(S"CGroupBox::::AppliquerBtn_Clicked : write holding failed...");		
						size=8;
						rc=modbus_write_registers(ctx, 2050,size, tabNumC1C2);//NumC1 et NumC2
						if (rc != size)
							Console::WriteLine(S"CGroupBox::::AppliquerBtn_Clicked : write holding failed...");		
						break;
					}
				}
			}
			catch (System::Exception* pe)
			{
				Console::WriteLine(pe->ToString());
			}

		}//fin lectBddFic false
	}

void CDialogConfig::Radio_Clicked(Object* pSender, EventArgs* pArgs)//remplit automatiquement la zone de texte
    {
		for(int index=0;index<NB_BANCS;index++)
		{//zones de texte initialise vide
			CGroupBox* gboxPtr = (CGroupBox*)pal->get_Item(index);
			gboxPtr->SetValNumP("xx");
			gboxPtr->SetValNumC1("xx");
			gboxPtr->SetValNumC2("xx");
		}

		if (pSender == rbAutoBdd)
		{
			Console::WriteLine(S"CDialogConfig::Radio_Clicked : lecture bdd active...");
			lectBddFic=true;
		}
        else if (pSender == rbAutoFichier)
		{
			Console::WriteLine(S"CDialogConfig::Radio_Clicked : lecture fichier active...");
			lectBddFic=false;
		}	
	}


CLabelTextBox::CLabelTextBox(String* labString, int posX, int posY, int sizeX, int sizeY, int sizeText)
{
	name=labString;
	labPosX=posX;
	labPosY=posY;
	labSizeX=sizeX;
	labSizeY=sizeY;
	nbInstance++;

	lab= new Label();
	val= new TextBox();
	
	// dPLabel et dPBox : label et zone de saisie sont placs  l'un  ct de l'autre
	lab->Location = Point(labPosX, labPosY);
	lab->Size = System::Drawing::Size(labSizeX,labSizeY);
	lab->Text = name;//zone de texte initialise 
	lab->TextAlign = ContentAlignment::MiddleRight;
	val->Location = Point(labPosX+labSizeX, labPosY);
	val->Size = System::Drawing::Size(sizeText, 20);
	val->Text = "";//zone de texte initialise vide
	val->Font = new System::Drawing::Font(S"Arial", 9, FontStyle::Bold);;
	val->ForeColor = Color::Brown;
}

Label* CLabelTextBox::GetLabel()
{
	return lab;
}

TextBox* CLabelTextBox::GetTextBox()
{
	return val;
}

String* CLabelTextBox::GetName()
{
return name;
}

void CLabelTextBox::SetVal(String* value)
{
	val->Text=value;
}

String* CLabelTextBox::GetVal()
{
	return val->Text;
}

void CLabelTextBox::SetColor(int value)
{
/*	if(value)
		val->BackColor=Color::Red;
	else
		val->BackColor=Color::White;
		*/
	if(!value)
		val->BackColor=Color::White;
	if(value==1)
		val->BackColor=Color::Red;
	if(value==2)
		val->BackColor=Color::LemonChiffon;
}


MaDialogUser::MaDialogUser()
    {
        // dfinit les paramtres du formulaire
		Text = S"XSUC - lecture serveur";
 //       FormBorderStyle = FormBorderStyle::Fixed3D;//impossible de modifier la taille
		FormBorderStyle = FormBorderStyle::FixedDialog;
		MaximizeBox = false;
		MinimizeBox = false;
		this->ControlBox=false;
		Size = System::Drawing::Size(1250,800);

        // Creation de controle
        OKBtn = new Button();
		EcritureBtn = new Button();
//        CancelBtn = new Button();
        
        // bouton OK
        OKBtn->Location = Point(900, 700);
        OKBtn->Name = "Bouton OK";
        OKBtn->Text = "OK";
        OKBtn->DialogResult = DialogResult::OK;
/*
        // bouton Cancel
        CancelBtn->Location = Point(192, 136);
        CancelBtn->Name = "Bouton Cancel";
        CancelBtn->Text = "Annuler";
        CancelBtn->DialogResult = DialogResult::Cancel;
*/
		// bouton Ecriture
        EcritureBtn->Location = Point(900, 600);
        EcritureBtn->Name = "Bouton Ecriture";
        EcritureBtn->Text = "Ecriture";
//		EcritureBtn->DialogResult = DialogResult::OK;//sinon fermera aussi la fenetre parente

        // Ajoute les controles dans le formaulaire
        Controls->Add(OKBtn);
        Controls->Add(EcritureBtn);

		pal = new ArrayList();
		for (indexTextBox=0;indexTextBox<20;indexTextBox++)//creation des controles dans le formulaire
		{
			int posX=650, j=indexTextBox;
			if (indexTextBox>=10)
			{
				posX=810;
				j=indexTextBox-10;
			}
			pal->Add(new CLabelTextBox(nameLab_1[indexTextBox],posX,(25*j)+10,100,16,70));
			CLabelTextBox* cltbPtr = (CLabelTextBox *) pal->get_Item(indexTextBox);
			Controls->Add(cltbPtr->GetLabel());
			Controls->Add(cltbPtr->GetTextBox());
		}
		for (;indexTextBox<26;indexTextBox++)//creation des controles dans le formulaire
		{
			int posX=400, j=indexTextBox-20;
			int sizeText=70;
			if (indexTextBox==20)sizeText=20;
			pal->Add(new CLabelTextBox(nameLab_1[indexTextBox],posX,(25*j)+10,100,16,sizeText));
			CLabelTextBox* cltbPtr = (CLabelTextBox *) pal->get_Item(indexTextBox);
			Controls->Add(cltbPtr->GetLabel());
			Controls->Add(cltbPtr->GetTextBox());
		}

		Setup_Group_Conditionning();

		// Mode tt seul
		pal->Add(new CLabelTextBox("MODE",20,100,50,16,75));
		CLabelTextBox* cltbPtr = (CLabelTextBox *) pal->get_Item(indexTextBox++);
		Controls->Add(cltbPtr->GetLabel());
		Controls->Add(cltbPtr->GetTextBox());

		//sauve l'index condionning
		indexTextBoxSave=indexTextBox;//04-07-2013 : nouveaux controles
		// Ln
		// Ln tt seul
		Label* ln= new Label();
		ln->Location = Point(950, 300);
		ln->Size = System::Drawing::Size(70,16);
		ln->Text = nameLab_5[1];//zone de texte initialise 
		ln->TextAlign = ContentAlignment::MiddleCenter;
		Controls->Add(ln);
		int j=0;
		for (;indexTextBox<(indexTextBoxSave+8);indexTextBox++)//creation des controles dans le formulaire
		{
			int posX=850;int posY=300;
			int sizeText=70;
			pal->Add(new CLabelTextBox(nameLab_6[indexTextBox-indexTextBoxSave],posX,posY+(j+=20),100,16,sizeText));
			CLabelTextBox* cltbPtr = (CLabelTextBox *) pal->get_Item(indexTextBox);
			Controls->Add(cltbPtr->GetLabel());
			Controls->Add(cltbPtr->GetTextBox());
//			Console::WriteLine(indexTextBox);
//			Console::WriteLine(posX);
//			Console::WriteLine(posY);
		}

		//sauve l'index condionning
		indexTextBoxSave=indexTextBox;//04-07-2013 : nouveaux controles
		//Tp_max
		//Tp_max tt seul
		Label* tp_max= new Label();
		tp_max->Location = Point(1050, 300);
		tp_max->Size = System::Drawing::Size(75,16);
		tp_max->Text = nameLab_5[2];//zone de texte initialise 
		tp_max->TextAlign = ContentAlignment::MiddleCenter;
		Controls->Add(tp_max);
		j=0;
		for (;indexTextBox<(indexTextBoxSave+7);indexTextBox++)//creation des controles dans le formulaire
		{
			int posX=950;int posY=300;
			int sizeText=70;
			pal->Add(new CLabelTextBox(nameLab_6[indexTextBox-indexTextBoxSave],posX,posY+(j+=20),100,16,sizeText));
			CLabelTextBox* cltbPtr = (CLabelTextBox *) pal->get_Item(indexTextBox);
			Controls->Add(cltbPtr->GetLabel());
			Controls->Add(cltbPtr->GetTextBox());
//			Console::WriteLine(indexTextBox);
//			Console::WriteLine(posX);
//			Console::WriteLine(posY);
		}

		//sauve l'index condionning
		indexTextBoxSave=indexTextBox;//04-07-2013 : nouveaux controles
		//Pi_max
		//Pi_max tt seul
		Label* pi_max= new Label();
		pi_max->Location = Point(1150, 300);
		pi_max->Size = System::Drawing::Size(70,16);
		pi_max->Text = nameLab_5[3];//zone de texte initialise 
		pi_max->TextAlign = ContentAlignment::MiddleCenter;
		Controls->Add(pi_max);
		j=0;
		for (;indexTextBox<(indexTextBoxSave+8);indexTextBox++)//creation des controles dans le formulaire
		{
			int posX=1050;int posY=300;
			int sizeText=70;
			pal->Add(new CLabelTextBox(nameLab_6[indexTextBox-indexTextBoxSave],posX,posY+(j+=20),100,16,sizeText));
			CLabelTextBox* cltbPtr = (CLabelTextBox *) pal->get_Item(indexTextBox);
			Controls->Add(cltbPtr->GetLabel());
			Controls->Add(cltbPtr->GetTextBox());
//			Console::WriteLine(indexTextBox);
//			Console::WriteLine(posX);
//			Console::WriteLine(posY);
		}

		// ERREUR tt seul
		//sauve l'index condionning
		indexTextBoxSave=indexTextBox;//04-07-2013 : nouveaux controles
		for (;indexTextBox<(indexTextBoxSave+1);indexTextBox++)//creation des controles dans le formulaire
		{
			int sizeText=100;
			pal->Add(new CLabelTextBox("Erreur",900,550,100,16,sizeText));
			CLabelTextBox* cltbPtr = (CLabelTextBox *) pal->get_Item(indexTextBox);
			Controls->Add(cltbPtr->GetLabel());
			Controls->Add(cltbPtr->GetTextBox());
		}


		//configure les 2 proprits : AcceptButton contient la rf du bouton par dfaut du formulaire..
		//..on peut cliquer sur le bouton OK ou bien sur la touche Entre du clavier..
		//..referme aussi la boite car DialogResult renvoie OK
        AcceptButton = OKBtn;
		//CancelButton contient la rf du bouton associe  la touche Echap du clavier
  //      CancelButton = CancelBtn;

		//gestionnnaire associ aux boutons
		OKBtn->Click += new EventHandler(this, &MaDialogUser::OKMaDBtn_Clicked);
		EcritureBtn->Click += new EventHandler(this, &MaDialogUser::EcritureBtn_Clicked);

		Setup_Group();
	}

void MaDialogUser::EcritureBtn_Clicked(Object* pSender,EventArgs* pArgs)//gestionnaire d'evenement de la boite dialogue
	{
		//cre la boite de dialogue utilisateur
		CDialogConfig* box = new CDialogConfig();
		//affiche la boite de dialogue
		if (box->ShowDialog() == DialogResult::OK)
		{
			//si la valeur OK est renvoye, on affiche le nom
			//MessageBox::Show(S"Ecriture");
		}
	}

void MaDialogUser::OKMaDBtn_Clicked(Object* pSender,EventArgs* pArgs)//gestionnaire d'evenement de la boite dialogue
	{
		//arrete le lecture si active et fermer le formulaire lorsqu'on clique sur le bouton
		if ((uThread!=NULL)&&(uThread->IsAlive))
		{
			// Stop the thread.  
			uThread->Suspend();
			uThread=NULL;
		}
		Close();
	}

float MaDialogUser::PermutToReversed(uint16_t* tab_rp_registers,int index)//permute float32 en float32 Reverse
	{
			uint16_t wordPermuted[2];

			*(wordPermuted+0)= tab_rp_registers[index+1];
			*(wordPermuted+1)= tab_rp_registers[index+0];
			return (modbus_get_float(wordPermuted+0));//float32 Reverse
	}

void MaDialogUser::ThreadProc()//gestionnaire d'evenement du thread de la boite dialogue
	{
		uint8_t tab_rp_bits[MODBUS_SIZE_READ_COILS];
		uint16_t tab_rp_registers_low[MODBUS_SIZE_READ_HOLDINGS_LOW];
		uint16_t tab_rp_registers_high[MODBUS_SIZE_READ_HOLDINGS_HIGH];
		int rc, adress, size;
		CLabelTextBox* cltbPtr;

		for (;;)
		{
			Thread::Sleep(500);
			Console::WriteLine(S"ThreadProc: read coils...");
			adress=MODBUS_BASEADR_COILS;//adresse coils=MODBUS_BASEADR_COILS
			size=MODBUS_SIZE_READ_COILS;
			rc = modbus_read_bits(ctx, adress, size, tab_rp_bits);////JCM : adresse coils=MODBUS_BASEADR_COILS
			if (rc != size)
				Console::WriteLine(S"ThreadProc: read coils failed...");

			Thread::Sleep(500);
			Console::WriteLine(S"ThreadProc: read holdings...");
			adress=MODBUS_BASEADR_LOW_HOLDINGS;//adresse holding=MODBUS_BASEADR_LOW_HOLDINGS
			size=82;
			rc = modbus_read_registers(ctx, adress, size, tab_rp_registers_low);
			if (rc != size)
				Console::WriteLine(S"ThreadProc: read holdings failed...");

			int indexArrayList=0;
			//dtp : ui16
			cltbPtr = (CLabelTextBox *) pal->get_Item(indexArrayList++);
			cltbPtr->SetVal(Convert::ToString(tab_rp_registers_low[4]));
			//dt : ui16
			cltbPtr = (CLabelTextBox *) pal->get_Item(indexArrayList++);
			cltbPtr->SetVal(Convert::ToString(tab_rp_registers_low[5]));	
			//dP : float32
			cltbPtr = (CLabelTextBox *) pal->get_Item(indexArrayList++);
			cltbPtr->SetVal(Convert::ToString(PermutToReversed(tab_rp_registers_low,6)));
			//dPsecu : float32
			cltbPtr = (CLabelTextBox *) pal->get_Item(indexArrayList++);
			cltbPtr->SetVal(Convert::ToString(PermutToReversed(tab_rp_registers_low,8)));

			//NBal : ui16
			cltbPtr = (CLabelTextBox *) pal->get_Item(indexArrayList++);
			cltbPtr->SetVal(Convert::ToString(tab_rp_registers_low[42]));
			cltbPtr->SetColor(2);
			//P_cde : float32
			cltbPtr = (CLabelTextBox *) pal->get_Item(indexArrayList++);
			cltbPtr->SetVal(Convert::ToString(PermutToReversed(tab_rp_registers_low,43)));
			cltbPtr->SetColor(2);
			//Pp : float32
			cltbPtr = (CLabelTextBox *) pal->get_Item(indexArrayList++);
			cltbPtr->SetVal(Convert::ToString(PermutToReversed(tab_rp_registers_low,45)));

			//Nbal_max : ui16
			cltbPtr = (CLabelTextBox *) pal->get_Item(indexArrayList++);
			cltbPtr->SetVal(Convert::ToString(tab_rp_registers_low[25]));
			//Fr : ui16
			cltbPtr = (CLabelTextBox *) pal->get_Item(indexArrayList++);
			cltbPtr->SetVal(Convert::ToString(tab_rp_registers_low[26]));
			//N_cur : ui16
			cltbPtr = (CLabelTextBox *) pal->get_Item(indexArrayList++);
			if (tab_rp_registers_low[27]==(NB_ETAPES-4))//N_cur s'arrete a 8
				cltbPtr->SetVal("Balayage...");
			else
				cltbPtr->SetVal(Convert::ToString(tab_rp_registers_low[27]));
			cltbPtr->SetColor(2);

			//SVd : ui16
			cltbPtr = (CLabelTextBox *) pal->get_Item(indexArrayList++);
			cltbPtr->SetVal(Convert::ToString(tab_rp_registers_low[0]));
			//SVfin : ui16
			cltbPtr = (CLabelTextBox *) pal->get_Item(indexArrayList++);
			cltbPtr->SetVal(Convert::ToString(tab_rp_registers_low[1]));
			//SV1 : ui16
			cltbPtr = (CLabelTextBox *) pal->get_Item(indexArrayList++);
			cltbPtr->SetVal(Convert::ToString(tab_rp_registers_low[2]));
			//SV2 : ui16
			cltbPtr = (CLabelTextBox *) pal->get_Item(indexArrayList++);
			cltbPtr->SetVal(Convert::ToString(tab_rp_registers_low[3]));

			//V_cur : ui16
			cltbPtr = (CLabelTextBox *) pal->get_Item(indexArrayList++);
			cltbPtr->SetVal(Convert::ToString(tab_rp_registers_low[37]));
			cltbPtr->SetColor(2);
			//Pic : float32
			cltbPtr = (CLabelTextBox *) pal->get_Item(indexArrayList++);
			cltbPtr->SetVal(Convert::ToString(PermutToReversed(tab_rp_registers_low,38)));
			//Timer : uint32
			cltbPtr = (CLabelTextBox *) pal->get_Item(indexArrayList++);
			cltbPtr->SetVal(Convert::ToString((tab_rp_registers_low[40]<<16)+(tab_rp_registers_low[41])));
			cltbPtr->SetColor(2);

			//SVil : ui16
			cltbPtr = (CLabelTextBox *) pal->get_Item(indexArrayList++);
			cltbPtr->SetVal(Convert::ToString(tab_rp_registers_low[20]));
			//Sleil : float32
			cltbPtr = (CLabelTextBox *) pal->get_Item(indexArrayList++);
			cltbPtr->SetVal(Convert::ToString(PermutToReversed(tab_rp_registers_low,21)));
			//STc : float32
			cltbPtr = (CLabelTextBox *) pal->get_Item(indexArrayList++);
			cltbPtr->SetVal(Convert::ToString(PermutToReversed(tab_rp_registers_low,23)));

			//Eil : bool
			cltbPtr = (CLabelTextBox *) pal->get_Item(indexArrayList++);
			cltbPtr->SetVal(Convert::ToString(tab_rp_bits[0]));
			if(tab_rp_bits[0])//echec changer couleur
				cltbPtr->SetColor(1);
			else
				cltbPtr->SetColor(2);
			//Nil : ui16
			cltbPtr = (CLabelTextBox *) pal->get_Item(indexArrayList++);
			cltbPtr->SetVal(Convert::ToString(tab_rp_registers_low[30]));
			if(tab_rp_registers_low[30])//echec changer couleur
				cltbPtr->SetColor(1);
			else
				cltbPtr->SetColor(2);
			//Nil_stat : ui16
			cltbPtr = (CLabelTextBox *) pal->get_Item(indexArrayList++);
			cltbPtr->SetVal(Convert::ToString(tab_rp_registers_low[31]));
			cltbPtr->SetColor(2);
			//P_last : float32
			cltbPtr = (CLabelTextBox *) pal->get_Item(indexArrayList++);
			cltbPtr->SetVal(Convert::ToString(PermutToReversed(tab_rp_registers_low,32)));
			cltbPtr->SetColor(2);
			//N_last : ui16
			cltbPtr = (CLabelTextBox *) pal->get_Item(indexArrayList++);
			cltbPtr->SetVal(Convert::ToString(tab_rp_registers_low[34]));
			cltbPtr->SetColor(2);
			//DPil : float32
			cltbPtr = (CLabelTextBox *) pal->get_Item(indexArrayList++);
			cltbPtr->SetVal(Convert::ToString(PermutToReversed(tab_rp_registers_low,35)));

			//Num_C : tab ui16
			for (int indexMbArray=50;(indexArrayList<34 && indexMbArray<58);indexMbArray++)
			{
				cltbPtr = (CLabelTextBox *) pal->get_Item(indexArrayList++);
				cltbPtr->SetVal(Convert::ToString(tab_rp_registers_low[indexMbArray]));
				cltbPtr->SetColor(2);
			}

			//Stat_C : tab bool
			for (int indexMbArray=1;(indexArrayList<46 && indexMbArray<13);indexMbArray++)
			{
				cltbPtr = (CLabelTextBox *) pal->get_Item(indexArrayList++);
				cltbPtr->SetVal(Convert::ToString(tab_rp_bits[indexMbArray]));
/*				if(!tab_rp_bits[indexMbArray])//echec changer couleur
					cltbPtr->SetColor(1);
				else
					cltbPtr->SetColor(0);
*/			}

			//Temp_cond : tab ui16
			for (int indexMbArray=58;(indexArrayList<58 && indexMbArray<71);indexMbArray++)
			{
				cltbPtr = (CLabelTextBox *) pal->get_Item(indexArrayList++);
				cltbPtr->SetVal(Convert::ToString(tab_rp_registers_low[indexMbArray]));
				cltbPtr->SetColor(2);
			}

			//status : ui16
			cltbPtr = (CLabelTextBox *) pal->get_Item(indexArrayList++);
			cltbPtr->SetColor(2);
			if (tab_rp_registers_low[49] != 4)//on n'est pas ds le mode pulsing
			{
				cltbPtr->SetVal("ARRET");
				btnStart->Enabled=false;//bouton start
				btnStop->Enabled=false;//bouton stop
				btnPause->Enabled=false;//bouton pause
				btnReprise->Enabled=false;//bouton reprise
			}
			else
			{//mode pulsing
/*
				switch (tab_rp_registers_low[28]){//RetMAPR
					case 0://conditionnement arret
						cltbPtr->SetVal("ARRET");
						btnStart->Enabled=true;//bouton start
						btnStop->Enabled=false;//bouton stop
						btnPause->Enabled=false;//bouton pause
						btnReprise->Enabled=false;//bouton reprise
					break;
					case 2: case 3://conditionnement dmarr ou repris
						cltbPtr->SetVal("MARCHE");
						btnStart->Enabled=false;//bouton start
						btnStop->Enabled=true;//bouton stop
						btnPause->Enabled=true;//bouton pause
						btnReprise->Enabled=false;//bouton reprise
					break;
					case 1://conditionnement en pause
						cltbPtr->SetVal("PAUSE");
						btnStart->Enabled=false;//bouton start
						btnStop->Enabled=true;//bouton stop
						btnPause->Enabled=false;//bouton pause
						btnReprise->Enabled=true;//bouton reprise
					break;
				}
			if (tab_rp_registers_low[28] != tab_rp_registers_low[48])//message affich
			{
				String* stra[] = {S"RetMAPR=",Convert::ToString(tab_rp_registers_low[28]),
					S" not equal to MAPR=",Convert::ToString(tab_rp_registers_low[48])};
				String* str=String::Concat(stra);
				Console::WriteLine(str);
			}
*/
				if ((tab_rp_registers_low[28] == 1)|| tab_rp_registers_low[29])
				{//RetMAR conditionnement arret ou defaut
					cltbPtr->SetVal("ARRET");
					btnStart->Enabled=false;//bouton start
					btnStop->Enabled=true;//bouton stop
					btnReprise->Enabled=false;//bouton reprise
				}
				switch (tab_rp_registers_low[28]){//RetMAR
					case 0://conditionnement arret
						cltbPtr->SetVal("ARRET");
						btnStart->Enabled=true;//bouton start
						btnStop->Enabled=false;//bouton stop
						btnReprise->Enabled=true;//bouton reprise
					break;
					case 2: case 3://conditionnement dmarr ou repris
						cltbPtr->SetVal("MARCHE");
						btnStart->Enabled=false;//bouton start
						btnStop->Enabled=true;//bouton stop
						btnReprise->Enabled=false;//bouton reprise
					break;
				}
				if (tab_rp_registers_low[28] != tab_rp_registers_low[48])//message affich
				{
					String* stra[] = {S"RetMAPR=",Convert::ToString(tab_rp_registers_low[28]),
						S" not equal to MAPR=",Convert::ToString(tab_rp_registers_low[48])};
					String* str=String::Concat(stra);
					Console::WriteLine(str);
				}
			}//fin mode pulsing

			//N_Seqcond : ui16
			cltbPtr = (CLabelTextBox *) pal->get_Item(indexArrayList++);
			cltbPtr->SetVal(Convert::ToString(tab_rp_registers_low[47]));
			cltbPtr->SetColor(2);

			Thread::Sleep(500);
			Console::WriteLine(S"ThreadProc: read holdings...");
			adress=MODBUS_BASEADR_HIGH_HOLDINGS;//adresse holding=MODBUS_BASEADR_HIGH_HOLDINGS
			size=MODBUS_SIZE_READ_HOLDINGS_HIGH;
			rc = modbus_read_registers(ctx, adress, size, tab_rp_registers_high);
			if (rc != size)
				Console::WriteLine(S"ThreadProc: read holdings failed...");

			//DateD HeureD : tab ui16
			String* str;
			String* strDD[] = {
				Convert::ToString(tab_rp_registers_high[84]),
				"-",
				Convert::ToString(tab_rp_registers_high[85]),
				"-",
				Convert::ToString(tab_rp_registers_high[86])};
			str=String::Concat(strDD);
			cltbPtr = (CLabelTextBox *) pal->get_Item(indexArrayList++);
			cltbPtr->SetVal(str);
			cltbPtr->SetColor(2);
			String* strHD[] = {
				Convert::ToString(tab_rp_registers_high[87]),
				":",
				Convert::ToString(tab_rp_registers_high[88]),
				":",
				Convert::ToString(tab_rp_registers_high[89])};
			str=String::Concat(strHD);
			cltbPtr = (CLabelTextBox *) pal->get_Item(indexArrayList++);
			cltbPtr->SetVal(str);
			cltbPtr->SetColor(2);

			//DateF HeureF : tab ui16
			String* strDF[] = {
				Convert::ToString(tab_rp_registers_high[90]),
				"-",
				Convert::ToString(tab_rp_registers_high[91]),
				"-",
				Convert::ToString(tab_rp_registers_high[92])};
			str=String::Concat(strDF);
			cltbPtr = (CLabelTextBox *) pal->get_Item(indexArrayList++);
			cltbPtr->SetVal(str);
			cltbPtr->SetColor(2);
			String* strHF[] = {
				Convert::ToString(tab_rp_registers_high[93]),
				":",
				Convert::ToString(tab_rp_registers_high[94]),
				":",
				Convert::ToString(tab_rp_registers_high[95])};
			str=String::Concat(strHF);
			cltbPtr = (CLabelTextBox *) pal->get_Item(indexArrayList++);
			cltbPtr->SetVal(str);
			cltbPtr->SetColor(2);

			//Vides : tab ui16
			for (int indexMbArray=98;indexMbArray<110;indexMbArray++)
			{
				cltbPtr = (CLabelTextBox *) pal->get_Item(indexArrayList++);
				cltbPtr->SetVal(Convert::ToString(tab_rp_registers_high[indexMbArray]));
				cltbPtr->SetColor(2);
			}

			//Prc : tab float32
			for (int indexMbArray=68;indexMbArray<76;indexMbArray+=2)
			{
				cltbPtr = (CLabelTextBox *) pal->get_Item(indexArrayList++);
				cltbPtr->SetVal(Convert::ToString(PermutToReversed(tab_rp_registers_high,indexMbArray)));
				cltbPtr->SetColor(2);
			}

			//Pic : tab float32
			for (int indexMbArray=60;indexMbArray<68;indexMbArray+=2)
			{
				cltbPtr = (CLabelTextBox *) pal->get_Item(indexArrayList++);
				cltbPtr->SetVal(Convert::ToString(PermutToReversed(tab_rp_registers_high,indexMbArray)));
				cltbPtr->SetColor(2);
			}

			//Pch : tab float32
			for (int indexMbArray=76;indexMbArray<84;indexMbArray+=2)
			{
				cltbPtr = (CLabelTextBox *) pal->get_Item(indexArrayList++);
				cltbPtr->SetVal(Convert::ToString(PermutToReversed(tab_rp_registers_high,indexMbArray)));
				cltbPtr->SetColor(2);
			}

			//Ie_cur : tab float32
			for (int indexMbArray=10;indexMbArray<18;indexMbArray+=2)
			{
				cltbPtr = (CLabelTextBox *) pal->get_Item(indexArrayList++);
				cltbPtr->SetVal(Convert::ToString(PermutToReversed(tab_rp_registers_low,indexMbArray)));
				cltbPtr->SetColor(2);
			}

			//Num_P : tab ui16
			for (int indexMbArray=70;indexMbArray<74;indexMbArray++)
			{
				cltbPtr = (CLabelTextBox *) pal->get_Item(indexArrayList++);
				cltbPtr->SetVal(Convert::ToString(tab_rp_registers_low[indexMbArray]));
				cltbPtr->SetColor(2);
			}

			//Mode : ui16
			cltbPtr = (CLabelTextBox *) pal->get_Item(indexArrayList++);
			switch (tab_rp_registers_low[49]){
				case 0://station en mode init
					cltbPtr->SetVal("INIT");
					break;
				case 1://station en mode off
					cltbPtr->SetVal("OFF");
					break;
				case 2://station en mode heater
					cltbPtr->SetVal("HEATER");
					break;
				case 3://station en mode standby
					cltbPtr->SetVal("STANDBY");
					break;
				case 4://station en mode pulsing=conditionnement
					cltbPtr->SetVal("PULSING");
					break;
				case 5://station en mode off
					cltbPtr->SetVal("STOP");
					break;
			}

			//Ln : tab ui16
			for (int indexMbArray=0;indexMbArray<8;indexMbArray++)
			{
				cltbPtr = (CLabelTextBox *) pal->get_Item(indexArrayList++);
				cltbPtr->SetVal(Convert::ToString(tab_rp_registers_high[indexMbArray]));
			}

			//Tp_max : tab ui16
			for (int indexMbArray=24;indexMbArray<31;indexMbArray++)
			{
				cltbPtr = (CLabelTextBox *) pal->get_Item(indexArrayList++);
				cltbPtr->SetVal(Convert::ToString(tab_rp_registers_high[indexMbArray]));
			}

			//Pi_max : tab float32
			for (int indexMbArray=36;indexMbArray<52;indexMbArray+=2)
			{
				cltbPtr = (CLabelTextBox *) pal->get_Item(indexArrayList++);
				cltbPtr->SetVal(Convert::ToString(PermutToReversed(tab_rp_registers_high,indexMbArray)));
			}

			//Erreur : ui16
			cltbPtr = (CLabelTextBox *) pal->get_Item(indexArrayList++);
			switch (tab_rp_registers_low[29]){//Erreur
					case 1:
						cltbPtr->SetVal("IL_HARD");
						cltbPtr->SetColor(1);
					break;
					case 2:
						cltbPtr->SetVal("Timer_m_ko");
						cltbPtr->SetColor(1);
					break;
					case 3:
						cltbPtr->SetVal("Nil_sup_max");
						cltbPtr->SetColor(1);
					break;
					case 4:
						cltbPtr->SetVal("Pcde_sup_max");
						cltbPtr->SetColor(1);
					break;
					case 5:
						cltbPtr->SetVal("Def_Vcur_Sweep");
						cltbPtr->SetColor(1);
					break;
					case 6:
						cltbPtr->SetVal("Vcur_sup_SVfin");
						cltbPtr->SetColor(1);
					break;
					case 7:
						cltbPtr->SetVal("Pref_Coupleur");
						cltbPtr->SetColor(1);
					break;
					case 8:
						cltbPtr->SetVal("Temp_Coupleur");
						cltbPtr->SetColor(1);
					break;
					case 9:
						cltbPtr->SetVal("Arc Coupleur A1");
						cltbPtr->SetColor(1);
					break;
					case 10:
						cltbPtr->SetVal("Arc Coupleur A2");
						cltbPtr->SetColor(1);
					break;
					case 11:
						cltbPtr->SetVal("Arc Coupleur B1");
						cltbPtr->SetColor(1);
					break;
					case 12:
						cltbPtr->SetVal("Arc Coupleur B2");
						cltbPtr->SetColor(1);
					break;
					case 13:
						cltbPtr->SetVal("Arc Coupleur C1");
						cltbPtr->SetColor(1);
					break;
					case 14:
						cltbPtr->SetVal("Arc Coupleur C2");
						cltbPtr->SetColor(1);
					break;
					case 15:
						cltbPtr->SetVal("Arc Coupleur D1");
						cltbPtr->SetColor(1);
					break;
					case 16:
						cltbPtr->SetVal("Arc Coupleur D2");
						cltbPtr->SetColor(1);
					break;
					case 17:
						cltbPtr->SetVal("Arc Klystron");
						cltbPtr->SetColor(1);
					break;
					default:
						cltbPtr->SetVal("pas d'erreur");
						cltbPtr->SetColor(0);
					break;
				}
		}
 	}

void MaDialogUser::Setup_Group ()//creation et configuration d'un groupe d'options
    {
        // Creation
        gbox = new GroupBox();
        gbox->Text = S"lecture";
		gbox->Size = System::Drawing::Size(200, 150);//taille du groupbox en pixels
        gbox->Location = Point(200, 90);

        // Creation des boutons radio.
        rb1 = new RadioButton();
        rb1->Text = S"oui";
        rb1->Location = Point(10,25);

        rb2 = new RadioButton();
        rb2->Text = S"non";
        rb2->Location = Point(10,55);

		// ajout des controles dans le groupe 
        gbox->Controls->Add(rb1);
        gbox->Controls->Add(rb2);

        // ajout du groupe dans le formulaire.
        Controls->Add(gbox);

        // associe le gestionnaire au groupe d'options
        rb1->Click += new EventHandler(this, &MaDialogUser::Radio_Clicked);
        rb2->Click += new EventHandler(this, &MaDialogUser::Radio_Clicked);
    }

void MaDialogUser::Setup_Group_Conditionning()//creation et configuration d'un groupe d'options
    {
        // Creation
        GroupBox* gboxC = new GroupBox();
        gboxC->Text = S"CONDITIONNEMENT";
//		gboxC->Size = System::Drawing::Size(800, 450);//taille du groupbox en pixels
 		gboxC->Size = System::Drawing::Size(810, 450);//taille du groupbox en pixels
 //     gboxC->Location = Point(40,300);
		gboxC->Location = Point(30,300);

		Setup_Buttons_Conditionning();//configure les boutons du formulaire

		// Num_C label tt seul
		Label* num_C= new Label();
		num_C->Location = Point(50, 390);
		num_C->Size = System::Drawing::Size(50,16);
		num_C->Text = "Num_C";//zone de texte initialise 
		num_C->TextAlign = ContentAlignment::MiddleRight;
		Controls->Add(num_C);
		int j=60;//depart affichage
/*		for (int i=0;i<NB_COUPLEURS;indexTextBox++,i++,j+=80)//creation des controles dans le formulaire
		{
			int posX=70;
			pal->Add(new CLabelTextBox(nameLab_2[i],posX+j,390,25,16,50));
			CLabelTextBox* cltbPtr = (CLabelTextBox *) pal->get_Item(indexTextBox);
			Controls->Add(cltbPtr->GetLabel());
			Controls->Add(cltbPtr->GetTextBox());
		}
*/
		int posX;
		for (int i=0;i<NB_COUPLEURS;indexTextBox++,i++)//creation des controles dans le formulaire
		{
			switch (i)
			{
				case 0:posX=120;break;
				case 1:posX=190;break;
				case 2:posX=300;break;
				case 3:posX=370;break;
				case 4:posX=480;break;
				case 5:posX=550;break;
				case 6:posX=660;break;
				case 7:posX=730;break;
			}
			Console::WriteLine(posX);
			pal->Add(new CLabelTextBox(nameLab_2[i],posX,390,25,16,50));
			CLabelTextBox* cltbPtr = (CLabelTextBox *) pal->get_Item(indexTextBox);
			Controls->Add(cltbPtr->GetLabel());
			Controls->Add(cltbPtr->GetTextBox());
		}

		// Stat_C label tt seul
		Label* stat_C= new Label();
		stat_C->Location = Point(50, 630);
		stat_C->Size = System::Drawing::Size(50,16);
		stat_C->Text = "Stat_C";//zone de texte initialise 
		stat_C->TextAlign = ContentAlignment::MiddleRight;
//4-07-13		Controls->Add(stat_C);
		j=20;//depart affichage
//		for (int i=0;indexTextBox<46;indexTextBox++,i++,j+=60)//creation des controles dans le formulaire
		for (int i=0;i<NB_ETAPES;indexTextBox++,i++,j+=60)//creation des controles dans le formulaire
		{
			int posX=100;
			pal->Add(new CLabelTextBox(Convert::ToString(i+1),posX+j,630,25,16,20));
			CLabelTextBox* cltbPtr = (CLabelTextBox *) pal->get_Item(indexTextBox);
//4-07-13			Controls->Add(cltbPtr->GetLabel());
//4-07-13			Controls->Add(cltbPtr->GetTextBox());
		}

		// Temp_cond label tt seul
		Label* temp_cond= new Label();
		temp_cond->Location = Point(50, 665);
		temp_cond->Size = System::Drawing::Size(65,32);
		temp_cond->Text = "Temp_cond       (min)";//zone de texte initialise 
		temp_cond->TextAlign = ContentAlignment::MiddleRight;
		Controls->Add(temp_cond);
		j=20;//depart affichage
		for (int i=0;i<NB_ETAPES;indexTextBox++,i++,j+=60)//creation des controles dans le formulaire
		{
			int posX=90;
			pal->Add(new CLabelTextBox(Convert::ToString(i+1),posX+j,670,25,16,40));
			CLabelTextBox* cltbPtr = (CLabelTextBox *) pal->get_Item(indexTextBox);
			if (i<8)//7 etapes et 1 balayage
			{
				Controls->Add(cltbPtr->GetLabel());
				Controls->Add(cltbPtr->GetTextBox());
			}
		}

		// status, N_Seqcond, DateD et heureD , DateF et HeureF labels tt seul
		Label* status= new Label();
		status->Location = Point(370, 700);
		status->Size = System::Drawing::Size(65,16);
		status->Text = "status";//zone de texte initialise 
		status->TextAlign = ContentAlignment::MiddleRight;
		Controls->Add(status);
		Label* n_seqcond= new Label();
		n_seqcond->Location = Point(450, 700);
		n_seqcond->Size = System::Drawing::Size(65,16);
		n_seqcond->Text = "N_Seqcond";//zone de texte initialise 
		n_seqcond->TextAlign = ContentAlignment::MiddleRight;
		Controls->Add(n_seqcond);
		Label* dateD= new Label();
		dateD->Location = Point(510, 700);
		dateD->Size = System::Drawing::Size(65,16);
		dateD->Text = "DateD";//zone de texte initialise 
		dateD->TextAlign = ContentAlignment::MiddleRight;
		Controls->Add(dateD);
		Label* heureD= new Label();
		heureD->Location = Point(580, 700);
		heureD->Size = System::Drawing::Size(65,16);
		heureD->Text = "HeureD";//zone de texte initialise 
		heureD->TextAlign = ContentAlignment::MiddleRight;
		Controls->Add(heureD);
		Label* dateF= new Label();
		dateF->Location = Point(650, 700);
		dateF->Size = System::Drawing::Size(65,16);
		dateF->Text = "DateF";//zone de texte initialise 
		dateF->TextAlign = ContentAlignment::MiddleRight;
		Controls->Add(dateF);
		Label* heureF= new Label();
		heureF->Location = Point(720, 700);
		heureF->Size = System::Drawing::Size(65,16);
		heureF->Text = "HeureF";//zone de texte initialise 
		heureF->TextAlign = ContentAlignment::MiddleRight;
		Controls->Add(heureF);
		j=330;//depart affichage
//		for (int i=0;indexTextBox<62;indexTextBox++,i++,j+=100)//creation des controles dans le formulaire
		for (int i=0;i<6;indexTextBox++,i++,j+=70)//creation des controles dans le formulaire
		{
			int posX=0;
			pal->Add(new CLabelTextBox("",posX+j,720,55,16,70));
			CLabelTextBox* cltbPtr = (CLabelTextBox *) pal->get_Item(indexTextBox);
			Controls->Add(cltbPtr->GetTextBox());
		}

		// Vides label tt seul
		Label* vides = new Label();
//		vides->Location = Point(50, 590);
		vides->Location = Point(35, 590);
//		vides->Size = System::Drawing::Size(60,32);
		vides->Size = System::Drawing::Size(70,40);
		vides->Text = "   Vides       (10-10mbar)";//zone de texte initialise 
		vides->TextAlign = ContentAlignment::MiddleRight;
		Controls->Add(vides);
		j=40;//depart affichage
		for (int i=0;i<(NB_BANCS*3);indexTextBox++,i++,j+=60)//creation des controles dans le formulaire
		{
			int posX=70;
			pal->Add(new CLabelTextBox(nameLab_4[i],posX+j,590,10,16,50));
			CLabelTextBox* cltbPtr = (CLabelTextBox *) pal->get_Item(indexTextBox);
			Controls->Add(cltbPtr->GetLabel());
			Controls->Add(cltbPtr->GetTextBox());
		}

		// Prc label tt seul
		Label* prc = new Label();
		prc->Location = Point(50, 430);
		prc->Size = System::Drawing::Size(50,32);
		prc->Text = "Prc   (kW)";//zone de texte initialise 
		prc->TextAlign = ContentAlignment::MiddleRight;
		Controls->Add(prc);
		j=100;//depart affichage
		for (int i=0;i<NB_BANCS;indexTextBox++,i++,j+=180)//creation des controles dans le formulaire
		{
			int posX=70;
			pal->Add(new CLabelTextBox(nameLab_3[i],posX+j,430,10,16,50));
			CLabelTextBox* cltbPtr = (CLabelTextBox *) pal->get_Item(indexTextBox);
			Controls->Add(cltbPtr->GetLabel());
			Controls->Add(cltbPtr->GetTextBox());
		}

		// Pic label tt seul
		Label* pic = new Label();
		pic->Location = Point(50, 470);
		pic->Size = System::Drawing::Size(50,32);
		pic->Text = "Pic   (kW)";//zone de texte initialise 
		pic->TextAlign = ContentAlignment::MiddleRight;
		Controls->Add(pic);
		j=100;//depart affichage
		for (int i=0;i<NB_BANCS;indexTextBox++,i++,j+=180)//creation des controles dans le formulaire
		{
			int posX=70;
			pal->Add(new CLabelTextBox(nameLab_3[i],posX+j,470,10,16,50));
			CLabelTextBox* cltbPtr = (CLabelTextBox *) pal->get_Item(indexTextBox);
			Controls->Add(cltbPtr->GetLabel());
			Controls->Add(cltbPtr->GetTextBox());
		}

		// Pch label tt seul
		Label* pch = new Label();
		pch->Location = Point(50, 510);
		pch->Size = System::Drawing::Size(50,32);
		pch->Text = "Pch   (kW)";//zone de texte initialise 
		pch->TextAlign = ContentAlignment::MiddleRight;
		Controls->Add(pch);
		j=100;//depart affichage
		for (int i=0;i<NB_BANCS;indexTextBox++,i++,j+=180)//creation des controles dans le formulaire
		{
			int posX=70;
			pal->Add(new CLabelTextBox(nameLab_3[i],posX+j,510,10,16,50));
			CLabelTextBox* cltbPtr = (CLabelTextBox *) pal->get_Item(indexTextBox);
			Controls->Add(cltbPtr->GetLabel());
			Controls->Add(cltbPtr->GetTextBox());
		}

		// Ie_cur label tt seul
		Label* ie_cur = new Label();
		ie_cur->Location = Point(50, 550);
		ie_cur->Size = System::Drawing::Size(50,32);
		ie_cur->Text = "Ie_cur   (V)";//zone de texte initialise 
		ie_cur->TextAlign = ContentAlignment::MiddleRight;
		Controls->Add(ie_cur);
		j=100;//depart affichage
		for (int i=0;i<NB_BANCS;indexTextBox++,i++,j+=180)//creation des controles dans le formulaire
		{
			int posX=70;
			pal->Add(new CLabelTextBox(nameLab_3[i],posX+j,550,10,16,50));
			CLabelTextBox* cltbPtr = (CLabelTextBox *) pal->get_Item(indexTextBox);
			Controls->Add(cltbPtr->GetLabel());
			Controls->Add(cltbPtr->GetTextBox());
		}

		// Num_P label tt seul
		Label* num_P = new Label();
		num_P->Location = Point(50, 350);
		num_P->Size = System::Drawing::Size(50,32);
		num_P->Text = "Num_P";//zone de texte initialise 
		num_P->TextAlign = ContentAlignment::MiddleRight;
		Controls->Add(num_P);
		j=100;//depart affichage
		for (int i=0;i<NB_BANCS;indexTextBox++,i++,j+=180)//creation des controles dans le formulaire
		{
			int posX=70;
			pal->Add(new CLabelTextBox(nameLab_3[i],posX+j,350,10,16,50));
			CLabelTextBox* cltbPtr = (CLabelTextBox *) pal->get_Item(indexTextBox);
			Controls->Add(cltbPtr->GetLabel());
			Controls->Add(cltbPtr->GetTextBox());
		}
/*
		// cre un objet graphique
		Graphics* pg = this->CreateGraphics();
		//cre un objet pen
		Pen* pen1 = new Pen(Color::Red);
		//trace une ligne
		pg->DrawLine(pen1,20,20,100,100);
		//dispose l'objet Graphics
		pg->Dispose();
*/
        // ajout du groupe dans le formulaire.
        Controls->Add(gboxC);

/*
        // associe le gestionnaire au groupe d'options
        rb1->Click += new EventHandler(this, &MaDialogUser::Radio_Clicked);
        rb2->Click += new EventHandler(this, &MaDialogUser::Radio_Clicked);
  */  }

void MaDialogUser::Setup_Buttons_Conditionning()//creation et definition des boutons
    {
        // ajoute bouton START
        btnStart = new Button();
        btnStart->Text = S"MARCHE";//se sert de sa proprit Text pour definir son titre
        btnStart->Size = System::Drawing::Size(70, 20);//taille du bouton en pixels
		btnStart->Location = Point(70, 720);//emplacement
        btnStart->Click += new EventHandler(this, &MaDialogUser::BtnStart_Clicked);//creation d'un objet EventHandler en..
		                  //..lui transmettant un ptr sur le bouotn et l'adresse de la fonction en charge de..
		                  //..l'evenement
        Controls->Add(btnStart);//pour avertir le formulaire de la prsence du bouton, on ajoute le bouton..
		                    //.. dans la collection des controles du formulaire

        // idem bouton STOP
        btnStop = new Button();
        btnStop->Text = S"ARRET";
        btnStop->Size = System::Drawing::Size(70, 20);
        btnStop->Location = Point(150, 720);
        btnStop->Click += new EventHandler(this, &MaDialogUser::BtnStop_Clicked);
        Controls->Add(btnStop);

       // idem bouton PAUSE
        btnPause = new Button();
        btnPause->Text = S"PAUSE";
        btnPause->Size = System::Drawing::Size(70, 20);
        btnPause->Location = Point(230, 720);
//        btnPause->Click += new EventHandler(this, &MaDialogUser::BtnPause_Clicked);
//        Controls->Add(btnPause);

       // idem bouton REPRISE
        btnReprise = new Button();
        btnReprise->Text = S"REPRISE";
        btnReprise->Size = System::Drawing::Size(70, 20);
        btnReprise->Location = Point(310, 720);
        btnReprise->Click += new EventHandler(this, &MaDialogUser::BtnReprise_Clicked);
        Controls->Add(btnReprise);
    }

void MaDialogUser::Radio_Clicked(Object* pSender, EventArgs* pArgs)//remplit automatiquement la zone de texte
    {
        if (pSender == rb1)
		{
			Console::WriteLine(S"MaDialogUser::Radio_Clicked : lecture active...");			
			Console::WriteLine(S"Main thread: Start a second thread.");
			// Create the thread, passing a ThreadStart delegate that
			// represents the ThreadReadModbus::ThreadProc method.
			if (uThread==NULL)
			{
				uThread = new Thread(new ThreadStart(0, &MaDialogUser::ThreadProc));
				// Start the thread.  
				uThread->Start();
			}
		}
        else if (pSender == rb2)
		{
			Console::WriteLine(S"MaDialogUser::Radio_Clicked : lecture dsactive...");
			if ((uThread!=NULL)&&(uThread->IsAlive))
			{
				// Stop the thread.  
				uThread->Suspend();
				uThread=NULL;
			}
		}	
	}

void MaDialogUser::BtnStart_Clicked(Object* pSender, EventArgs* pArgs)//gestionnaire d'evenements associs au bouton 1
    {
		//	MessageBox::Show(S"a marche!", S"bouton START...");//MessageBox fait partie de l'espace de noms Forms
		//unique methode Show surcharge acceptant differents parametres
		CLabelTextBox* cltbPtr;
		for (int indexArrayList=0;(indexArrayList<MAX_NB_LABEL_TEXTBOX);indexArrayList++)//on cherche le LabelBox "MODE"
		{
			cltbPtr = (CLabelTextBox *) pal->get_Item(indexArrayList);
			if(String::Compare(cltbPtr->GetName(),"MODE"))
				break;//on y est
			if(indexArrayList==(MAX_NB_LABEL_TEXTBOX-1))return;//il faut sortir si non trouv
		}
		if(String::Compare(cltbPtr->GetVal(),"PULSING"))
		{
			uint16_t tab_rp_registers[1] = { 0x2 };
			Console::WriteLine(S"MaDialogUser::BtnStart_Clicked : write holding...");
			int rc = modbus_write_registers(ctx, 2048,1 , tab_rp_registers);
			if (rc != 1)
					Console::WriteLine(S"MaDialogUser::BtnStart_Clicked : write holding failed...");		
		}
    }

void MaDialogUser::BtnStop_Clicked(Object* pSender, EventArgs* pArgs)//gestionnaire d'evenements associs au bouton 1
    {
//		MessageBox::Show(S"a marche!", S"bouton STOP...");//MessageBox fait partie de l'espace de noms Forms
		//unique methode Show surcharge acceptant differents parametres
		CLabelTextBox* cltbPtr;
		for (int indexArrayList=0;(indexArrayList<MAX_NB_LABEL_TEXTBOX);indexArrayList++)//on cherche le LabelBox "MODE"
		{
			cltbPtr = (CLabelTextBox *) pal->get_Item(indexArrayList);
			if(String::Compare(cltbPtr->GetName(),"MODE"))
				break;//on y est
			if(indexArrayList==(MAX_NB_LABEL_TEXTBOX-1))return;//il faut sortir si non trouv
		}
		if(String::Compare(cltbPtr->GetVal(),"PULSING"))
		{
			uint16_t tab_rp_registers[1] = { 0x0 };
			Console::WriteLine(S"MaDialogUser::BtnStart_Clicked : write holding...");
			int rc = modbus_write_registers(ctx, 2048,1 , tab_rp_registers);
			if (rc != 1)
					Console::WriteLine(S"MaDialogUser::BtnStart_Clicked : write holding failed...");		
		}
    }

void MaDialogUser::BtnPause_Clicked(Object* pSender, EventArgs* pArgs)//gestionnaire d'evenements associs au bouton 1
    {
//		MessageBox::Show(S"a marche!", S"bouton PAUSE...");//MessageBox fait partie de l'espace de noms Forms
		//unique methode Show surcharge acceptant differents parametres
		CLabelTextBox* cltbPtr;
		for (int indexArrayList=0;(indexArrayList<MAX_NB_LABEL_TEXTBOX);indexArrayList++)//on cherche le LabelBox "MODE"
		{
			cltbPtr = (CLabelTextBox *) pal->get_Item(indexArrayList);
			if(String::Compare(cltbPtr->GetName(),"MODE"))
				break;//on y est
			if(indexArrayList==(MAX_NB_LABEL_TEXTBOX-1))return;//il faut sortir si non trouv
		}
		if(String::Compare(cltbPtr->GetVal(),"PULSING"))
		{
			uint16_t tab_rp_registers[1] = { 0x1 };
			Console::WriteLine(S"MaDialogUser::BtnStart_Clicked : write holding...");
			int rc = modbus_write_registers(ctx, 2048,1 , tab_rp_registers);
			if (rc != 1)
					Console::WriteLine(S"MaDialogUser::BtnStart_Clicked : write holding failed...");		
		}
    }

void MaDialogUser::BtnReprise_Clicked(Object* pSender, EventArgs* pArgs)//gestionnaire d'evenements associs au bouton 1
    {
//		MessageBox::Show(S"a marche!", S"bouton REPRISE...");//MessageBox fait partie de l'espace de noms Forms
		//unique methode Show surcharge acceptant differents parametres
		CLabelTextBox* cltbPtr;
		for (int indexArrayList=0;(indexArrayList<MAX_NB_LABEL_TEXTBOX);indexArrayList++)//on cherche le LabelBox "MODE"
		{
			cltbPtr = (CLabelTextBox *) pal->get_Item(indexArrayList);
			if(String::Compare(cltbPtr->GetName(),"MODE"))
				break;//on y est
			if(indexArrayList==(MAX_NB_LABEL_TEXTBOX-1))return;//il faut sortir si non trouv
		}
		if(String::Compare(cltbPtr->GetVal(),"PULSING"))
		{
			uint16_t tab_rp_registers[1] = { 0x3 };
			Console::WriteLine(S"MaDialogUser::BtnStart_Clicked : write holding...");
			int rc = modbus_write_registers(ctx, 2048,1 , tab_rp_registers);
			if (rc != 1)
					Console::WriteLine(S"MaDialogUser::BtnStart_Clicked : write holding failed...");		
		}
    }


void AboutBox::OKButton_Clicked(Object* pSender,EventArgs* pArgs)//gestionnaire d'evenement de la boite dialogue
{
	//se contente de fermer le formulaire lorsqu'on clique sur le bouton
	Close();
}

AboutBox::AboutBox()//constructeur
    {
        // qqs proprits
        Text = S"A propos cxfel";
        FormBorderStyle = FormBorderStyle::Fixed3D;//impossible de modifier la taille
        Size = System::Drawing::Size(300,150);
        
        // ajout de 2 labels au formulaire.
        Label* label1 = new Label();
        label1->Text = "Application client XFEL";
        label1->Size = System::Drawing::Size(label1->PreferredWidth,
                                             label1->PreferredHeight);
        label1->Location = Point(20, 30);

        Label* label2 = new Label();
        label2->Text = "JC Marrucho, 2013";
        label2->Size = System::Drawing::Size(label1->PreferredWidth,
                                             label1->PreferredHeight);//sert  modifier auto la taille des labels..
																	//..selon le texte
        label2->Location = Point(20, 30+label1->PreferredHeight+10);//sert  calculer la position du 2me label

        // Ajoute les controles dans le formulaire
        Controls->Add(label1);
        Controls->Add(label2);

        // Ajout d'un bouton OK.
        OKButton = new Button();
        OKButton->Text = S"OK";
        OKButton->DialogResult = System::Windows::Forms::DialogResult::OK;//renvoi de la valeur OK..
										//.. plus besoin d'associer le gestionnaire  sa fonction.. voir plus bas
        OKButton->Size = System::Drawing::Size(40,25);
        OKButton->Location = Point(240,85);

		//configure un gestionnaire : pas ncessaire si le formulaire renvoie une valeur.. voir + haut
		//OKButton->Click += new EventHandler(this,&AboutBox::OKButton_Clicked);

        // Ajoute le bouton au formulaire.
        Controls->Add(OKButton);
	}

	
MaDialog::MaDialog()
    {
        // dfinit les paramtres du formulaire
        Text = S"dtails serveur";
        FormBorderStyle = FormBorderStyle::Fixed3D;//impossible de modifier la taille
        Size = System::Drawing::Size(280,200);

        // Creation de tous les controles : TextBox pour io/port et ComboBox pour timeout
        ipLabel = new Label();
        ipBox = new TextBox();
        portLabel = new Label();
        portBox = new TextBox();
        timeoutLabel = new Label();
        timeoutCombo = new ComboBox();
        OKBtn = new Button();
        CancelBtn = new Button();
        
        // ipLabel et ipBox : label et zone de saisie sont placs  l'un  ct de l'autre
        ipLabel->Location = Point(16, 24);
        ipLabel->Size = System::Drawing::Size(48, 16);
        ipLabel->Text = "nIP:";//zone de texte initialise vide
        ipLabel->TextAlign = ContentAlignment::MiddleRight;
        ipBox->Location = Point(72, 24);
        ipBox->Size = System::Drawing::Size(152, 20);
        ipBox->Text = "";//zone de texte initialise vide

        // portLabel et portBox
        portLabel->Location = Point(16, 56);
        portLabel->Size = System::Drawing::Size(48, 16);
        portLabel->Text = "nport:";//zone de texte initialise vide
        portLabel->TextAlign = ContentAlignment::MiddleRight;
        portBox->Location = Point(72, 56);
        portBox->Size = System::Drawing::Size(152, 20);
        portBox->Text = "";//zone de texte initialise

        // timeoutLabel et timeoutCombo : : liste droulante spcifiant le tiemout et son label
        timeoutLabel->Location = Point(16, 88);
        timeoutLabel->Size = System::Drawing::Size(48, 16);
        timeoutLabel->Text = "Timeout(ms):";
        timeoutLabel->TextAlign = ContentAlignment::MiddleRight;
        timeoutCombo->DropDownWidth = 121;
        timeoutCombo->Location = Point(72, 88);
        timeoutCombo->Size = System::Drawing::Size(121, 21);
		//5 items, pas de valeur par dfaut
        timeoutCombo->Items->Add(S"500");
        timeoutCombo->Items->Add(S"1000");
        timeoutCombo->Items->Add(S"1500");
        timeoutCombo->Items->Add(S"2000");
        timeoutCombo->Items->Add(S"3000");

        // bouton OK
        OKBtn->Location = Point(104, 136);
		OKBtn->Name = "Bouton OK";
        OKBtn->Text = "OK";
        OKBtn->DialogResult = DialogResult::OK;

        // bouton Cancel
        CancelBtn->Location = Point(192, 136);
        CancelBtn->Name = "Bouton Annuler";
        CancelBtn->Text = "Annuler";
        CancelBtn->DialogResult = DialogResult::Cancel;

        // Ajoute les controles dans le formaulaire
        Controls->Add(ipBox);
        Controls->Add(portBox);
        Controls->Add(ipLabel);
        Controls->Add(portLabel);
        Controls->Add(timeoutLabel);
        Controls->Add(timeoutCombo);
        Controls->Add(OKBtn);
        Controls->Add(CancelBtn);

		//configure les 2 proprits : AcceptButton contient la rf du bouton par dfaut du formulaire..
		//..on peut cliquer sur le bouton OK ou bien sur la touche Entre du clavier..
		//..referme aussi la boite car DialogResult renvoie OK
        AcceptButton = OKBtn;
		//CancelButton contient la rf du bouton associe  la touche Echap du clavier
        CancelButton = CancelBtn;

		//gestionnnaire associ au bouton OK
		OKBtn->Click += new EventHandler(this, &MaDialog::OKMaDBtn_Clicked);
	}

void MaDialog::OKMaDBtn_Clicked(Object* pSender,EventArgs* pArgs)//gestionnaire d'evenement de la boite dialogue
{
	//se contente de fermer le formulaire lorsqu'on clique sur le bouton
	Close();
}

void MaDialog::setIp(String* theIp)
{
	ipBox->Text = theIp; 
}
    
String* MaDialog::getIp() 
{ 
	return ipBox->Text; 
}

void MaDialog::setPort(String* thePort)
{ 
	portBox->Text = thePort;
}

String* MaDialog::getPort()
{ 
	return portBox->Text;
}

void MaDialog::setTimeout(int theTimeout)
{ 
	timeoutCombo->SelectedIndex = theTimeout;
}

int MaDialog::getTimeout()
{ 
	return timeoutCombo->SelectedIndex;
}


CppForm::CppForm()//constructeur
    {
        // dfinit la lgende du formulaire
		//la proprit Text est hrite de Control
        Text = S"XSUC";

        // dfinit le style des bords
		//la proprit FormBorder est membre de Form
        FormBorderStyle = FormBorderStyle::Fixed3D;

        // Set up controls on the form.
        Setup_Menu();
        Setup_Context_Menu();
        Setup_Buttons();//configure les boutons du formulaire
        Setup_Label();
//        Setup_Group();
//        Setup_Combo();
        Setup_Text();

        // pour agrandir la zone de saisie, on rajoute des pixels, par defaut 300x300
 //       Size = System::Drawing::Size(450, 300);
        Size = System::Drawing::Size(650, 500);

    }

void CppForm::Btn1_Clicked(Object* pSender, EventArgs* pArgs)//gestionnaire d'evenements associs au bouton 1
    {
		MessageBox::Show(S"a marche!", S"A FAIRE...");//MessageBox fait partie de l'espace de noms Forms
		//unique methode Show surcharge acceptant differents parametres
    }

void CppForm::Btn2_Clicked(Object* pSender, EventArgs* pArgs)//gestionnaire d'evenements associs au bouton 2
    {
        MessageBox::Show(S"a marche aussi!", S"A FAIRE...");//MessageBox fait partie de l'espace de noms Forms
  		//unique methode Show surcharge acceptant differents parametres
    }

void CppForm::Btn3_Clicked(Object* pSender, EventArgs* pArgs)//gestionnaire d'evenements associs au bouton 3
    {
        MessageBox::Show(S"connexion et lecture serveur", S"A FAIRE...");//MessageBox fait partie de l'espace de noms Forms
  		//unique methode Show surcharge acceptant differents parametres
    }

void CppForm::Btn4_Clicked(Object* pSender, EventArgs* pArgs)//gestionnaire d'evenements associs au bouton 4
    {
/*		uint16_t tab_rp_registers_low[MODBUS_SIZE_READ_HOLDINGS_LOW];
		uint16_t tab_rp_registers_high[MODBUS_SIZE_READ_HOLDINGS_HIGH];
		int rc, adress, size;
		Console::WriteLine(S"ThreadProc: read holdings...");
		adress=MODBUS_BASE_LOW_HOLDINGS;//adresse holding=MODBUS_BASE_LOW_HOLDINGS
		size=82;
		rc = modbus_read_registers(ctx, adress, size, tab_rp_registers_low);
		if (rc != size)
		Console::WriteLine(S"ThreadProc: read holdings failed...");
		Thread::Sleep(500);
		Console::WriteLine(S"ThreadProc: read holdings...");
		adress=MODBUS_BASEADR_HIGH_HOLDINGS;//adresse holding=MODBUS_BASEADR_HIGH_HOLDINGS
		size=MODBUS_SIZE_READ_HOLDINGS_HIGH;
		rc = modbus_read_registers(ctx, adress, size, tab_rp_registers_high);
		if (rc != size)
			Console::WriteLine(S"ThreadProc: read holdings failed...");
*/
		//cre la boite de dialogue utilisateur
		CDialogConfig* box = new CDialogConfig();
		//affiche la boite de dialogue
		if (box->ShowDialog() == DialogResult::OK)
		{
			//si la valeur OK est renvoye, on affiche le nom
			//MessageBox::Show(S"Ecriture");
		}
  		//unique methode Show surcharge acceptant differents parametres
    }

void CppForm::Combo1_SelChanged(Object* pSender, EventArgs* pArgs)//gestionnaire d'evenement associ  la liste deroulante
    {
        if (pSender == combo1)
        {
//            String* ps = String::Concat(S"New index is ", 
//                                        __box(combo1->SelectedIndex)->ToString());
//            MessageBox::Show(ps, S"Index Change");
            String* ps = __box(combo1->SelectedIndex)->ToString();
			if(String::Compare(ps,"1")==0)
			{
				Console::WriteLine(S"Main thread: Start a second thread.");
				// Create the thread, passing a ThreadStart delegate that
				// represents the ThreadReadModbus::ThreadProc method.
				Thread *oThread = new Thread(new ThreadStart(0, &ThreadReadModbus::ThreadProc));
				// Start the thread.  
				oThread->Start();
			}
        }
    }

void CppForm::MenuItem_Clicked(Object* pSender, EventArgs* pArgs)//gestionnaire des elements de menu
    {
        if (pSender == item1)
        {
			//affiche la boite de dialogue modale qui doit etre ferme avant de pouvoir revenir  l'application
//			MessageBox::Show(S"ITEM   propos", S"Menu");
			AboutBox* box = new AboutBox();
			box->ShowDialog();
        }
        else if (pSender == item2)
        {
            // Exit application.
            Application::Exit();
        }
		else if (pSender == item11)
		{
			//cre la boite de dialogue
			MaDialog* box = new MaDialog();
			//donnes initiales
/*			String* path = new String("c:\\temp\\condip.txt.txt");
			if (!File::Exists(path))
			{
				Console::WriteLine("le fichier n'existe pas!");
			}
*/
			//lecture du nIP dans le fichier condip
			try
			{
				FileStream* fs = new FileStream("..\\condip.txt",FileMode::Open);
				StreamReader* sr = new StreamReader(fs);
				String* line = sr->ReadLine();
				box->setIp(line);
				sr->Close;
				fs->Flush();
				fs->Close();
			}
			catch (System::Exception* pe)
			{
				Console::WriteLine(pe->ToString());
			}
//			box->setIp(S"134.158.91.254");
			box->setPort(S"502");
			box->setTimeout(1);

			//affiche la boite de dialogue
			if (box->ShowDialog() == DialogResult::OK)
            {
                //si la valeur OK est renvoye, on affiche le nom
                MessageBox::Show(box->getIp(), S"IP du serveur");
            }

		}
		else if (pSender == anotherItem)
		{
			//cre la boite de dialogue utilisateur
			MaDialogUser* box = new MaDialogUser();
			//donnes initiales
	/*		box->setIp(S"134.158.91.254");
			box->setPort(S"502");
			box->setTimeout(1);
	*/		//affiche la boite de dialogue
			if (box->ShowDialog() == DialogResult::OK)
            {
                //si la valeur OK est renvoye, on affiche le nom
//                MessageBox::Show(S"Lecture");
            }
		}
		else if (pSender == item1_1 || pSender == item1_2)
		{
//			modbus_t *ctx;
			if(pSender == item1_1)
			{
//				ctx = (modbus_t *) malloc(sizeof(modbus_t));
//				Ex20cSquareRoot(4);
	//			char* ptr = GetHeure(1);
	/*			String* psone = String::Concat(S"il est ", GetHeure(1));
				MessageBox::Show(psone, S"heure");
				int* monInt = allou();
				int taille=sizeof(monInt);
				Console::WriteLine(taille);
				libere(monInt);
*/
				//lecture du nIP dans le fichier condip
				String* lineIp;
				try
				{
					FileStream* fs = new FileStream("..\\condip.txt",FileMode::Open);
					StreamReader* sr = new StreamReader(fs);
					lineIp = sr->ReadLine();
					sr->Close;
					fs->Flush();
					fs->Close();
				}
				catch (System::Exception* pe)
				{
					Console::WriteLine(pe->ToString());
				}

				Console::WriteLine(S"CppForm::MenuItem_Clicked : modbus_new_tcp...");
//				ctx = modbus_new_tcp("134.158.91.254", 502);//JCM
				char* chaineChar = static_cast<char *>(System::Runtime::InteropServices::Marshal::StringToHGlobalAnsi(lineIp).ToPointer());
				ctx = modbus_new_tcp(chaineChar,502);//JCM
				modbus_set_debug(ctx, 1);
//				modbus_set_error_recovery(ctx,
//				                   MODBUS_ERROR_RECOVERY_LINK |
//				                   MODBUS_ERROR_RECOVERY_PROTOCOL);
				modbus_set_slave(ctx,1);//JCM: avec le serveur python slave=1
				if (modbus_connect(ctx) == -1) {
					Console::WriteLine(modbus_strerror(errno));
					modbus_free(ctx);
				}
			}
			else
			{
				 modbus_free(ctx);
			}
		}
		else if (pSender == fontDlgItem)
        {
            FontDialog* fd = new FontDialog();
            fd->Font = labelFont;

            if (fd->ShowDialog() == DialogResult::OK)//la police du label est modifie selon le choix d el'uitlisateur
            {
                MessageBox::Show(fd->Font->Name, S"la police tait...");
                labelFont = fd->Font;
                theLabel->Font = labelFont;
            }
		}
        else
			MessageBox::Show(S"AUTRE ITEM", S"Menu");
    }

void CppForm::Radio_Clicked(Object* pSender, EventArgs* pArgs)//remplit automatiquement la zone de texte
    {
        if (pSender == rb1)
		{
			text1->Text = "Read Coils choisi : \r\n\r\n"
                       "FC01";
			uint8_t tab_rp_bits[1]; 
			int rc = modbus_read_bits(ctx, MODBUS_BASEADR_COILS, 1, tab_rp_bits);////JCM : adresse coils=MODBUS_BASEADR_COILS
			Console::WriteLine(S"CppForm::Radio_Clicked : read one coil...");
			if (rc != 1)
				Console::WriteLine(S"CppForm::Radio_Clicked : read one coil failed...");
		}
        else if (pSender == rb2)
		{
            text1->Text = "Write Coils choisi : \r\n\r\n"
                      "FC15";
			uint8_t tab_value[77];//JCM
			modbus_set_bits_from_bytes(tab_value, 0, 77, UT_BITS_TAB);
			printf("tab[0]=%d,tab[1]=%d,tab[2]=%d\n", tab_value[0], tab_value[1], tab_value[2]);
			int rc = modbus_write_bits(ctx, MODBUS_BASEADR_COILS,//JCM : adresse coils=MODBUS_BASEADR_COILS
				77, tab_value);
			if (rc != 77)
				Console::WriteLine(S"CppForm::Radio_Clicked : write coil failed...");
		}
		else if (pSender == rb3)
		{
            text1->Text = "Read Holdings choisi : \r\n\r\n"
                      "FC03";
			uint16_t tab_rp_registers[UT_REGISTERS_NB];
			int rc = modbus_read_registers(ctx, MODBUS_BASEADR_LOW_HOLDINGS,//JCM : adresse holding=MODBUS_BASEADR_LOW_HOLDINGS
                               UT_REGISTERS_NB, tab_rp_registers);
			Console::WriteLine(S"CppForm::Radio_Clicked : read holding...");
			if (rc != UT_REGISTERS_NB)
				Console::WriteLine(S"CppForm::Radio_Clicked : read holding failed...");
  		}
		else if (pSender == rb4)
		{
			text1->Text = "Write Holdings choisi :\r\n\r\n"
                       "FC16";
			Random* myRnd = new Random();
			float realToWrite, real = myRnd->NextDouble();
			printf("random = %f\n", real<0.5 ? realToWrite=-1000*real:realToWrite=1000*real);

			uint16_t tab_rp_registers[48];
			Console::WriteLine(S"CppForm::Radio_Clicked : write holding...");
			modbus_set_float(realToWrite, tab_rp_registers);//Pi_min
			int rc = modbus_write_registers(ctx, 2118,48 , tab_rp_registers);
			if (rc != 48)
				Console::WriteLine(S"CppForm::Radio_Clicked : write holding failed...");
		}
	}

void CppForm::Setup_Buttons()//creation et definition du bouton
    {
        // ajoute un bouton
        btn1 = new Button();
        btn1->Text = S"OK";//se sert de sa proprit Text pour definir son titre

        btn1->Size = System::Drawing::Size(70, 25);//taille du bouton en pixels
		btn1->Location = Point(230, 400);//emplacement
//		btn1->Font = new System::Drawing::Font(S"Verdana", 16, FontStyle::Bold);;//l'objet Font est sauvegard dans l'objet LabelFont grce au pointeur
//        btn1->ForeColor = Color::Brown;

        btn1->Click += new EventHandler(this, &CppForm::Btn1_Clicked);//creation d'un objet EventHandler en..
		                  //..lui transmettant un ptr sur le bouotn et l'adresse de la fonction en charge de..
		                  //..l'evenement

        Controls->Add(btn1);//pour avertir le formulaire de la prsence du bouton, on ajoute le bouton..
		                    //.. dans la collection des controles du formulaire

        // idem pour 2eme bouton
        btn2 = new Button();
        btn2->Text = S"Annuler";//..

        btn2->Size = System::Drawing::Size(70, 25);//..
        btn2->Location = Point(310, 400);//..
        btn2->Click += new EventHandler(this, &CppForm::Btn2_Clicked);
        Controls->Add(btn2);//..
		                    //..

		// idem pour 3eme bouton
        btn3 = new Button();
        btn3->Text = S"Connexion";//..

        btn3->Size = System::Drawing::Size(120, 25);//..
		btn3->Location = Point(50, 220);//..
		btn3->Font = new System::Drawing::Font(S"Verdana", 12, FontStyle::Bold);;//l'objet Font est sauvegard dans l'objet LabelFont grce au pointeur
        btn3->ForeColor = Color::Brown;

        btn3->Click += new EventHandler(this, &CppForm::Btn3_Clicked);
        Controls->Add(btn3);//..
		                    //..
		// idem pour 4eme bouton
        btn4 = new Button();
        btn4->Text = S"Ecriture";//..

        btn4->Size = System::Drawing::Size(120, 25);//..
		btn4->Location = Point(475, 220);//..
		btn4->Font = new System::Drawing::Font(S"Verdana", 12, FontStyle::Bold);;//l'objet Font est sauvegard dans l'objet LabelFont grce au pointeur
        btn4->ForeColor = Color::Brown;

        btn4->Click += new EventHandler(this, &CppForm::Btn4_Clicked);
        Controls->Add(btn4);//..
		                    //..
    }

void CppForm::Setup_Combo ()//configuration de la liste deroulmnte
    {
        // creation
        combo1 = new ComboBox();
        combo1->DropDownStyle = ComboBoxStyle::DropDownList;
//        combo1->Location = Point(20,180);
        combo1->Location = Point(20,280);
    
        // pour ajuster la taille en fonction de la plus longue chaine
        // la valeur 20 correspond  la taille du bouton situ  droite du bouton d'dition
        Label* l1 = new Label();
        l1->Text = S"Automatique";
        combo1->Width = l1->PreferredWidth + 20;
        
        // ajout de qqs chaines et association avec tous les controles du formulaire
        combo1->Items->Add(S"Manuel");
        combo1->Items->Add(S"Automatique");
        combo1->Items->Add(S"...");
        combo1->SelectedIndex = 0;//affiche la 1ere chaine par defaut

        // ajout du groupe dans le formulaire
        Controls->Add(combo1);

        // associe le gestionnaire  liste deroulante.
        combo1->SelectedIndexChanged += new EventHandler(this, &CppForm::Combo1_SelChanged);
    }

void CppForm::Setup_Context_Menu ()//menu contextuel
    {
        // Creation
        popupMenu = new System::Windows::Forms::ContextMenu();

        // Creation des items.
        item_p1 = new MenuItem("UN");
        popupMenu->MenuItems->Add(item_p1);
        item_p2 = new MenuItem("DEUX");
        popupMenu->MenuItems->Add(item_p2);
        item_p3 = new MenuItem("TROIS");
        popupMenu->MenuItems->Add(item_p3);

		//associe le menu contextuel au formulaire
        ContextMenu = popupMenu;
    }

void CppForm::Setup_Group ()//creation et configuration d'un groupe d'options
    {
        // Creation
        gbox = new GroupBox();
        gbox->Text = S"Fonction Code";
		gbox->Size = System::Drawing::Size(200, 150);//taille du groupbox en pixels
        gbox->Location = Point(20, 90);

        // Creation des boutons radio.
        rb1 = new RadioButton();
        rb1->Text = S"Read Coils";
        rb1->Location = Point(10,25);

        rb2 = new RadioButton();
        rb2->Text = S"Write Coils";
        rb2->Location = Point(10,55);

        rb3 = new RadioButton();
        rb3->Text = S"Read Holdings";
        rb3->Location = Point(10,85);
//        rb3->Checked = true;//c'est la valeur par defaut

        rb4 = new RadioButton();
        rb4->Text = S"Write Holdings";
        rb4->Location = Point(10,115);
        rb4->Checked = true;//c'est la valeur par defaut

		// ajout des controles dans le groupe 
        gbox->Controls->Add(rb1);
        gbox->Controls->Add(rb2);
        gbox->Controls->Add(rb3);
        gbox->Controls->Add(rb4);

        // ajout du groupe dans le formulaire.
        Controls->Add(gbox);

        // associe le gestionnaire au groupe d'options
        rb1->Click += new EventHandler(this, &CppForm::Radio_Clicked);
        rb2->Click += new EventHandler(this, &CppForm::Radio_Clicked);
        rb3->Click += new EventHandler(this, &CppForm::Radio_Clicked);
        rb4->Click += new EventHandler(this, &CppForm::Radio_Clicked);
    }

void CppForm::Setup_Label()//description textuelle dans le formulaire
    {
        theLabel = new Label();
        theLabel->AutoSize = true;

        theLabel->Text = S"                    XFEL Supervision Client";//les espaces sont prvus pour inserer uen image

        // definition de la police
 //       labelFont = new System::Drawing::Font(S"Verdana", 20, FontStyle::Italic);
        labelFont = new System::Drawing::Font(S"Arial", 20, FontStyle::Italic);
        theLabel->Font = labelFont;//l'objet Font est sauvegard dans l'objet LabelFont grce au pointeur
        theLabel->ForeColor = Color::Black;

        // taille et emplacement
//        theLabel->Location = Point(300,20);
		theLabel->Location = Point(125,40);
        theLabel->Size = System::Drawing::Size(theLabel->PreferredWidth, 
                                               theLabel->PreferredHeight);

        // ajout de l'image
 //       Bitmap* theImage = new Bitmap("SAVE.BMP");
        Bitmap* theImage = new Bitmap("..//image1.BMP");
        theLabel->Image = theImage;
        theLabel->ImageAlign = ContentAlignment::MiddleLeft;

        // ajout du label dans la collection des controles du formulaire
        Controls->Add(theLabel);
    }

void CppForm::Setup_Menu()//barre de menu
    {
        // Creation de la barre de menu principal
        menuBar = new MainMenu();

        // Cree le menu fichier.
        fileMenu = new MenuItem("&Fichier");
        menuBar->MenuItems->Add(fileMenu);

        // Cree les elements du menu et les affiche.
        item1 = new MenuItem("&A propos...");
		item11 = new MenuItem("&Choisir Serveur...");
		fontDlgItem = new MenuItem("&Choisir la police...");
        item2 = new MenuItem("S&ortie");
        fileMenu->MenuItems->Add(item1);
		fileMenu->MenuItems->Add(item11);
 		fileMenu->MenuItems->Add(fontDlgItem);
        fileMenu->MenuItems->Add(item2);

        // associe le gestionnaire ayx elements du menu.
        item1->Click += new EventHandler(this, &CppForm::MenuItem_Clicked);
        item11->Click += new EventHandler(this, &CppForm::MenuItem_Clicked);
		fontDlgItem->Click += new EventHandler(this, &CppForm::MenuItem_Clicked);
		item2->Click += new EventHandler(this, &CppForm::MenuItem_Clicked);

        // ajoute le menu principal dans le formulaire
        Menu = menuBar;

		//,menu droulant ajout  la barre de menu, puis 2 lments
		actionMenu =new MenuItem("Action");
		menuBar->MenuItems->Add(actionMenu);
		subMenu1=new MenuItem("Faire");
		actionMenu->MenuItems->Add(subMenu1);
		//barre de sparation, le ptr n'est pas sauvegard car le sprateur ne peut tre slectionn
		actionMenu->MenuItems->Add(new MenuItem("-"));
		anotherItem=new MenuItem("lecture serveur");
		actionMenu->MenuItems->Add(anotherItem);
		//cre les 2 lements du menu et les ajoute
		item1_1 =new MenuItem("connexion serveur...");
		item1_2 = new MenuItem("deconnexion serveur...");
		subMenu1->MenuItems->Add(item1_1);
		subMenu1->MenuItems->Add(item1_2);
		//on pourrait aussi utiliser des proprits pour afficher un syumbole..
		//..disant lmen tselectionn (Checked) et griser des lments du menu (Enabled)

        // associe le gestionnaire aux elements du menu.
        anotherItem->Click += new EventHandler(this, &CppForm::MenuItem_Clicked);
        item1_1->Click += new EventHandler(this, &CppForm::MenuItem_Clicked);
        item1_2->Click += new EventHandler(this, &CppForm::MenuItem_Clicked);
    }

void CppForm::Setup_Text()//controle d'edition
    {
        text1 = new TextBox();
        text1->Location = Point(200,110);
        text1->Size = System::Drawing::Size(250,250);
        text1->Multiline = true;

		text1->ReadOnly = true;
//		text1->Text = "Pour se connecter au Serveur : cliquer sur le bouton Connexion \r\n\r\n"
//			"Pour configurer des paramtres : cliquer sur le bouton Ecriture \r\n\r\n";
		text1->Text = "Pour se connecter au Serveur : dans le menu 'Action', cliquer sur 'Faire' puis sur 'connexion serveur'.\r\n\r\n"
			"on peut alors accder aux paramtres : dans le menu 'Action', cliquer sur 'Faire' puis sur 'lecture serveur'\r\n\r\n"
			"ou bien configurer des paramtres : cliquer sur le bouton Ecriture \r\n\r\n";


        Controls->Add(text1);
    }
