<?php // content="text/plain; charset=utf-8"
require_once ('jpgraph/jpgraph.php');
require_once ('jpgraph/jpgraph_line.php');
require_once ('jpgraph/jpgraph_date.php');
require_once ('jpgraph/jpgraph_mgraph.php');

if(isset($_POST['period'])) {
//echo "la periode demandee est " , $_POST['period'];
if (!strcmp($_POST['period'],"1H"))
     $rapport=100;
elseif (!strcmp($_POST['period'],"10H"))
     $rapport=10;
elseif (!strcmp($_POST['period'],"20H"))
     $rapport=5;
elseif (!strcmp($_POST['period'],"50H"))
     $rapport=2;
elseif (!strcmp($_POST['period'],"100H"))
     $rapport=1;
else
     $rapport=100;
//echo "la periode demandee est " , $rapport;


DEFINE('NDATAPOINTS',28000);
DEFINE('SAMPLERATE',300);

$start = time();
$end = $start+(NDATAPOINTS/$rapport)*SAMPLERATE;
$xdata = array();

//read simulation data file
$arrayTime = array();
$arrayValue = array();
$i = 0;
$handle = fopen ("egiga.txt","r");
while (!feof($handle)){
  $fileinfo = fscanf ($handle,"%s %s\t%E\n");
  if ($fileinfo) {
    list($date,$time,$value)=$fileinfo;
    //echo $date . " " . $time . " " . $value . "\n";
    $arrayValue[$i] = $value;
    $arrayTime[$i] = $time;
    //echo $date, " ", $time, " ",$arrayValue[$i],"\n";
    ++$i;
  }
  $fileinfo=NULL;
}
fclose ($handle);


$data_temperature[0] = rand(20,30);
$data_vacuum[0] = rand(100,200);
$data_power[0] = rand(10,30);

for( $i=0; $i < (NDATAPOINTS/$rapport)-1; ++$i ) {
    $data_temperature[$i+1] = $data_temperature[$i] + rand(-4,4);
    if($data_temperature[$i+1] < 10 || $data_temperature[$i+1] > 59)
        $data_temperature[$i+1] = 47;

    //$data_vacuum[$i+1] = $data_vacuum[$i] + rand(-2,2);
    //if($data_vacuum[$i+1] < 0 )
    // $data_vacuum[$i+1] = 0;
    $data_vacuum[$i+1] = $arrayValue[$i]*(1E+9);
 
    $data_power[$i+1] = $data_power[$i] + rand(-1.5,1.5);

    //$xdata[$i] = $start + $i * SAMPLERATE;
    $xdata[$i] = $arrayTime[$i];
    //    echo $data_vacuum[$i], " ", $xdata[$i], "\n";
}
$xdata[$i] = $start + $i * SAMPLERATE;

//DEFINE('BKG_COLOR','lightgray:1.7');
DEFINE('BKG_COLOR','green:1.98');
DEFINE('WIND_HEIGHT',800);
DEFINE('WIND_WIDTH',250);


//------------------------------------------------------------------
// Setup the Temperature graph
//------------------------------------------------------------------
$graph = new Graph(WIND_WIDTH,WIND_HEIGHT);
$graph->SetMarginColor(BKG_COLOR);
$graph->SetScale('datlin',0,60);
$graph->Set90AndMargin(50,10,70,30);
$graph->SetFrame(true,'white',0);
$graph->SetBox();

$graph->title->Set('Temperature');
$graph->title->SetColor('red');
$graph->title->SetFont(FF_FONT1,FS_BOLD,48);
$graph->title->SetMargin(5);

$graph->xaxis->SetFont(FF_FONT0,FS_NORMAL,9);

//$graph->xaxis->scale->SetDateFormat('H:i');
$graph->xaxis->SetTickLabels($xdata);

$graph->xgrid->Show();

$graph->yaxis->SetLabelAngle(90);
$graph->yaxis->SetColor('red');
$graph->yaxis->SetFont(FF_FONT0,FS_NORMAL,9);
$graph->yaxis->SetLabelMargin(0);
$graph->yaxis->scale->SetAutoMin(10);

//$line = new LinePlot($data_temperature,$xdata);
$line = new LinePlot($data_temperature);
$line->SetStepStyle();
$line->SetColor('red');

$graph->AddLine($line);

//$graph->Add($line);

//------------------------------------------------------------------
// Setup the Vacuum graph
//------------------------------------------------------------------
$graph2 = new Graph(WIND_WIDTH-30,WIND_HEIGHT);
//$graph2->SetScale('datlin');
$graph2->SetScale('datlin',+3,+8);
$graph2->Set90AndMargin(5,20,70,30);
$graph2->SetMarginColor(BKG_COLOR);
$graph2->SetFrame(true,'white',0);
$graph2->SetBox();

$graph2->title->Set('Vacuum');
$graph2->title->SetColor('blue');
$graph2->title->SetFont(FF_FONT1,FS_BOLD,48);
$graph2->title->SetMargin(5);

$graph2->xaxis->HideLabels();
$graph2->xgrid->Show();

$graph2->yaxis->SetLabelAngle(90);
$graph2->yaxis->SetColor('blue');
$graph2->yaxis->SetFont(FF_FONT0,FS_NORMAL,9);
$graph2->yaxis->SetLabelMargin(0);
//$graph2->yaxis->scale->SetAutoMin(50);

//$line2 = new LinePlot($data_vacuum,$xdata);
$line2 = new LinePlot($data_vacuum);
$line2->SetStepStyle();
$line2->SetColor('blue');

$graph2->AddLine($line2);

//$graph2->Add($line2);

//------------------------------------------------------------------
// Setup the power graph
//------------------------------------------------------------------
$graph3 = new Graph(WIND_WIDTH-30,WIND_HEIGHT);
$graph3->SetScale('datlin');
$graph3->Set90AndMargin(5,20,70,30);
$graph3->SetMarginColor(BKG_COLOR);
$graph3->SetFrame(true,'white',0);
$graph3->SetBox();

$graph3->title->Set('RF Power');
$graph3->title->SetColor('black');
$graph3->title->SetFont(FF_FONT1,FS_BOLD,48);
$graph3->title->SetMargin(5);

$graph3->xaxis->HideLabels();
$graph3->xgrid->Show();

$graph3->yaxis->SetLabelAngle(90);
$graph3->yaxis->SetColor('black');
$graph3->yaxis->SetFont(FF_FONT0,FS_NORMAL,9);
$graph3->yaxis->SetLabelMargin(0);
$graph3->yaxis->scale->SetAutoMin(-10);

//$line3 = new LinePlot($data_power,$xdata);
$line3 = new LinePlot($data_power);
$line3->SetStepStyle();
$line3->SetColor('black');

$graph3->AddLine($line3);

//$graph3->Add($line3);

//-----------------------
// Create a multigraph
//----------------------
$mgraph = new MGraph();
$mgraph->SetMargin(2,2,2,2);
$mgraph->SetFrame(true,'darkgray',2);
$mgraph->SetFillColor(BKG_COLOR);
$mgraph->Add($graph,0,50);
$mgraph->Add($graph2,250,50);
$mgraph->Add($graph3,460,50);
$mgraph->title->Set('XFEL Stand A August 2013');
$mgraph->title->SetFont(FF_FONT2,FS_BOLD,80);
$mgraph->title->SetMargin(8);
$mgraph->Stroke();
}
else {}

?>
