<?php // content="text/plain; charset=utf-8"
require_once ('jpgraph/jpgraph.php');
require_once ('jpgraph/jpgraph_line.php');

$ydata = array(12,19,3,9,15,10,13,16,9,11,16,14,16,15,19,18,9,15);

// The code to setup a very basic graph
$graph = new Graph(300,250);
$graph->SetScale('intlin');
$graph->SetMargin(30,15,40,30);
$graph->SetMarginColor('white');
$graph->SetFrame(true,'blue',3);

$graph->title->Set('Stand A');
$graph->title->SetFont(FF_FONT0,FS_BOLD,12);

$graph->subtitle->SetFont(FF_FONT0,FS_NORMAL,10);
$graph->subtitle->SetColor('darkred');
$graph->subtitle->Set('"Vacuum Level"');

$graph->SetAxisLabelBackground(LABELBKG_XY,'orange','red','lightblue','red');

// Use font
$graph->xaxis->SetFont(FF_FONT0,FS_NORMAL,9);
$graph->yaxis->SetFont(FF_FONT0,FS_NORMAL,9);
$graph->xgrid->Show();

// Create the plot line
$p1 = new LinePlot($ydata);
$graph->Add($p1);

// Output graph
$graph->Stroke();

?>


