<?php // content="text/plain; charset=utf-8"
require_once ('jpgraph/jpgraph.php');
require_once ('jpgraph/jpgraph_line.php');
require_once ('jpgraph/jpgraph_date.php');
 
// Create a data set in range (50,70) and X-positions
DEFINE('NDATAPOINTS',360);
DEFINE('SAMPLERATE',240); 
$start = time();
//$end = $start+NDATAPOINTS*SAMPLERATE;
$ydata = array();
$xdata = array();

for( $i=0; $i < (NDATAPOINTS/1); ++$i ) {
    $ydata[$i] = rand(50,70);
    $xdata[$i] = $start + $i * SAMPLERATE;
    //$xdata[$i] = time() + $i * SAMPLERATE;
    //echo $xdata[$i]," \n";
    //sleep(1);
}

function maFormatDate(&$aVal) {
    $aVal = date('Y-m-d H:i',$aVal);
}
 
// Apply this format to all time values in the data to prepare it to be display
array_walk($xdata,'maFormatDate');
 
// Create the new graph
$graph = new Graph(600,450);
 
// Fix the Y-scale to go between [0,100] and use date for the x-axis
$graph->SetScale('textlin',0,100);
//$graph->SetScale('textlin');
$graph->title->Set("Example on Date scale");

// Slightly larger than normal margins at the bottom to have room for
// the x-axis labels
$graph->SetMargin(40,40,30,130);
 
// Set the angle for the labels to 90 degrees
$graph->xaxis->SetLabelAngle(90);
 
//$line = new LinePlot($data,$xdata);
$line = new LinePlot($ydata);
$line->SetLegend('Year 2013');
$line->SetFillColor('lightred@0.8');

$graph->xaxis->SetTickLabels($xdata);
$graph->xaxis->SetTextLabelInterval(NDATAPOINTS/10);

//$graph->Add($line);
$line->SetColor('red');
$graph->AddLine($line);


$graph->Stroke();

?>
