/*
 *  libmodbusWrapper.cpp
 *  ModBusKit
 */
//  Copyright 2008 Volitans Software and R Engineering, Inc.
/*
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later version.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.
 
 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA.
 
 These library of functions are designed to enable a program send and
 receive data from a device that communicates using the Modbus protocol.
 */
//
//  This is an Objective-C++ wrapper for libmodbus

#include "libmodbusWrapper.h"
using namespace std;

bool libmodbusWrapper::lmbInitSerial(const char* device, int baud, int parity, int data_bit, int stop_bit)
{
	if (data_bit<5 || data_bit>8)
		return(FALSE);
	if (stop_bit<1 || stop_bit>2)
		return(FALSE);

	switch(parity)
	{
		case k_none:
			modbus_init_rtu(&mb_param, device, baud, "none", data_bit, stop_bit);
			return(TRUE);
		case k_even:
			modbus_init_rtu(&mb_param, device, baud, "even", data_bit, stop_bit);
			return(TRUE);
		case k_odd:
			modbus_init_rtu(&mb_param, device, baud, "odd", data_bit, stop_bit);
			return(TRUE);
		default:
			return(FALSE);
	}
	return(FALSE);
}

bool libmodbusWrapper::lmbInitTCP(const char* device, int port)
{
	if (port<=0)
		modbus_init_tcp(&mb_param, device, MODBUS_TCP_DEFAULT_PORT);
	else 
		modbus_init_tcp(&mb_param, device, port);
		
	return(true);
}

int libmodbusWrapper::lmbConnect()
{
	return(modbus_connect(&mb_param));
}

void libmodbusWrapper::lmbDisconnect()
{
	modbus_close(&mb_param);
}

bool libmodbusWrapper::lmbReadDiscreteInput(int slaveID, int startAddress, int inputCount, uint8_t *data)
{
	int error;
	
	error=read_input_status(&mb_param, slaveID, startAddress, inputCount, data);
	
	if (error>=0)
	{
		errorCode=0;
		return(true);
	}

	errorCode=error;
	return(false);
}

bool libmodbusWrapper::lmbReadCoil(int slaveID, int startAddress, int coilCount, uint8_t *data)
{
	int error;
	
	error=read_coil_status(&mb_param, slaveID, startAddress, coilCount, data);
	
	if (error>=0)
	{
		errorCode=0;
		return(true);
	}

	errorCode=error;
	return(false);
}

bool libmodbusWrapper::lmbWriteSingleCoil(int slaveID, int coilAddress, bool state)
{
	int error;
	
	error=force_single_coil(&mb_param, slaveID, coilAddress, state);
	
	if (error>=0)
	{
		errorCode=0;
		return(true);
	}

	errorCode=error;
	return(false);
}

bool libmodbusWrapper::lmbWriteMultipleCoils(int slaveID, int startAddress, int coilCount, uint8_t *states)
{
	int error;
	
	error=force_multiple_coils(&mb_param, slaveID, startAddress, coilCount, states);
	
	if (error>=0)
	{
		errorCode=0;
		return(true);
	}

	errorCode=error;
	return(false);
}

bool libmodbusWrapper::lmbReadInputRegisters(int slaveID, int startAddress, int registerCount, uint16_t *data)
{
	int error;
	
	error=read_input_registers(&mb_param, slaveID, startAddress, registerCount, data);
	
	if (error>=0)
	{
		errorCode=0;
		return(true);
	}

	errorCode=error;
	return(false);
}

bool libmodbusWrapper::lmbReadHoldingRegisters(int slaveID, int startAddress, int registerCount, uint16_t *data)
{
	int error;
		
	error=read_holding_registers(&mb_param, slaveID, startAddress, registerCount, data);
	
	if (error>=0)
	{
		errorCode=0;
		return(true);
	}

	errorCode=error;
	return(false);
}

bool libmodbusWrapper::lmbWriteSingleHoldingRegister(int slaveID, int registerAddress, uint16_t value)
{
	int error;
	
	error=preset_single_register(&mb_param, slaveID, registerAddress, value);
	
	if (error>=0)
	{
		errorCode=0;
		return(true);
	}

	errorCode=error;
	return(false);
}

bool libmodbusWrapper::lmbWriteMultipleHoldingRegisters(int slaveID, int startAddress, int registerCount, uint16_t *values)
{
	int error;
	
	error=preset_multiple_registers(&mb_param, slaveID, startAddress, registerCount, values);
	
	if (error>=0)
	{
		errorCode=0;
		return(true);
	}

	errorCode=error;
	return(false);
}

int libmodbusWrapper::lmbErrorCode()
{
	return(errorCode);
}

void libmodbusWrapper::lmbSetDebug(bool state)
{
	modbus_set_debug(&mb_param, (int)state);
	debug=state;
}

void libmodbusWrapper::lmbSetRawDataSave(bool state)
{
	modbus_set_raw_data_save(&mb_param, (int)state);
}

int libmodbusWrapper::lmbLastRawQuery(uint8_t *rawQuery)
{
	return(modbus_last_raw_query(&mb_param, rawQuery));
}

int libmodbusWrapper::lmbLastRawResponse(uint8_t *rawResponse)
{
	return(modbus_last_raw_response(&mb_param, rawResponse));
}

int libmodbusWrapper::lmbLastRawQueryLength()
{
	return(modbus_last_raw_query_length(&mb_param));
}

int libmodbusWrapper::lmbLastRawResponseLength()
{
	return(modbus_last_raw_response_length(&mb_param));
}

