/*
 *  libmodbusWrapper.h
 *  ModBusKit
 */
//Created by Matthew Butch on 03/02/08.
//  Copyright 2008 Volitans Software and R Engineering, Inc.
/*
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later version.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.
 
 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA.
 
 These library of functions are designed to enable a program send and
 receive data from a device that communicates using the Modbus protocol.
 */
//
//  This is an C++ wrapper for libmodbus
#ifndef _LIBMODBUSWRAPPER_H_
#define _LIBMODBUSWRAPPER_H_

#include <string.h>
#include <stdio.h>
#include "modbus.h"
using namespace std;

enum {k_unknown=0, k_none, k_odd, k_even};
enum {k_5=5, k_6, k_7, k_8};
enum {k_1=1, k_2};

class libmodbusWrapper 
{
	modbus_param_t mb_param;
	int errorCode;
	bool debug;
	
	public:
		bool lmbInitSerial(const char* device, int baud, int parity, int data_bit, int stop_bit);
		bool lmbInitTCP(const char* device, int port);
		int lmbConnect();
		void lmbDisconnect();
		bool lmbReadDiscreteInput(int slaveID, int startAddress, int inputCount, uint8_t *data);
		bool lmbReadCoil(int slaveID, int startAddress, int coilCount, uint8_t *data);
		bool lmbWriteSingleCoil(int slaveID, int coilAddress, bool state);
		bool lmbWriteMultipleCoils(int slaveID, int startAddress, int coilCount, uint8_t *states);
		bool lmbReadInputRegisters(int slaveID, int startAddress, int registerCount, uint16_t *data);
		bool lmbReadHoldingRegisters(int slaveID, int startAddress, int registerCount, uint16_t *data);
		bool lmbWriteSingleHoldingRegister(int slaveID, int registerAddress, uint16_t value);
		bool lmbWriteMultipleHoldingRegisters(int slaveID, int startAddress, int registerCount, uint16_t *values);
		int lmbErrorCode();
		void lmbSetDebug(bool state);
		void lmbSetRawDataSave(bool state);
		int lmbLastRawQuery(uint8_t *rawQuery);
		int lmbLastRawResponse(uint8_t *rawResponse);
		int libmodbusWrapper::lmbLastRawQueryLength();
		int libmodbusWrapper::lmbLastRawResponseLength();
};

#endif