//
//  ModBusKit.h
//  ModBusKit
//
//  Created by Matthew Butch on 03/02/08.
//  Copyright 2008 Volitans Software and R Engineering, Inc.
/*
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later version.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.
 
 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA.
 
 These library of functions are designed to enable a program send and
 receive data from a device that communicates using the Modbus protocol.
 */
//
//  This is an Objective-C interface to libmodbus

#import <Cocoa/Cocoa.h>
#include <IOKit/IOKitLib.h>
#include <IOKit/serial/IOSerialKeys.h>
#include <IOKit/IOBSD.h>

#import "libmodbusWrapper.h"

@interface ModBusKit : NSObject 
{
	libmodbusWrapper *lmbWrap;
	
	int compatibilityVersionNumber;
	NSString *modbuskitVersionString;
	NSString *libmodbusVersionString;
	NSString *address;
	BOOL outputDebugMessages;
}

- (void) initialize;
- (id) init;
- (id) initWithSerialPort: (NSString *)serialLocation baudRate: (int) baudRate parity: (int) parity dataBits: (int) dataBits stopBits: (int) stopBits;
- (id) initWithTCP: (NSString *)ipAddress port: (int)port;
- (int) compatibilityVersion;
- (NSString *) modbuskitVersion;
- (NSString *) libmodbusVersion;
- (BOOL) setupSerialPort: (NSString *)serialLocation baudRate: (int) baudRate parity: (int) parity dataBits: (int) dataBits stopBits: (int) stopBits;
- (BOOL)setupTCP: (NSString *)ipAddress port: (int)port;
- (int) openConnection;
- (void) closeConnection;
- (NSArray *) readDiscreteInput: (int) slaveID startAddress: (int) startAddress inputCount: (int) inputCount;
- (NSArray *) readCoil: (int) slaveID startAddress: (int) startAddress coilCount: (int) coilCount;
- (BOOL) writeSingleCoil: (int) slaveID coilAddress: (int) coilAddress state: (BOOL) state;
- (BOOL) writeMultipleCoils: (int) slaveID startAddress: (int) startAddress coilCount: (int) coilCount stateData: (NSArray *) stateData;
- (NSArray *) readInputRegisters: (int) slaveID startAddress: (int) startAddress registerCount: (int) registerCount;
- (NSArray *) readHoldingRegisters: (int) slaveID startAddress: (int) startAddress registerCount: (int) registerCount;
- (BOOL) writeSingleHoldingRegister: (int) slaveID registerAddress: (int) registerAddress value: (uint16_t) value;
- (BOOL) writeMultipleHoldingRegisters: (int) slaveID startAddress: (int) startAddress registerCount: (int) registerCount valueData: (NSArray *) valueData;
- (int) getLastError;
- (NSString *) getLastErrorString;
- (NSString *) getAddress;
- (void) setDebug: (BOOL)debugToggle;
- (BOOL) getDebug;
- (void) setSaveRawData: (BOOL)toggle;
- (NSArray *) getLastRawQuery;
- (NSArray *) getLastRawResponse;

+ (NSArray *)scanSerialPorts;
+ (NSString *)getNextSerialPort:(io_iterator_t)serialPortIterator;


@end
