/* ModBusClass */

#import <Cocoa/Cocoa.h>

#import "ModBusKit.h"
#import "Parameter.h"
#import "xfel.h"

@interface ModBusClass : NSWindowController
{
	NSMutableArray* parameters;
	NSMutableArray* modbusValue;
	NSMutableArray* parametersValue;
	NSMutableArray* transferData;

	IBOutlet NSTableView *coilValues;
	IBOutlet NSTableView *registerValues;
    IBOutlet NSTextField *serverName;
    IBOutlet NSTextField *serverStatus;
	IBOutlet NSTextField *mbkVersion;
	IBOutlet ModBusKit *mbKit;
	
	NSRange coilsRange;
	NSRange holdingRegistersRange;
}

- (IBAction)Connect:(id)sender;
- (IBAction)Load:(id)sender;
- (IBAction)ReadCoils:(id)sender;
- (IBAction)WriteCoils:(id)sender;
- (IBAction)ReadHoldingRegisters:(id)sender;
- (IBAction)WriteHoldingRegisters:(id)sender;


-(void)Initialize:(int)sizeArray;
-(void) loadParameters;
-(void) UpdateDatas;
-(NSMutableArray *) parameters;

@end
