//
//  Parameter.m
//  ModBusKit
//
//  Created by Bruno MANSOUX on 20/07/10.
//

#import "Parameter.h"

@implementation Parameter

- (void)dealloc
{
	[super dealloc];
}

- (id)init
{
//	NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];

	if (self = [super init])
	{
		name = @"Parameter";
		address = 0;
		value = 0;
	}
	return self;
}

- (void)encodeWithCoder:(NSCoder *)coder
{
	[coder encodeValueOfObjCType:@encode(unsigned int) at:&address];
	[coder encodeValueOfObjCType:@encode(int) at:&value];
	[coder encodeObject:name];
}

- (id)initWithCoder:(NSCoder *)coder
{
	self = [self init];
	
	[coder decodeValueOfObjCType:@encode(unsigned int) at:&address];
	[coder decodeValueOfObjCType:@encode(int) at:&value];
	name = [[coder decodeObject] retain];
	
    return self;
}

- (NSString *)name
{
	return [[name copy] autorelease];
}

- (NSNumber *)address
{
	return [NSNumber numberWithUnsignedInt:address];
}

- (NSNumber *)value
{
	return [NSNumber numberWithInt:value];
}

- (void)setName:(NSString *)newName 
{
	[name release];
	name = [newName retain];
}

- (void)setAddress:(int)newAddress
{
	address = newAddress;
}

- (void)setValue:(int)newValue
{
	value = newValue;
}


@end
