/* Fonctions interface XWindow pour affichage d'images */

#ifndef PIPIXMAP_H_SEEN
#define PIPIXMAP_H_SEEN

#include "pisysdep.h"

#include PIBWDG_H
#include PICMAP_H

class PIPixmapGen : public PIBaseWdg
{
public:
  enum {ClassId = 5100};

                PIPixmapGen(PIContainerGen *par, char *nom,
                         int sx=10, int sy=10, int px=0, int py=0);
  virtual      ~PIPixmapGen();

  virtual long    kind() {return ClassId; }

  virtual void  SetPixmap(unsigned char *pix, int sx, int sy, bool refr=true);
  void          SetColMap(CMapId cmapid, bool refr=true);
  inline CMapId GetColMapId() { return (cmap->Type()); }; 
  inline int    NbCol() { return(cmap->NCol()); };

protected:
  unsigned char *pixmap;
  int nx, ny;
  PIColorMap* cmap;
};  
  



#endif   /* PIPIXMAP_H_SEEN */


