// This may look like C code, but it is really -*- C++ -*-
// Affichage d'image            R. Ansari  05/95
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#ifndef PIIMAGEBASE_H_SEEN
#define PIIMAGEBASE_H_SEEN

#include "cimage.h"
#include "lut.h"

#include "pisysdep.h"

#include PIPIXMAP_H
#include PISTDWDG_H

class PIImage : public PIPixmap
{

private:
  RzImage * img;

  unsigned char * pixm;
  int xspxm, yspxm;

  LUT * lut;
  int offx, offy;

  int zoom;
  PIPixmap * zow;
  unsigned char * zpixm;
  int xszpxm, yszpxm;

  PILabel * txw;
  int xpav, ypav;
  int xmv0, ymv0;
public:
//  Les methodes 

  PIImage(PIContainerGen *par, char *nom=NULL, 
           int sx=0, int sy=0, int px=0, int py=0);
  ~PIImage();

  void SetImage(RzImage *pim, bool refr=true);
  void SetZoomWin(PIPixmap * zw, bool refr=true);
  inline void SetTextWin(PILabel * tw) { txw = tw; };

  void SetLut(float min, float max, int typlut=kLutType_Lin,
              int lauto=0, bool refr=true);
  void SetLut(LUT *clut, bool refr=true);

  void SetZoom(int zm, bool refr=true);
  void SetOffset(int ox, int oy, bool refr=true);

  virtual void SetColMap(CMapId cmap, bool refr=true);

  inline RzImage * Image() { return(img); }
  inline LUT *     Lut() { return(lut); }
  inline int XPave() { return(xpav); } ;
  inline int YPave() { return(ypav); } ;

  void Apply(bool mw=true);

  virtual void Resize();

  virtual void But1Press(int x, int y);
  virtual void But1Release(int x, int y);
  virtual void Ptr1Move(int x, int y);
  virtual void But2Press(int x, int y);
  virtual void But2Release(int x, int y);
  virtual void Ptr2Move(int x, int y);

private:
      
  unsigned char *  ComputePixmap(int ofx, int ofy, int zm, 
                       int xwsz, int ywsz, unsigned char * opix, 
                       int * oxszp, int * oyszp);
  void ComputePixmap();
  void ComputeZoomPixmap();

  int PosW2Img(int xiw, int yiw, int * xp, int * yp);
  void SetOffset();
  void SetPave();
};

#endif
