#include <stdio.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/cursorfont.h>

#include <X11/IntrinsicP.h>
#include <X11/CoreP.h>

#include "pibwdgx.h"

#include "pixtbaseP.h"
#include "pixtbase.h"


/*  Variables globales pour modifier les GC  */
#define NMAXFONTSZ  5
static XFontStruct * fntst[NMAXFONTSZ][3];
static int fntsz[NMAXFONTSZ] = {8,10,12,14,16};
static  PIFontAtt fntatt[3] = { PI_RomanFont, PI_BoldFont, PI_ItalicFont }; 
#define NMAXCOL  10
static unsigned long colpix[NMAXCOL];
#define NMAXCURS 5 
static Cursor curs[NMAXCURS];


// #define DEBUG_PIBWDGX     Flag pour impression de debug etc ...


/* --Methode-- */
PIBaseWdgX::PIBaseWdgX(PIContainerGen *par, char *nom,
                       int sx, int sy, int px, int py) 
: PIBaseWdgGen(par, nom, sx, sy, px, py)

{
Arg  wargs[3];

Init();

CreateXtWdg(nom, piXtBaseWidgetClass, NULL, sx, sy, px, py);

XtSetArg(wargs[0],PIXNobject,this); 
XtSetArg(wargs[1],XtNbackground, colpix[PI_White]);  
XtSetArg(wargs[2],XtNborderWidth, (Dimension)0);  
XtSetValues(XtWdg(), wargs, 3);

mDefGC = XCreateGC (PIXDisplay(), XtWindow(PIXtTopWdg()), 0, NULL);

SelForeground(PI_Black);
SelBackground(PI_White);
SelLine();
SelFont();
SelPointerShape(PI_ArrowPointer);

Manage();
}


/* --Methode-- */
PIBaseWdgX::~PIBaseWdgX()
{
}

 

/* --Methode-- */
void PIBaseWdgX::ActivatePtrCross()
{
XtTranslations trans;
trans = XtParseTranslationTable
        ("<Enter>: enter_pixtbase() \n <Leave>: leave_pixtbase()");
XtAugmentTranslations(XtWdg(), trans);
//XtFree((char *)trans);

return;
}


/* --Methode-- */
void PIBaseWdgX::ActivateButton(int bid)
{
XtTranslations trans;
char strans[256];
if ((bid<1) || (bid > 3))  return;
sprintf(strans,"<Btn%dDown>: bud%d_pixtbase() \n <Btn%dUp>: buu%d_pixtbase()",
        bid, bid, bid, bid);
trans = XtParseTranslationTable(strans);

XtAugmentTranslations(XtWdg(), trans);
// XtFree((char *)trans);
#ifdef DEBUG_PIBWDGX
printf("PIBaseWdgX::ActivateButton \n%s \n", strans);
#endif
return;
}

/* --Methode-- */
void PIBaseWdgX::ActivateMove(int bid)
{
XtTranslations trans;
char strans[256];
if ((bid<1) || (bid > 3))  return;
sprintf(strans,"<Btn%dMotion>: mov%d_pixtbase()", bid, bid);
//sprintf(strans,"Button%d <PtrMoved>: mov%d_pixtbase()", bid, bid);
trans = XtParseTranslationTable(strans);

XtAugmentTranslations(XtWdg(), trans);
// XtFree((char *)trans);
#ifdef DEBUG_PIBWDGX
printf("PIBaseWdgX::ActivateMove \n%s \n", strans);
#endif
return;
}


/* --Methode-- */
void PIBaseWdgX::ActivateKeyboard()
{
XtTranslations trans;
trans = XtParseTranslationTable("<Key>: keyb_pixtbase()");
XtAugmentTranslations(XtWdg(), trans);
// XtFree((char *)trans);
return;
}

/* --Methode-- */
void PIBaseWdgX::EraseWindow()
{
XClearWindow   (XtDisplay(XtWdg()),XtWindow(XtWdg()) );
return;
}

/* --Methode-- */
void PIBaseWdgX::DrawString(int x, int y, char* s, int pos)
{
XDrawString (XtDisplay (XtWdg()),XtWindow(XtWdg()), 
                  DefGC(), x, y, s, strlen(s));
return;
}

/* --Methode-- */
void PIBaseWdgX::DrawLine(int x1, int y1, int x2, int y2)
{
XDrawLine(XtDisplay (XtWdg()), XtWindow(XtWdg()), DefGC(), x1, y1, x2, y2);
return;
}

/* --Methode-- */
void PIBaseWdgX::DrawBox(int x0, int y0, int dx, int dy)
{
if (dx < 0)  { x0 += dx;  dx = -dx; }
if (dy < 0)  { y0 += dy;  dy = -dy; }
XDrawRectangle(XtDisplay (XtWdg()), XtWindow(XtWdg()), 
               DefGC(), x0, y0, dx, dy);
return;
}

/* --Methode-- */
void PIBaseWdgX::DrawFBox(int x0, int y0, int dx, int dy)
{
if (dx < 0)  { x0 += dx;  dx = -dx; }
if (dy < 0)  { y0 += dy;  dy = -dy; }
XFillRectangle(XtDisplay (XtWdg()), XtWindow(XtWdg()), 
               DefGC(), x0, y0, dx, dy);
return;
}

/* --Methode-- */
void PIBaseWdgX::DrawCircle(int x0, int y0, int r)
{
XDrawArc(XtDisplay (XtWdg()), XtWindow(XtWdg()), DefGC(),
         x0-r, y0-r, 2*r, 2*r, 0, 360*64);
return;
}

/* --Methode-- */
void PIBaseWdgX::DrawFCircle(int x0, int y0, int r)
{
XFillArc(XtDisplay (XtWdg()), XtWindow(XtWdg()), DefGC(),
         x0-r, y0-r, 2*r, 2*r, 0, 360*64);
return;
}

/* --Methode-- */
int PIBaseWdgX::CalcStringWidth(char const* s)
{
return(XTextWidth(mFSt, s, strlen(s)));
}

/* --Methode-- */
void PIBaseWdgX::SelForeground(PIColors col)
{
if ( (col < 0) || (col >= NMAXCOL))  return;
XSetForeground(XtDisplay(XtWdg()), DefGC(), colpix[col]); 
return;
}

/* --Methode-- */
void PIBaseWdgX::SelBackground(PIColors col)
{
if ( (col < 0) || (col >= NMAXCOL))  return;
XSetBackground(XtDisplay(XtWdg()), DefGC(), colpix[col]); 
return;
}

/* --Methode-- */
void PIBaseWdgX::SelFontSzPt(int npt, PIFontAtt att)
{
int dsz,i,isel, j;

isel = 0;
dsz = 9999;
for(i=0; i<NMAXFONTSZ; i++)
  {
  j = npt - fntsz[i];   if (j < 0)  j = -j;
  if (j < dsz)  {  isel = i; dsz = j; }
  }

j = 0;
if (att & PI_RomanFont) j = 0;
if (att & PI_BoldFont) j = 1;
if (att & PI_ItalicFont) j = 2;

SelectFont(isel, j);
}

/* --Methode-- */
void PIBaseWdgX::SelFont(PIFontSize sz, PIFontAtt att)
{
int i,j;
switch (sz)
  {
  case PI_SmallSizeFont:
    i = 0;
    break;
  case PI_NormalSizeFont:
    i = 2;
    break;
  case PI_BigSizeFont:
    i = 4;
    break;
  default:
    i=2;
    break;
  }

j = 0;
if (att & PI_RomanFont) j = 0;
if (att & PI_BoldFont) j = 1;
if (att & PI_ItalicFont) j = 2;

SelectFont(i, j);
}


/* --Methode-- */
void PIBaseWdgX::SelectFont(int isz, int jat)
{
mFAtt = fntatt[jat];
mFSize = fntsz[isz];
mFSt = fntst[isz][jat];
XSetFont(XtDisplay(XtWdg()), DefGC(), fntst[isz][jat]->fid);
return;
}

/* --Methode-- */
void PIBaseWdgX::SelLine(PILineAtt att)
{
unsigned int lt;

switch (att)
  {
  case PI_NormalLine :
    lt = 2;
    break;
  case PI_ThickLine :
    lt = 4;
    break;
  case  PI_ThinLine :
    lt = 0;
    break;
  default:
    lt = 0;
    break;
  }
    
XSetLineAttributes(XtDisplay(XtWdg()), DefGC(), lt, LineSolid, CapNotLast, JoinMiter);

return;
}


/* --Methode-- */
void PIBaseWdgX::SelPointerShape(PIPointer ptr)  
{
if ( (ptr < 0) || (ptr >= NMAXCURS))  return;
if ( XtIsRealized(XtWdg()) )
  XDefineCursor(XtDisplay (XtWdg()), XtWindow(XtWdg()), curs[ptr]);
return;
}



/* --Methode-- */
void PIBaseWdgX::Refresh()
{
if ( (XtIsRealized(XtWdg())) &&  
   (((PIXtBaseWidget)(this->XtWdg()))->core.visible) )        
  { /* EraseWindow(); */ Draw(); }

return;
}


/* --Methode-- */
void PIBaseWdgX::Resize()
{
#ifdef DEBUG_PIBWDGX
printf ("PIBaseWdgX::ReSize %ld %ld NewSize= %d %d\n", 
         (long)(this), (long)(this->XtWdg()), 
         (int)this->XtWdg()->core.width, (int)this->XtWdg()->core.height);
#endif
return;
}

/* --Methode-- */
void PIBaseWdgX::Draw(int /*x0*/, int /*y0*/, int /*dx*/, int /*dy*/)
{
this->Draw();
return;
}

/* --Methode-- */
void PIBaseWdgX::Draw()
{
#ifdef DEBUG_PIBWDGX
this->EraseWindow();
this->DrawFBox(10,10, XSize()*2/3, YSize()*2/3);
#endif
return;
}


/* --Methode-- */
void PIBaseWdgX::Enter()
{
#ifdef DEBUG_PIBWDGX
puts("PIBaseWdgX::Enter() enter notify ");
#endif
return;
}

/* --Methode-- */
void PIBaseWdgX::Leave()
{
#ifdef DEBUG_PIBWDGX
puts("PIBaseWdgX::Leave() leave notify ");
#endif
return;
}


/* --Methode-- */
void PIBaseWdgX::But1Press(int x, int y)
{
#ifdef DEBUG_PIBWDGX
printf ("PIBaseWdgX::But1Press PosX,Y= %d %d \n", x, y);
#endif
return;
}

/* --Methode-- */
void PIBaseWdgX::But1Release(int x, int y)
{
#ifdef DEBUG_PIBWDGX
printf ("PIBaseWdgX::ButReleasePosX,Y= %d %d \n", x, y);
#endif
return;
}

/* --Methode-- */
void PIBaseWdgX::But2Press(int /* x */, int /* y */)
{
return;
}

/* --Methode-- */
void PIBaseWdgX::But2Release(int /* x */, int /* y */)
{
return;
}

/* --Methode-- */
void PIBaseWdgX::But3Press(int /* x */, int /* y */) 
{
return;
}

/* --Methode-- */
void PIBaseWdgX::But3Release(int /* x */, int /* y */) 
{
return;
}


/* --Methode-- */
void PIBaseWdgX::Ptr1Move(int  x, int  y ) 
{
#ifdef DEBUG_PIBWDGX
printf ("PIBaseWdgX::Ptr1Move PosX,Y= %d %d \n", x, y);
#endif
return;
}

/* --Methode-- */
void PIBaseWdgX::Ptr2Move(int /* x */, int /* y */)  
{
return;
}


/* --Methode-- */
void PIBaseWdgX::Ptr3Move(int /* x */, int /* y */)  
{
return;
}

/* --Methode-- */
void PIBaseWdgX::Keyboard(int key, PIKeyModifier kmod)
{

#ifdef DEBUG_PIBWDGX
printf("PIBaseWdgX::Keyboard: Key= %d (%c)  Mod= %d \n", key, (char)key, (int)kmod); 
XSync(XtDisplay(this->XtWdg()), 0);
#endif
return;
}


static bool fgbwdg = false ;

// Le bazar pour recuperer des resources de .Xdefault et autres 
typedef struct 
  {
  String fntFam;
  } myAppData;
static myAppData  apd;

static XtResource resources[] = {
  { "fontFamilyName", "FontFamilyName", XtRString, sizeof(String),
    /*XtOffset(apdp, fntFam)*/ 0, XtRString, "*-helvetica" }
};
 
static char * fnbi_b[4] = { "medium-r-normal", "bold-r-normal", 
                          "medium-o-normal", "medium-i-normal" };

/* --Methode-- */
void PIBaseWdgX::Init()
{
char buff[256];
int i,j,jj,k, count;
char **list;
XFontStruct * defnt;
char * fnbi[3];

if (fgbwdg)  return;
fgbwdg = true;

Display *mdsp;
int scr;
XColor exact,mycol;
Colormap  cmap;

mdsp = PIXDisplay();
scr = XDefaultScreen(mdsp);

XtGetApplicationResources(PIXtTopWdg(), &apd, resources, 
                          XtNumber(resources), NULL, 0);
sprintf(buff,"-%s-*-*-*-*-*-*-*-*-*-*-*-*", apd.fntFam);
list = XListFonts(mdsp, buff, 15, &count);
XFreeFontNames(list);
if (count < 5)
  { 
  printf("PIBaseWdgX::Init %d fonts found for %s , switching to helvetica\n",
         count, apd.fntFam);
  apd.fntFam = "*-helvetica";
  }
sprintf(buff,"-%s-%s-*-*-*-*-*-*-*-*-*", apd.fntFam, fnbi_b[0]);
list = XListFonts(mdsp, buff, 10, &count);
XFreeFontNames(list);
if (count < 2) fnbi[0] = "*-*-*";
else  fnbi[0] = fnbi_b[0];
sprintf(buff,"-%s-%s-*-*-*-*-*-*-*-*-*", apd.fntFam, fnbi_b[1]);
list = XListFonts(mdsp, buff, 10, &count);
XFreeFontNames(list);
if (count < 2) fnbi[1] = "*-*-*";
else  fnbi[1] = fnbi_b[1];
sprintf(buff,"-%s-%s-*-*-*-*-*-*-*-*-*", apd.fntFam, fnbi_b[2]);
list = XListFonts(mdsp, buff, 10, &count);
XFreeFontNames(list);
fnbi[2] = fnbi_b[2];
if (count < 2) 
  {
  sprintf(buff,"-%s-%s-*-*-*-*-*-*-*-*-*", apd.fntFam, fnbi_b[3]);
  list = XListFonts(mdsp, buff, 10, &count);
  XFreeFontNames(list);
  fnbi[2] = fnbi_b[3];
  }
if (count < 2) fnbi[2] = "*-*-*";

sprintf(buff,"-*-fixed-*-*-*-*-14-*-*-*-*-*-*-*");
list = XListFonts(mdsp, buff, 10, &count);
XFreeFontNames(list);
if (count < 1) 
  {  
  sprintf(buff,"fixed");
  list = XListFonts(mdsp, buff, 10, &count);
  XFreeFontNames(list);
  }
if (count < 1) 
  {  
  strcpy(buff,"");
  list = XListFonts(mdsp, buff, 10, &count);
  XFreeFontNames(list);
  printf("PIBaseWdgX::Init/ Erreur, no font found ... \n");
  defnt = NULL;
  }
else defnt = XLoadQueryFont(mdsp, buff);

/* Allocation des fonts */
for (i=0; i<NMAXFONTSZ; i++)
  for (j=0; j<3; j++)
  {
  for (k=0; k<5; k++)
    {
    sprintf(buff,"-%s-%s-*-%d-*-*-*-*-*-*-*", apd.fntFam, fnbi[j], fntsz[i]+k);
    list = XListFonts(mdsp, buff, 10, &count);
    XFreeFontNames(list);
    if (count > 0)  break;
    }
  if (count > 0)
    {  
    fntst[i][j] = XLoadQueryFont(mdsp, buff);
//    printf("PIBaseWdgX::Init:  font %s loaded \n", buff);
    }
  else
    {   
    printf("PIBaseWdgX::Init: Pb font %s \n", buff);    
    fntst[i][j] = defnt;
    }
  }

 
/*  Les couleurs  */
cmap = XDefaultColormap (mdsp, scr);

for(i=0; i<NMAXCOL; i++)  colpix[i] = XWhitePixel(mdsp, scr);
colpix[PI_Black] = XBlackPixel(mdsp, scr);
colpix[PI_White] = XWhitePixel(mdsp, scr);
if ( XAllocNamedColor (mdsp, cmap, "LightGray", &mycol, &exact) )
  colpix[PI_Grey] = mycol.pixel;
if ( XAllocNamedColor (mdsp, cmap, "red", &mycol, &exact) )
  colpix[PI_Red] = mycol.pixel;
if ( XAllocNamedColor (mdsp, cmap, "blue", &mycol, &exact) )
  colpix[PI_Blue] = mycol.pixel;
if ( XAllocNamedColor (mdsp, cmap, "green", &mycol, &exact) )
  colpix[PI_Green] = mycol.pixel;
if ( XAllocNamedColor (mdsp, cmap, "yellow", &mycol, &exact) )
  colpix[PI_Yellow] = mycol.pixel;
if ( XAllocNamedColor (mdsp, cmap, "magenta", &mycol, &exact) )
  colpix[PI_Magenta] = mycol.pixel;

curs[0] = XCreateFontCursor(mdsp, XC_X_cursor);
for(i=1; i<NMAXCURS; i++)  curs[i] = curs[0];

curs[PI_ArrowPointer] =  XCreateFontCursor(mdsp, XC_arrow);
curs[PI_CrossPointer] =  XCreateFontCursor(mdsp, XC_crosshair);
curs[PI_HandPointer] =  XCreateFontCursor(mdsp, XC_hand2);
curs[PI_TDLRArrowPointer] =  XCreateFontCursor(mdsp, XC_fleur);

return;
}
