#include <stdio.h>

#include "pigraphps.h"


/* --Methode-- */
PIGraphicPS::PIGraphicPS(PSFile * psf, PIWdg* wdg, float ofx, float ofy)
: PIGraphicGen()
{
BuildFromPSFile(psf, (float)wdg->XPos()+ofx, (float)wdg->YPos()+ofy, 
                     (float)wdg->XSize(), (float)wdg->YSize() );  
}

/* --Methode-- */
PIGraphicPS::PIGraphicPS(PSFile * psf, float x0, float y0, float dx, float dy)
: PIGraphicGen()
{
BuildFromPSFile(psf, x0, y0, dx, dy);
}

/* --Methode-- */
PIGraphicPS::~PIGraphicPS()
{
mPSOut->EndBloc();
}

/* --Methode-- */
int PIGraphicPS::kind()
{
return PI_PSFileGraphics; 
}


/* --Methode-- */
void PIGraphicPS::BuildFromPSFile(PSFile * psf, float x0, float y0, float dx, float dy)
{
mPSOut = psf;

mGOm = PI_GOCopy;

mFCol = mBCol = PI_Grey;
SelForeground(PI_Black);
SelBackground(PI_White);
mLAtt = PI_ThinLine;
SelLine();
mFAtt = PI_BoldFont;  mFSize = 0;
SelFont();
SelMarker(1, PI_DotMarker);

if (psf) psf->NewBloc(x0, y0, dx, dx, dy, dy);
mXmin = mYmin = 0.;
mXmax = dx;  mYmax = dy;
mFCfMap.red = mFCfMap.blue = mFCfMap.blue = 0;
mBCfMap = mFCfMap; 
}

/* --Methode-- */
void PIGraphicPS::GetGrSpace(PIGrCoord& xmin, PIGrCoord& xmax, PIGrCoord& ymin, PIGrCoord& ymax)
{
xmin = ymin = 0;  
xmax = mXmax; ymax = mYmax;
}

/* --Methode-- */
void PIGraphicPS::Erase(PIGrCoord, PIGrCoord, PIGrCoord, PIGrCoord)
{
return;
}

/* --Methode-- */
void PIGraphicPS::DrawString(PIGrCoord x, PIGrCoord y, char* s, int /*pos*/)
{
if(mPSOut)
  mPSOut->DrawString((float)x,(float)y,s,mFCol,mFAtt,mFSize); /* $CHECK$ PIFontSize ?? */
return;
}

/* --Methode-- */
void PIGraphicPS::DrawOpaqueString(PIGrCoord x, PIGrCoord y, char* s, int /*pos*/)
{
if(mPSOut)
  mPSOut->DrawString((float)x,(float)y,s,mFCol,mFAtt,mFSize); /* $CHECK$ PIFontSize ?? */
return;
}

 
/* --Methode-- */
void PIGraphicPS::DrawLine(PIGrCoord x1, PIGrCoord y1, PIGrCoord x2, PIGrCoord y2)
{
if(mPSOut)
  mPSOut->DrawLine((float)x1,(float)y1,(float)x2,(float)y2,mFCol,mLAtt);
return;
}


/* --Methode-- */
void PIGraphicPS::DrawBox(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy)
{
if(mPSOut)
  mPSOut->DrawBox((float)x0,(float)y0,(float)dx,(float)dy,mFCol,mLAtt);
return;
}

/* --Methode-- */
void PIGraphicPS::DrawFBox(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy)
{
if(mPSOut)
  mPSOut->DrawFBox((float)x0,(float)y0,(float)dx,(float)dy, mFCol, mFCol, mLAtt);
return;
}

/* --Methode-- */
void PIGraphicPS::DrawCircle(PIGrCoord x0, PIGrCoord y0, PIGrCoord r)
{
if(mPSOut)
  mPSOut->DrawCircle((float)x0,(float)y0,(float)r,mFCol,mLAtt);
return;
}

/* --Methode-- */
void PIGraphicPS::DrawFCircle(PIGrCoord x0, PIGrCoord y0, PIGrCoord r)
{
if(mPSOut)
  mPSOut->DrawFCircle((float)x0,(float)y0,(float)r,mFCol,mFCol,mLAtt);
return;
}

/* --Methode-- */
void PIGraphicPS::DrawPolygon(PIGrCoord *x, PIGrCoord *y, int n)
{
int i;
float *xtmp;
float *ytmp;

if(! mPSOut) return;

xtmp = new float[n];
ytmp = new float[n];
for(i=0;i<n;i++){
  xtmp[i] = (float)x[i];
  ytmp[i] = (float)y[i];
}
mPSOut->DrawPolygon(xtmp,ytmp,n,mFCol,mLAtt);
delete[] xtmp;
delete[] ytmp;

return;
}


/* --Methode-- */
void PIGraphicPS::DrawFPolygon(PIGrCoord *x, PIGrCoord *y, int n)
{
int i;
float *xtmp;
float *ytmp;

if(! mPSOut) return;

xtmp = new float[n];
ytmp = new float[n];
for(i=0;i<n;i++){
  xtmp[i] = (float)x[i];
  ytmp[i] = (float)y[i];
}
mPSOut->DrawFPolygon(xtmp,ytmp,n,mFCol,mFCol,mLAtt);
delete[] xtmp;
delete[] ytmp;

return;
}

/* --Methode-- */
void PIGraphicPS::DrawMarker(PIGrCoord x0, PIGrCoord y0)
{
if(mPSOut)
  mPSOut->DrawMarker((float)x0,(float)y0,mMrk,mFCol,mMrkSz);
return;
}

/* --Methode-- */
void PIGraphicPS::DrawMarkers(PIGrCoord *x, PIGrCoord *y, int n)
{
int i;
float *xtmp;
float *ytmp;

if( !mPSOut)  return;

xtmp = new float[n];
ytmp = new float[n];
for(i=0;i<n;i++){
  xtmp[i] = (float)x[i];
  ytmp[i] = (float)y[i];
}
mPSOut->DrawMarkers(xtmp,ytmp,n,mMrk,mFCol, mMrkSz);
delete[] xtmp;
delete[] ytmp;

return;
}


/* --Methode-- */
void PIGraphicPS::DrawPixmap(PIGrCoord x, PIGrCoord y, unsigned char *pix, 
                            int sx, int sy, PIColorMap* cmap)
{
if ( (sx < 1) || (sy < 1) )  return;
if ((pix == NULL) || (cmap == NULL)) return; 
if(mPSOut) 
  mPSOut->Image((float)x, (float)y, (float)sx, (float)sy, sx, sy, pix, cmap);
return;
}

/* --Methode-- */
void PIGraphicPS::SelForeground(PIColors col)
{
mFCol = col;
return;
}

/* --Methode-- */
void PIGraphicPS::SelBackground(PIColors col)
{
mBCol = col;
return;
}

/* --Methode-- */
void PIGraphicPS::SelForeground(PIColorMap& cmap, int cid)
{
mFCfMap = cmap.GetColor(cid);
mFCol = PI_ColorFromMap;
return;
}

/* --Methode-- */
void PIGraphicPS::SelBackground(PIColorMap& cmap, int cid)
{
mBCfMap = cmap.GetColor(cid);
mBCol = PI_ColorFromMap;
return;
}

/* --Methode-- */
void PIGraphicPS::SelGOMode(PIGOMode mod)
{
mGOm = mod;
return;
}

/* --Methode-- */
void PIGraphicPS::SelFontSzPt(int npt, PIFontAtt att)
{
mFSize = npt;
mFAtt = att;
return;
}

static int fntsz[5] = {8,10,12,14,16};

/* --Methode-- */
void PIGraphicPS::SelFont(PIFontSize sz, PIFontAtt att)
{
int i;
switch (sz) {
  case PI_SmallSizeFont:
    i = 0;
    break;
  case PI_NormalSizeFont:
    i = 2;
    break;
  case PI_BigSizeFont:
    i = 4;
    break;
  default:
    i=2;
    break;
  }
mFSize = fntsz[i];
mFAtt = att;
return;
}



/* --Methode-- */
void PIGraphicPS::SelLine(PILineAtt att)
{
mLAtt = att;
return;
}


/* --Methode-- */
void PIGraphicPS::SelMarker(int msz, PIMarker mrk)
{
if (msz > 1)  { mMrk = mrk;  mMrkSz = msz; }
else  { mMrk = PI_DotMarker;  mMrkSz = 1; }
return;
}


/* --Methode-- */
void PIGraphicPS::SetClipRectangle(PIGrCoord /*x0*/, PIGrCoord /*y0*/, PIGrCoord /*dx*/, PIGrCoord /*dy*/)
{
/*  $CHECK$  A FAIRE , voir Nicolas  */
return;
}

/* --Methode-- */
void PIGraphicPS::ClearClipRectangle()
{ 
/*  $CHECK$  A FAIRE , voir Nicolas  */
return;
}

/* --Methode-- */
PIColors  PIGraphicPS::GetForeground() 
{
return (mFCol);
}

/* --Methode-- */
PIColors  PIGraphicPS::GetBackground() 
{
return (mBCol);
}


/* --Methode-- */
PIGOMode   PIGraphicPS::GetGOMode()
{
return (mGOm);
}

/* --Methode-- */
PIFontAtt  PIGraphicPS::GetFontAtt()
{
return (mFAtt);
}

/* --Methode-- */
int        PIGraphicPS::GetFontSize()
{
return (mFSize);
}

/* --Methode-- */
PILineAtt  PIGraphicPS::GetLineAtt()
{
return (mLAtt);
}

/* --Methode-- */
PIMarker   PIGraphicPS::GetMarker()
{
return (mMrk);
}

/* --Methode-- */
int        PIGraphicPS::GetMarkerSize()
{
return (mMrkSz);
}

/* --Methode-- */
int        PIGraphicPS::GetFontHeight(int& asc, int& desc)   
{
/*  $CHECK$  A refaire , voir Nicolas  */
asc = mFSize; desc = 0; 
return(asc+desc);
}


/* --Methode-- */
PIGrCoord PIGraphicPS::CalcStringWidth(char const* s)
{
return((float)(mFSize*strlen(s)));   /*  $CHECK$  Voir Nicolas ! */
}

/* --Methode-- */
void PIGraphicPS::SaveGraphicAtt()
{  
// Pour optimier l'implementation de PIBaseWdgGen
sFCol = mFCol;    sBCol = mBCol;
sGOm = mGOm;
sFAtt = mFAtt;   sFSize = mFSize;
sMrk = mMrk;   sMrkSz = mMrkSz;
return;
}


/* --Methode-- */
void PIGraphicPS::RestoreGraphicAtt()
{
  if (sFCol != PI_ColorFromMap) SelForeground(sFCol);  
// else    A faire Nicolas  
  if (sBCol != PI_ColorFromMap) SelBackground(sBCol);
// else    A faire Nicolas  
  SelGOMode(sGOm);
  SelFontSzPt(sFSize, sFAtt);
  SelLine(sLAtt);
  SelMarker(sMrkSz, sMrk);
  return;
}





