// **********************************************************************
//
// Copyright (c) 2000
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef JTC_HANDLE_I_H
#define JTC_HANDLE_I_H

// ----------------------------------------------------------------------
// JTCHandleT constructors and destructor
// ----------------------------------------------------------------------

template <class T>
JTCHandleT<T>::JTCHandleT(T* tg)
    : tg_(tg)
{
    if(tg_ != 0)
    {
	tg_ -> refMutex_.lock();
	++tg_ -> _jtc_refCount_; // Boost reference count.
	tg_ -> refMutex_.unlock();
    }
}

template <class T>
JTCHandleT<T>::~JTCHandleT()
{
    bool deleteIt = false;
    {
        if(tg_ != 0)
        {
	    tg_ -> refMutex_.lock();
            if(--tg_ -> _jtc_refCount_ == 0)
                deleteIt = true;
	    tg_ -> refMutex_.unlock();
        }
    }
    if(deleteIt)
        delete tg_;
}

// ----------------------------------------------------------------------
// JTCHandle public member implementation
// ----------------------------------------------------------------------
template <class T>
JTCHandleT<T>::JTCHandleT(const JTCHandleT<T>& rhs)
    : tg_(rhs.tg_)
{
    if(tg_ != 0)
    {
	tg_ -> refMutex_.lock();
	++tg_ -> _jtc_refCount_; // Boost reference count.
	tg_ -> refMutex_.unlock();
    }
}


template <class T>
JTCHandleT<T>&
JTCHandleT<T>::operator=(const JTCHandleT<T>& rhs)
{
    bool deleteIt = false;
    {
        if(tg_ == rhs.tg_)
            return *this;
        
        if(tg_ != 0)
        {
	    tg_ -> refMutex_.lock();
            if(--tg_ -> _jtc_refCount_ == 0) // Time to clean out object?
                deleteIt = true;
	    tg_ -> refMutex_.unlock();
        }
    }
    if(deleteIt)
        delete tg_;
        
    tg_ = rhs.tg_; // Copy in RHS contents.
    if(tg_ != 0)
    {
	tg_ -> refMutex_.lock();
	++tg_ -> _jtc_refCount_; // Boost reference count.
	tg_ -> refMutex_.unlock();
    }

    return *this;
}

template <class T> void
JTCHandleT<T>::_jtc_deref()
{
    if (tg_ != 0)
    {
        bool deleteIt = false;
        {
	    tg_ -> refMutex_.lock();
            if (--tg_ -> _jtc_refCount_ == 0)
                deleteIt = true;
	    tg_ -> refMutex_.unlock();
        }
        if(deleteIt)
            delete tg_;
        tg_ = 0;
    }
}

#endif
