// **********************************************************************
//
// Copyright (c) 2000
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef JTC_MONITOR_H
#define JTC_MONITOR_H

//
// A monitor is used to ensure that only one thread can have access to
// the internals of an object at one time. Use the class
// JTCSynchronized to automatically lock and unlock a monitor.
//
// The JTCMonitor class also provides an efficient way of notification
// and suspension of threads. The wait method waits for a notification
// by another thread. A thread may notify a waiting object with the
// notify call. A thread may notify all waiting objects with the
// notifyAll call.
//
class JTCMonitor
{
    //
    // Hide copy constructor and assignment operator.
    //
    JTCMonitor(const JTCMonitor&);
    void operator=(const JTCMonitor&);

    friend class JTCSynchronized;

    //
    // Validate that the monitor is locked by the calling thread.
    //
    void validateMutexOwner(const char*) const;

    //
    // Lock the monitors mutex. If internal is set the do not check
    // the threads exit status.
    //
    void lock(bool) const;

    //
    // Unlock the monitors mutex.
    //
    void unlock() const;

    JTCRecursiveMutex monMutex_; // Monitors mutex.
    JTCCond monCond_; // Monitors condition variable.

#ifdef HAVE_JTC_STOP
    //
    // Was the mutex aquired by an internal JTC method?
    //
    bool internalLock_;
#endif

public:

    JTCMonitor();
    virtual ~JTCMonitor();

    //
    // Wait for notification.
    //
    void wait();

    //
    // Wait for notification, or timeout milliseconds.
    //
    void wait(long);
	
    //
    // Wake one waiting object.
    //
    void notify();

    //
    // Wake all waiting objects.
    //
    void notifyAll();
};

#endif
