// **********************************************************************
//
// Copyright (c) 2000
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef JTC_SYNC_H
#define JTC_SYNC_H

//
// This class is used to lock and unlock a monitor.
//
class JTCSynchronized
{
    //
    // Hide copy constructor and assignment operator.
    //
    JTCSynchronized(const JTCSynchronized&);
    void operator=(const JTCSynchronized&);

    const JTCMonitor* mon_; // Associated monitor.
    const JTCMutex* mut_; // Associated mutex.
    const JTCRecursiveMutex* nrmut_; // Associated recursive mutex.

    enum
    {
	LOCKED_MONITOR,
	LOCKED_MUTEX,
	LOCKED_RECURSIVE_MUTEX
    }
    lockType_; // The lock type

public:

    JTCSynchronized(const JTCMonitor& mon);
    JTCSynchronized(const JTCMonitor& mon, bool internal);
    JTCSynchronized(const JTCMutex& m);
    JTCSynchronized(const JTCRecursiveMutex& m);
    ~JTCSynchronized();
};

//
// Inlining the methods causes problems with CC 7.1 under SGI
//
#if !defined(__sgi)
inline
JTCSynchronized::JTCSynchronized(const JTCMonitor& mon)
    : mon_(&mon), lockType_(LOCKED_MONITOR)
{
    mon_ -> lock(false);
}

inline
JTCSynchronized::JTCSynchronized(const JTCMonitor& mon, bool internal)
    : mon_(&mon), lockType_(LOCKED_MONITOR)
{
    mon_ -> lock(internal);
}

inline
JTCSynchronized::JTCSynchronized(const JTCMutex& m)
    : mut_(&m), lockType_(LOCKED_MUTEX)
{
    mut_ -> lock();
}

inline
JTCSynchronized::JTCSynchronized(const JTCRecursiveMutex& m)
    : nrmut_(&m), lockType_(LOCKED_RECURSIVE_MUTEX)
{
    nrmut_ -> lock();
}

inline
JTCSynchronized::~JTCSynchronized()
{
    switch(lockType_)
    {
    case LOCKED_MONITOR:
	mon_ -> unlock();
	break;
    case LOCKED_MUTEX:
	mut_ -> unlock();
	break;
    case LOCKED_RECURSIVE_MUTEX:
	nrmut_ -> unlock();
	break;
    }
}
#endif

#endif
