// **********************************************************************
//
// Copyright (c) 2000
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#include <JTC/Types.h>
#include <JTC/Exception.h>
#include <JTC/Syscall.h>
#include <JTC/Mutex.h>
#include <JTC/TSS.h>

#include <TSSManager.h>

#include <assert.h>

//
// Static members
//
JTCTSSManager* JTCTSSManager::instance_ = 0;

// ----------------------------------------------------------------------
// JTCTSSManager constructor/destructor
// ----------------------------------------------------------------------

JTCTSSManager::JTCTSSManager()
    : head_(0)
{
    assert(instance_ == 0);
    instance_ = this;
}

JTCTSSManager::~JTCTSSManager()
{
    assert(instance_ != 0);
    instance_ = 0;
}

// ----------------------------------------------------------------------
// JTCTSSManager public member implementation
// ----------------------------------------------------------------------

JTCTSSManager*
JTCTSSManager::instance()
{
    return instance_;
}

//
// Associate a key and a cleanup function
//
void
JTCTSSManager::allocate(JTCThreadKey key, void(*release)(void*))
{
    mut_.lock();

    KeyCleanup* node = new KeyCleanup;
    node -> key = key;
    node -> release = release;
    node -> next = head_;
    head_ = node;

    mut_.unlock();
}

//
// Remove the key from our internal table
//
void
JTCTSSManager::release(JTCThreadKey key)
{
    mut_.lock();

    KeyCleanup** node = &head_;
    while(*node != 0)
    {
        if((*node) -> key == key)
            break;
        node = &(*node) -> next;
    }
    if(*node != 0)
    {
        KeyCleanup* tmp = *node;
        *node = (*node) -> next;
        delete tmp;
    }

    mut_.unlock();
}

//
// Run the cleanup functions
//
void
JTCTSSManager::cleanup()
{
    mut_.lock();

    KeyCleanup* node = head_;
    while(node != 0)
    {
        void* data = JTCTSS::get(node -> key);
        (*node -> release)(data);
        JTCTSS::set(node -> key, 0);
        node = node -> next;
    }

    mut_.unlock();
}
