// **********************************************************************
//
// Copyright (c) 2000
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef JTC_TSS_MANAGER_H
#define JTC_TSS_MANAGER_H

//
// This class is needed under WIN32 since there are no native support
// for thread specific data cleanup. Although POSIX threads have
// support for associating destructor functions with a thread key they
// cannot be used. This is because the destructor functions have to
// run before the thread terminates since any thread joins will occur
// before the thread terminates.
//
class JTCTSSManager
{
    struct KeyCleanup
    {
        JTCThreadKey key;
        void (*release)(void*);

        KeyCleanup* next;
    };

    KeyCleanup* head_; // Head of the cleanup queue
    JTCMutex mut_;

    static JTCTSSManager* instance_;
    
public:

    JTCTSSManager();
    ~JTCTSSManager();

    //
    // Get the singleton
    //
    static JTCTSSManager* instance();

    //
    // Associate a key and a cleanup function
    //
    void allocate(JTCThreadKey key, void(*)(void*));

    //
    // Remove the key from our internal table
    void release(JTCThreadKey);

    //
    // Run the cleanup functions
    //
    void cleanup();
};
#endif
