// **********************************************************************
//
// Copyright (c) 2000
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef JTC_COND_H
#define JTC_COND_H

//
// This class acts like a pthreads condition variable. The difference
// is that this implementation works with the recursive mutex
// implementation in this library.
//
class JTCCond
{
    //
    // Actual implementation of wait.
    //
    void _wait(long timeout);

    //
    // Hide copy constructor and assignment operator.
    //
    JTCCond(const JTCCond&);
    void operator=(const JTCCond&);

    JTCRecursiveMutex& mutex_; // Associated mutex.
#if defined(HAVE_POSIX_THREADS) || defined(HAVE_DCE_THREADS)
    pthread_cond_t cond_; // Pthread condition variable.
#endif

#if defined(HAVE_WIN32_THREADS)
    DWORD waiters_; // Number of waiters.
    HANDLE sema_; // Handle to WIN32 sempahore object.
    JTCMutex waitersMutex_;
    JTCEvent broadcastEvent_;
    bool haveBroadcast_;
#endif

public:

    JTCCond(JTCRecursiveMutex& mut);
    ~JTCCond();

    //
    // Wait for the condition variable to be signalled.
    // The mutex has to be set.
    //
    void wait(long timeout);

    //
    // Wait for the condition variable to be signalled.
    // The mutex has to be set.
    //
    void wait();

    //
    // Signal one waiting thread.
    //
    void signal();

    //
    // Signal all waiting threads.
    //
    void broadcast();
};

#endif
