// **********************************************************************
//
// Copyright (c) 2000
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef JTC_EVENT_H
#define JTC_EVENT_H

//
// This is an internal class to JTC. Do not directly use. This class
// acts like an event object under WIN32. This is a synchronization
// object that allows one thread to notify another that an event has
// occurred.
//
class JTCEvent
{
    //
    // Hide copy constructor and assignment operator.
    //
    JTCEvent(const JTCEvent&);
    void operator=(const JTCEvent&);

#if defined(HAVE_POSIX_THREADS) || defined(HAVE_DCE_THREADS)
    pthread_cond_t cond_; // Associated condition variable.
    JTCMutex mut_; // Condition variables mutex.
    bool posted_; // State flag for signalled/unsignalled.
#endif

#if defined(HAVE_WIN32_THREADS)
    HANDLE event_; // Handle to event object.
#endif

public:

    JTCEvent();
    ~JTCEvent();

    //
    // Set the event to `signaled'.
    //
    void post();

    //
    // Set the state to `signaled', Release any waiting threads,
    //
    void pulse();

    //
    // Suspend the calling thread until the event is `signaled'.
    //
    void wait();

    //
    // Set the state to `unsignaled'.
    //
    void reset();

    //
    // Return true if the event is `signaled', false otherwise.
    //
    bool posted();
};

#endif
