// **********************************************************************
//
// Copyright (c) 2000
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#include <JTC/JTC.h>

#include <time.h>

#ifdef HAVE_STD_IOSTREAM
using namespace std;
#endif

//
// This class will display the time every 100 milliseconds until
// stopped.
//
class Clock : public JTCRunnable
{
    JTCThreadHandle timer_; // The thread that this class runs in.

public:

    //
    // Constructor.
    //
    Clock()
    {
    }

    //
    // Display the current time.
    //
    void repaint()
    {
	time_t t = time(0);

	//
	// The more observant will note that ctime_r should be used
	// under a multi-threaded environment (UNIX). However, for
	// this test ctime can safely be used since it is known that
	// only this thread will call the function.
	//
	cout << ctime(&t) << endl;
    }

    //
    // Called when the thread is started.
    //
    void run()
    {
        //
        // While the thread is non-zero continue.
        //
	while(timer_)
	{
            //
            // Sleep for 100 milliseconds.
            //
            try
            {
                timer_ -> sleep(100);
            }
            catch(const JTCInterruptedException&)
            {
            }
            //
            // Repaint the time.
            //
	    repaint();
	}
    }

    //
    // Start the thread.
    //
    void start()
    {
	if(!timer_)
	{
            //
            // Create a new thread with this as the Runnable
            // argument.
            //
	    timer_ = new JTCThread(JTCRunnableHandle(this));
            //
            // Start the thread running.
            //
	    timer_ -> start();
	}
    }

    //
    // To stop the thread, mark the thread as invalid.
    //
    void stop()
    {
	timer_ = JTCThreadHandle();
    }
};

#ifndef HAVE_NO_EXPLICIT_TEMPLATES
template class JTCHandleT<Clock>;
#else
#  ifdef HAVE_PRAGMA_DEFINE
#    pragma define(JTCHandleT<Clock>)
#  endif
#endif

int
main(int argc, char** argv)
{
    try
    {
        //
        // A user of the JTC library must create an instance of this
        // class to initialize the library.
        //
	JTCInitialize bootJTC(argc, argv);
        //
        // Create a new instance of the clock class.
        //
	JTCHandleT<Clock> c = new Clock();
        //
        // Start the clock thread running.
        //
	c -> start();
        //
        // Put the main thread to sleep for 5 seconds.
        //
	JTCThread::sleep(1000*5);
        //
        // Stop the clock thread.
        //
	c -> stop();
        //
        // The instance of the JTCInitialize class will ensure that
        // this block is not exited until all threads terminate.
        //
    }
    catch(const JTCException& e)
    {
	cerr << "JTCException: " << e.getMessage() << endl;
    }

    return 0;
}
