#ifndef PIGRAPHICX_H_SEEN
#define PIGRAPHICX_H_SEEN

#include "pisysdep.h"
#include "pigraphgen.h"

class PIGraphicX : public PIGraphicGen
{
public:
                     PIGraphicX(PIWdg* wdg);
  virtual           ~PIGraphicX();

//  Trace graphiques
  virtual void       Erase(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy);
  virtual void       DrawString(PIGrCoord x, PIGrCoord y, char* s, int pos = 0);
  virtual void       DrawOpaqueString(PIGrCoord x, PIGrCoord y, char* s, int pos = 0);
  virtual void       DrawLine(PIGrCoord x1, PIGrCoord y1, PIGrCoord x2, PIGrCoord y2);
  virtual void       DrawBox(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy);
  virtual void       DrawFBox(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy);
  virtual void       DrawCircle(PIGrCoord x0, PIGrCoord y0, PIGrCoord r);
  virtual void       DrawFCircle(PIGrCoord x0, PIGrCoord y0, PIGrCoord r);
  virtual void       DrawPolygon(PIGrCoord *x, PIGrCoord *y, int n);  
  virtual void       DrawFPolygon(PIGrCoord *x, PIGrCoord *y, int n);  
  virtual void       DrawMarker(PIGrCoord x0, PIGrCoord y0);
  virtual void       DrawMarkers(PIGrCoord *x, PIGrCoord *y, int n);
  virtual void       DrawPixmap(PIGrCoord x, PIGrCoord y, unsigned char *pix, 
                                int sx, int sy, PIColorMap* cmap);

// Modifications attributs graphiques
  virtual void       SelForeground(PIColors col=PI_Black);
  virtual void       SelBackground(PIColors col=PI_White);
  virtual void       SelForeground(PIColorMap& cmap, int cid);
  virtual void       SelBackground(PIColorMap& cmap, int cid);
  virtual void       SelGOMode(PIGOMode mod=PI_GOCopy);
  virtual void       SelFont(PIFontSize sz=PI_NormalSizeFont, 
                             PIFontAtt att=PI_RomanFont);
  virtual void       SelFontSzPt(int npt=12, PIFontAtt att=PI_RomanFont);
  virtual void       SelLine(PILineAtt att=PI_NormalLine);
  virtual void       SelMarker(int msz=3, PIMarker mrk=PI_DotMarker);

// Selection de zone de trace (clip)
  virtual void       SetClipRectangle(PIGrCoord x0, PIGrCoord y0, PIGrCoord dx, PIGrCoord dy);
  virtual void       ClearClipRectangle();

// Acces aux attributs graphiques 
  virtual PIColors   GetForeground();
  virtual PIColors   GetBackground();
  virtual PIGOMode   GetGOMode();
  virtual PIFontAtt  GetFontAtt();
  virtual int        GetFontSize();
  virtual PILineAtt  GetLineAtt();
  virtual PIMarker   GetMarker();
  virtual int        GetMarkerSize();

  virtual int        GetFontHeight(int& asc, int& desc);
  virtual PIGrCoord  CalcStringWidth(char const* s);

// Sauvegarde des attributs graphiques 
  virtual void       SaveGraphicAtt();
  virtual void       RestoreGraphicAtt();

//  Pour recuperer le pixcol d une couleur  (pour X) 
  PIXColor           GetPixelValueforColor(PIColors col);
protected:
  void           Init();
  void           SelectFont(int isz, int jat);
  inline  GC     DefGC() { return mDefGC; }
  inline SysDWdg MyWdg()  {return(myWdg->XtWdg()); }
  inline void    SelectBCol(PIXColor col) 
    {XSetBackground(XtDisplay(MyWdg()), DefGC(), col);  mBCol = PI_ColorFromMap; mBCfMap = col; }
  inline void    SelectFCol(PIXColor col) 
    {XSetForeground(XtDisplay(MyWdg()), DefGC(), col);  mFCol = PI_ColorFromMap; mFCfMap = col; }


  GC mDefGC;
  PIColors  mFCol, mBCol;
  PIGOMode mGOm;
  PIFontAtt mFAtt;
  PILineAtt mLAtt;
  int mFSize;
  XFontStruct *mFSt;
  PIMarker mMrk;
  int mMrkSz;
  PIXColor mFCfMap, mBCfMap;
  PIXColor sFCfMap, sBCfMap;
};

typedef PIGraphicX PIGraphicWin;

#endif
