// Guy Le Meur 03/2000


#ifndef FITSNTuple_SEEN
#define FITSNTuple_SEEN
#include "ntuple.h"
#include "anydataobj.h"
#include "ppersist.h"
#include "fitsfile.h"

namespace SOPHYA {
///////////////////////////////////////////////////////////////////
// Classe pour la gestion de persistance sur fichiers fits
// pout NTuple 
////////////////////////////////////////////////////////////////
class  FITS_NTuple : public FitsFile  
{

public:

FITS_NTuple();
FITS_NTuple(char inputfile[],int hdunum=2);
FITS_NTuple(const NTuple & obj);
 FITS_NTuple(NTuple* obj); 
virtual ~FITS_NTuple();
 void Read(char inputfile[],int hdunum=2);
/*!
fill the XNTuple only with lines from firstLine-th to (firstLine+numberOfLines-1)-th of the FITS-file inputfile.
\param <firstLine>  first line  to be read (the first line of the file is numbered 0)
\param <numberOfLines>  number of lines to be read
*/
 void ReadLines(char inputfile[],int firstLine, int numberOfLines,int hdunum=2);
void Write(char outputfile[], bool OldFile=false);
inline operator NTuple() { return(*dobj_); }

protected:

  // implementation de FitsFile
//virtual void ReadFromFits(FitsFile& fn);
virtual void ReadFromFits();
virtual void WriteToFits();

float*  getColFromObj(int colNr);

 private : 

inline void InitNull()
   {
     fistLineToBeRead_= -1;
     numberOfLinesToBeRead_= -1;
     column_ = NULL;
   }


  // attributs de classe
  NTuple* dobj_;
  bool ownobj_;
  int fistLineToBeRead_;
  int numberOfLinesToBeRead_;
  float* column_;
};
//////////////////////////////////////////////////////////////////


} // Fin du namespace

#endif
