#include "pexceptions.h"
#include "fitsntuple.h"
///////////////////////////////////////////////////////////
//   Les objets delegues pour la gestion de persistance sur fichiers fits 
//    pout NTuple
///////////////////////////////////////////////////////////


#define LONNOM 8
#define LONNOM1  (LONNOM+1)



FITS_NTuple::FITS_NTuple()
{
  dobj_ = new NTuple;
  InitNull();
  ownobj_ = true;
}

FITS_NTuple::FITS_NTuple(char inputfile[],int hdunum)
{
  dobj_ = new NTuple;
  InitNull();
  ownobj_ = true; 

  ReadF(inputfile,hdunum);
}


FITS_NTuple::FITS_NTuple(const NTuple & obj) 
{ 
  dobj_ = new NTuple(obj);
  InitNull();
  ownobj_ = true; 
}
FITS_NTuple::FITS_NTuple(NTuple* obj) 
{ 
  dobj_ = obj;
  InitNull();
  ownobj_ = false; 
}


FITS_NTuple::~FITS_NTuple()
{
  if (ownobj_ && dobj_ != NULL) delete dobj_;
  if (column_ != NULL) delete [] column_;
}

void FITS_NTuple::Read(char inputfile[],int hdunum)
{
  ReadF(inputfile,hdunum);
}
void FITS_NTuple::ReadLines(char inputfile[],int firstLine, int numberOfLines,int hdunum)
{
  fistLineToBeRead_ = firstLine;
  numberOfLinesToBeRead_ = numberOfLines;
  ReadF(inputfile,hdunum);
}



void FITS_NTuple::Write(char outputfile[], bool OldFile)
{
  WriteF(outputfile, OldFile);
}

void FITS_NTuple::ReadFromFits()
{
  //  if (!fn.IsFitsTable())
    if (!IsFitsTable())
    {
      throw PException("ReadFromFits: the fits file seems not to be a bintable nor ASCII table");
    }
  int nbcols, nbentries;
  //  nbcols = fn.NbColsFromFits();
  nbcols = NbColsFromFits();
  nbentries = 0;
  int k;
  //  for (k=0; k<nbcols; k++) nbentries=max( nbentries, fn.NentriesFromFits(k) );
  for (k=0; k<nbcols; k++) nbentries=max( nbentries, NentriesFromFits(k) );
  
  char ** ColName = new char*[nbcols];
  
  for (k=0; k<nbcols;k++) 
    {
      ColName[k] = new char[LONNOM1]; 
      //      strncpy(ColName[k], fn.ColNameFromFits(k).c_str(),LONNOM);
      strncpy(ColName[k], ColNameFromFits(k).c_str(),LONNOM);
      ColName[k][LONNOM] =  '\0';
    }
  for (k=0; k<nbcols;k++)
    {
      //      char ss= fn.ColTypeFromFits(k);
      char ss= ColTypeFromFits(k);
      string type;
      if (ss != 'E') 
	{
	  if (ss == 'D') type= string("double");
	  else
	    if (ss == 'I') type= string("integer");
	    else
	      if (ss == 'A') type = string("char*");
	      else
		type = string("unknown");
	  cout << " WARNING: the column " << k << " on fits file is not float but : " << type << endl;
	} 
    }
  if(dobj_ == NULL) 
    { 
      dobj_= new NTuple(nbcols,ColName);
      ownobj_ = true;      
    }
  else 
    {
      dobj_->Clean();
      (*dobj_) = NTuple(nbcols,ColName);
    }
  for (k=0; k<nbcols;k++) 
    {
      delete [] ColName[k];
    }
  delete [] ColName;
  //   if (column_ != NULL) delete [] column_;
  //  column_ = new float[nbentries];

  // j'initialise le NTuple a zero, pour le dimensionner
  // (SetVal suppose que le ntuple est deja dimensionne)
  r_4* ligne = new r_4[nbcols];
  //  for (k=0; k<nbcols; k++) ligne[k]=0.;
  //  for (k=0; k<nbentries;k++) dobj_->Fill(ligne);
  //  delete [] ligne;

  //%%%%%%
    int firstln, lastln;
    if (numberOfLinesToBeRead_ > 0) 
      {
	firstln = fistLineToBeRead_;
	lastln = firstln + numberOfLinesToBeRead_;
      }
    else
      {
	firstln = 0;
	lastln  = nbentries;
      }
    int numLigne;
    for (numLigne=firstln; numLigne < lastln; numLigne++)
      {
	//	fn.GetBinTabLine(numLigne, ligne);
	GetBinTabLine(numLigne, ligne);
	dobj_->Fill(ligne);
      }
    delete [] ligne;

    //%%%%%%%


    //  for (k=0; k<nbcols;k++) 
    //    {
    //     fn.GetBinTabFCol(column_, nbentries, k);
    //     for (int nent=0; nent<nbentries; nent++) dobj_->SetVal(nent,k, column_[nent]);
    //   }
    //  dobj_->Info()=fn.DVListFromFits();
  dobj_->Info()=DVListFromFits();
}
void FITS_NTuple::WriteToFits()
{
  if(dobj_ == NULL) 
    {
      cout << " WriteToFits:: dobj_= null " << endl;
      return;
    }

  // table will have 'ncols'  columns
  int ncols = dobj_->NVar();

  // table will have 'nrows' rows
  int nentries = dobj_->NEntry();

  // get names and values from the join DVList object
  DVList dvl= dobj_->Info();
  // extension name
  char* extname = "NTuple_Binary_tbl"; 
  dvl.Print();

  char** Noms = new char*[ncols];   
  int k;
  for (k=0; k< ncols; k++)
    {
      Noms[k]= new char[LONNOM1];
      strncpy(Noms[k],dobj_->NomIndex(k),LONNOM1);
    }
  // la librairie fitsio ecrit colonne par colonne 
  char* type= new char[ncols+1];
  for (k=0;k<ncols+1;k++) type[k]='E';
  type[ncols]='\0';
  vector<int> dummy;
  //  fn.makeHeaderBntblOnFits(type,Noms, nentries, ncols, dvl, extname, dummy);
  makeHeaderBntblOnFits(type,Noms, nentries, ncols, dvl, extname, dummy);
   for (k=0; k< ncols; k++)
    {
      delete [] Noms[k];
    }
   delete [] Noms;
   delete [] type;
   for (k=0; k<ncols;k++) putColToFits(k, nentries, getColFromObj(k));

}

float* FITS_NTuple::getColFromObj(int colNr)
{
  if (column_ != NULL)
    {
      delete [] column_;
      column_ = NULL;
    }
  column_ = new float[dobj_->NEntry()];
  for(int j = 0; j < dobj_->NEntry(); j++) column_[j]= dobj_->GetVal(j,colNr);
  return column_;
}
