// Guy Le Meur 06/2000


#ifndef FITSBntblLineReader_SEEN
#define FITSBntblLineReader_SEEN
#include "fitsfile.h"
#include "xntuple.h"

namespace SOPHYA {
///////////////////////////////////////////////////////////
//   Lecture ligne par ligne d'une BINTABLE sur fichier FITS 
//   
///////////////////////////////////////////////////////////

class  FITS_BntblLineReader : public FitsFile  
{

public:
FITS_BntblLineReader();
FITS_BntblLineReader(char inputfile[],int hdunum=2);
~FITS_BntblLineReader();

XNTuple ReadNextLine();
 inline long GetNextLineIndex() const {return nextLineToBeRead_;}
 inline  void SetStartingLineIndex(long n)  { nextLineToBeRead_ = n;}

 inline int status() const {return statusF();};
 inline string getStatus(int status) const {return getErrStatus(status);}; 



protected:

  // implementation de FitsFile
 //  virtual void  ReadFromFits(FitsFile& fn);
  virtual void  ReadFromFits();
virtual void    WriteToFits();

 private :

inline void InitNull()
   {
     nextLineToBeRead_= 0;
     dcount_ = 0;
     fcount_ = 0;
     icount_ = 0;
     ccount_ = 0;
     taille_des_chaines_ = 0;
     ddata_ = NULL;
     fdata_ = NULL;
     idata_ = NULL;
     cdata_ = NULL;
     ColName_ = NULL;
   }
  // attributs de classe
  long nextLineToBeRead_;
  int dcount_;
  int fcount_;
  int icount_;
  int ccount_;
  int  taille_des_chaines_;
  double* ddata_;
  float*  fdata_;
  int*    idata_;
  char**  cdata_;
  char ** ColName_;
};
//////////////////////////////////////////////////////////////////


} // Fin du namespace

#endif
