// Guy Le Meur 03/2000


#ifndef FITSXNTuple_SEEN
#define FITSXNTuple_SEEN
#include "xntuple.h"
#include "anydataobj.h"
#include "ppersist.h"
#include "fitsfile.h"

namespace SOPHYA {
///////////////////////////////////////////////////////////
//   Les objets delegues pour la gestion de persistance sur fichiers fits 
//   pour XNTuple
///////////////////////////////////////////////////////////

class  FITS_XNTuple : public FitsFile  
{

public:
FITS_XNTuple();
FITS_XNTuple(char inputfile[],int hdunum=2);
FITS_XNTuple(const XNTuple & obj);
FITS_XNTuple(XNTuple* obj);
~FITS_XNTuple();
 void Read(char inputfile[],int hdunum=2);

/*!
fill the XNTuple only with lines from firstLine-th to (firstLine+numberOfLines-1)-th of the FITS-file inputfile.
\param <firstLine>  first line  to be read (the first line of the file is numbered 0)
\param <numberOfLines>  number of lines to be read
*/
void ReadLines(char inputfile[],int firstLine, int numberOfLines,int hdunum=2);
void Write(char outputfile[], bool OldFile=false);
inline operator XNTuple() { return(*dobj_); }
inline XNTuple * getObj() { return(dobj_); }

protected:

  // implementation de FitsFile
//  virtual void  ReadFromFits(FitsFile& fn);
 virtual void  ReadFromFits();
virtual void    WriteToFits();
void*   getColFromObj(int colNr);
double* getColDFromObj(int colNr);
float*  getColFFromObj(int colNr);
int*    getColIFromObj(int colNr);
char**  getColSFromObj(int colNr);

 private :

 void Clean();

inline void InitNull()
   {
     fistLineToBeRead_= -1;
     numberOfLinesToBeRead_= -1;
     dcolumn_ = NULL;
     fcolumn_ = NULL;
     icolumn_ = NULL;
     ccolumn_ = NULL;
   }

  // attributs de classe
  XNTuple* dobj_;
  bool    ownobj_;
  int fistLineToBeRead_;
  int numberOfLinesToBeRead_;
  double* dcolumn_;
  float*  fcolumn_;
  int*    icolumn_;
  char**  ccolumn_;
};
//////////////////////////////////////////////////////////////////


} // Fin du namespace

#endif
