#ifndef PIMENUGEN_H_SEEN
#define PIMENUGEN_H_SEEN

#include "pisysdep.h"
#include PIWDG_H

enum PIMenuType { k_PopupMenu = 1, k_PulldownMenu = 2 };


class PIMenuGen : public PIWdg {
public:
  enum {ClassId = 2500};

	          PIMenuGen(PIMsgHandler* par, char* nom, PIMenuType pdpu);
	          ~PIMenuGen();
				   
  virtual void	  AppendItem(char* nom, PIMessage msg, char* sc=NULL)=0;
  virtual void	  AppendCheckItem(char* nom, PIMessage msg, char* sc=NULL)=0;
  virtual void	  AppendPDMenu(PIMenuGen *pdm, char* sc=NULL)=0;

  virtual void    DeleteItem(char *nom)=0;
  virtual void    DeleteItemMsg(PIMessage msg)=0;
  virtual void    DeleteItemNum(int n)=0;

  virtual void    SetSensitivity(char *nom, bool sens=true)=0; 
  virtual void    SetSensitivityMsg(PIMessage msg, bool sens=true)=0; 
  virtual void    SetSensitivityNum(int n, bool sens=true)=0;

  virtual bool    IsSensitive(char *nom)=0;
  virtual bool    IsSensitiveMsg(PIMessage msg)=0;
  virtual bool    IsSensitiveNum(int n)=0;

  virtual void    SetState(char *nom, bool st=false)=0; 
  virtual void    SetStateMsg(PIMessage msg, bool st=false)=0; 
  virtual void    SetStateNum(int n, bool st=false)=0;
 
  virtual bool    GetState(char *nom)=0; 
  virtual bool    GetStateMsg(PIMessage msg)=0; 
  virtual bool    GetStateNum(int n)=0; 

  virtual void    Show()=0;
  virtual void    Show(PIWdg *w, int px, int py)=0;
  virtual void    Hide()=0;

  virtual long    kind() {return ClassId; }
  virtual PIMenuType MType() { return  mMTyp; }

protected:
  PIMenuType mMTyp;
}; 


#endif
