#include "pistdwdggen.h"

/************* PILabelGen ************/

//++
// Class	PILabel
// Lib		PI
// include	pistdwdggen.h
//
//	Composant graphique simple permettant d'afficher une tiquette (texte).
//	"PILabelGen" dfinit l'interface (classe virtuelle pure). Les objets 
//	instancis doivent tre de la classe "PILabel" dclar dans le fichier
//	entte "PISTDWDG_H".
//--
//++
// Links	Parents
// PIWdg
//--

//++
// Titre	Constructeur, mthodes
//--
//++
// PILabel(PIContainerGen* par, char* nom, int sx=10, int sy=10, int px=0, int py=0)
//	Cration d'un objet PILabel ayant un contenu (tiquette) identique  "nom".
// SetLabel(string const& lab)
//	Modifie l'tiquette affiche par l'objet 
//--




PILabelGen::PILabelGen(PIContainerGen *par, char *nom,
                         int sx, int sy, int px, int py)
: PIWdg(par, nom, sx, sy, px, py)
{}

PILabelGen::~PILabelGen()
{}

/************* PIButtonGen ************/
//++
// Class	PIButton
// Lib		PI
// include	pistdwdggen.h
//
//	Composant graphique de type bouton .
//	"PIButtonGen" dfinit l'interface (classe virtuelle pure). Les objets 
//	instancis doivent tre de la classe "PIButton" dclar dans le fichier
//	entte "PISTDWDG_H". Lors de l'activation, le message de l'objet complt
//	par le modifier "PIMsg_Click" est envoy ("Send()"). Le champ "data" 
//	contient le pointeur "NULL".
//--
//++
// Links	Parents
// PIWdg
//--

//++
// Titre	Constructeur, mthodes
//--
//++
// PIButton(PIContainerGen* par, char* nom, PIMessage msg = PIMsg_Click, int sx=10, int sy=10, int px=0, int py=0)
//	Cration d'un objet PIButton avec une tiquette identique  "nom".
// SetLabel(string const& lab)
//	Modifie l'tiquette affiche par l'objet bouton.
//--



PIButtonGen::PIButtonGen(PIContainerGen *par, char *nom, PIMessage msg,
                         int sx, int sy, int px, int py, PIBtnSign bsgn)
: PIWdg(par, nom, sx, sy, px, py)
{
SetMsg(msg);
mSgn = bsgn;
}

PIButtonGen::~PIButtonGen()
{}



/************* PITextGen ************/

PITextGen::PITextGen(PIContainerGen *par, char *nom,
                         int sx, int sy, int px, int py)
: PIWdg(par, nom, sx, sy, px, py)
{}

PITextGen::~PITextGen()
{}




/************* PICheckBoxGen ************/

PICheckBoxGen::PICheckBoxGen(PIContainerGen *par, char *nom, PIMessage msg,
                         int sx, int sy, int px, int py)
: PIWdg(par, nom, sx, sy, px, py)
{
SetMsg(msg);
}

PICheckBoxGen::~PICheckBoxGen()
{}


/************* PIScaleGen ************/

PIScaleGen::PIScaleGen(PIContainerGen *par, char *nom, PIMessage msg, 
                       bool /*horiz*/, int sx, int sy, int px, int py)
: PIWdg(par, nom, sx, sy, px, py) 
{
SetMsg(msg);
}

PIScaleGen::~PIScaleGen()
{}

/************* PIScrollBarGen ************/

PIScrollBarGen::PIScrollBarGen(PIContainerGen *par, char *nom, PIMessage msg, 
                       bool /*horiz*/, int sx, int sy, int px, int py)
: PIWdg(par, nom, sx, sy, px, py) 
{
SetMsg(msg);
}

PIScrollBarGen::~PIScrollBarGen()
{}

